/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin.clouds;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import me.jellysquid.mods.sodium.client.render.immediate.CloudRenderer;
import me.jellysquid.mods.sodium.client.render.vertex.VertexFormatDescription;
import me.jellysquid.mods.sodium.client.render.vertex.formats.ColorVertex;
import net.coderbot.iris.Iris;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.CloudVertex;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.CoreWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ShaderKey;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_758;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CloudRenderer.class})
public abstract class MixinCloudRenderer {
    @Shadow
    private class_5944 clouds;
    @Shadow
    @Final
    private class_758.class_7285 fogData;
    @Unique
    private class_291 vertexBufferWithNormals;
    @Unique
    private int prevCenterCellXIris;
    @Unique
    private int prevCenterCellYIris;
    @Unique
    private int cachedRenderDistanceIris;

    @Shadow
    protected abstract void rebuildGeometry(class_287 var1, int var2, int var3, int var4);

    @Shadow
    protected abstract void applyFogModifiers(class_638 var1, class_758.class_7285 var2, class_746 var3, int var4, float var5);

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void buildIrisVertexBuffer(class_638 class_6382, class_746 class_7462, class_4587 class_45872, Matrix4f matrix4f, float f, float f2, double d, double d2, double d3, CallbackInfo callbackInfo) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            callbackInfo.cancel();
            this.renderIris(class_6382, class_7462, class_45872, matrix4f, f, f2, d, d2, d3);
        }
    }

    public void renderIris(@Nullable class_638 class_6382, class_746 class_7462, class_4587 class_45872, Matrix4f matrix4f, float f, float f2, double d, double d2, double d3) {
        boolean bl;
        if (class_6382 == null) {
            return;
        }
        class_243 class_2432 = class_6382.method_23785(f2);
        float f3 = class_6382.method_28103().method_28108();
        double d4 = (f + f2) * 0.03f;
        double d5 = d + d4;
        double d6 = d3 + 0.33;
        int n = class_310.method_1551().field_1690.method_38521();
        int n2 = Math.max(32, n * 2 + 9);
        int n3 = (int)Math.floor(d5 / 12.0);
        int n4 = (int)Math.floor(d6 / 12.0);
        if (this.vertexBufferWithNormals == null || this.prevCenterCellXIris != n3 || this.prevCenterCellYIris != n4 || this.cachedRenderDistanceIris != n) {
            class_287 class_2872 = class_289.method_1348().method_1349();
            class_2872.method_1328(class_293.class_5596.field_27382, IrisVertexFormats.CLOUDS);
            this.rebuildGeometry(class_2872, n2 + 4, n3, n4);
            if (this.vertexBufferWithNormals == null) {
                this.vertexBufferWithNormals = new class_291();
            }
            this.vertexBufferWithNormals.method_1353();
            this.vertexBufferWithNormals.method_1352(class_2872.method_1326());
            class_291.method_1354();
            this.prevCenterCellXIris = n3;
            this.prevCenterCellYIris = n4;
            this.cachedRenderDistanceIris = n;
        }
        float f4 = RenderSystem.getShaderFogEnd();
        float f5 = RenderSystem.getShaderFogStart();
        this.fogData.field_38341 = n2 * 8;
        this.fogData.field_38340 = n2 * 8 - 16;
        this.applyFogModifiers(class_6382, this.fogData, class_7462, n2 * 8, f2);
        RenderSystem.setShaderFogEnd((float)this.fogData.field_38341);
        RenderSystem.setShaderFogStart((float)this.fogData.field_38340);
        float f6 = (float)(d5 - (double)(n3 * 12));
        float f7 = (float)(d6 - (double)(n4 * 12));
        RenderSystem.enableDepthTest();
        this.vertexBufferWithNormals.method_1353();
        boolean bl2 = bl = d2 < (double)(f3 + 4.5f) && d2 > (double)(f3 - 0.5f);
        if (bl) {
            RenderSystem.disableCull();
        } else {
            RenderSystem.enableCull();
        }
        RenderSystem.disableTexture();
        RenderSystem.setShaderColor((float)((float)class_2432.field_1352), (float)((float)class_2432.field_1351), (float)((float)class_2432.field_1350), (float)0.8f);
        class_45872.method_22903();
        Matrix4f matrix4f2 = class_45872.method_23760().method_23761();
        matrix4f2.translate(-f6, f3 - (float)d2 + 0.33f, -f7);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.vertexBufferWithNormals.method_34427(matrix4f2, matrix4f, this.getClouds());
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)514);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.vertexBufferWithNormals.method_34427(matrix4f2, matrix4f, this.getClouds());
        class_45872.method_22909();
        class_291.method_1354();
        RenderSystem.disableBlend();
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableCull();
        RenderSystem.setShaderFogEnd((float)f4);
        RenderSystem.setShaderFogStart((float)f5);
    }

    @ModifyArg(method={"rebuildGeometry"}, at=@At(value="INVOKE", target="Lorg/lwjgl/system/MemoryStack;nmalloc(I)J"))
    private int allocateNewSize(int n) {
        return IrisApi.getInstance().isShaderPackInUse() ? 480 : n;
    }

    @Inject(method={"writeVertex"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void writeIrisVertex(long l, float f, float f2, float f3, int n, CallbackInfoReturnable<Long> callbackInfoReturnable) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            CloudVertex.write(l, f, f2, f3, n);
            callbackInfoReturnable.setReturnValue((Object)(l + 20L));
        }
    }

    @ModifyArg(method={"rebuildGeometry"}, at=@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/render/vertex/VertexBufferWriter;push(Lorg/lwjgl/system/MemoryStack;JILme/jellysquid/mods/sodium/client/render/vertex/VertexFormatDescription;)V"), index=3)
    private VertexFormatDescription modifyArgIris(VertexFormatDescription vertexFormatDescription) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            return CloudVertex.FORMAT;
        }
        return ColorVertex.FORMAT;
    }

    private class_5944 getClouds() {
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        if (worldRenderingPipeline instanceof CoreWorldRenderingPipeline) {
            return ((CoreWorldRenderingPipeline)worldRenderingPipeline).getShaderMap().getShader(ShaderKey.CLOUDS_SODIUM);
        }
        return this.clouds;
    }
}

