/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr;

import com.mojang.blaze3d.platform.TextureUtil;
import java.util.HashMap;
import java.util.Map;
import net.coderbot.iris.Iris;
import net.coderbot.iris.mixin.texture.AnimatedTextureAccessor;
import net.coderbot.iris.mixin.texture.FrameInfoAccessor;
import net.coderbot.iris.mixin.texture.SpriteContentsAccessor;
import net.coderbot.iris.mixin.texture.TickerAccessor;
import net.coderbot.iris.texture.pbr.PBRAtlasHolder;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.texture.pbr.TextureAtlasExtension;
import net.coderbot.iris.texture.util.TextureExporter;
import net.coderbot.iris.texture.util.TextureManipulationUtil;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7764;
import org.jetbrains.annotations.Nullable;

public class PBRAtlasTexture
extends class_1044 {
    protected final class_1059 atlasTexture;
    protected final PBRType type;
    protected final class_2960 id;
    protected final Map<class_2960, class_1058> sprites = new HashMap<class_2960, class_1058>();
    protected final Map<class_1058, class_7764.class_7765> animationTickers = new HashMap<class_1058, class_7764.class_7765>();

    public PBRAtlasTexture(class_1059 class_10592, PBRType pBRType) {
        this.atlasTexture = class_10592;
        this.type = pBRType;
        this.id = new class_2960(class_10592.method_24106().method_12836(), class_10592.method_24106().method_12832().replace(".png", "") + pBRType.getSuffix() + ".png");
    }

    public PBRType getType() {
        return this.type;
    }

    public class_2960 getAtlasId() {
        return this.id;
    }

    public void addSprite(class_1058 class_10582) {
        this.sprites.put(class_10582.method_45851().method_45816(), class_10582);
        if (class_10582.method_33437() != null) {
            this.animationTickers.put(class_10582, (class_7764.class_7765)class_10582.method_45851().method_45818());
        }
    }

    @Nullable
    public class_1058 getSprite(class_2960 class_29602) {
        return this.sprites.get(class_29602);
    }

    public void clear() {
        this.sprites.clear();
        this.animationTickers.clear();
    }

    public void upload(int n, int n2, int n3) {
        int n4 = this.method_4624();
        TextureUtil.prepareImage((int)n4, (int)n3, (int)n, (int)n2);
        TextureManipulationUtil.fillWithColor(n4, n3, this.type.getDefaultValue());
        for (class_1058 class_10582 : this.sprites.values()) {
            try {
                this.uploadSprite(class_10582);
            }
            catch (Throwable throwable) {
                class_128 class_1282 = class_128.method_560((Throwable)throwable, (String)"Stitching texture atlas");
                class_129 class_1292 = class_1282.method_562("Texture being stitched together");
                class_1292.method_578("Atlas path", (Object)this.id);
                class_1292.method_578("Sprite", (Object)class_10582);
                throw new class_148(class_1282);
            }
        }
        PBRAtlasHolder pBRAtlasHolder = ((TextureAtlasExtension)this.atlasTexture).getOrCreatePBRHolder();
        switch (this.type) {
            case NORMAL: {
                pBRAtlasHolder.setNormalAtlas(this);
                break;
            }
            case SPECULAR: {
                pBRAtlasHolder.setSpecularAtlas(this);
            }
        }
        if (PBRTextureManager.DEBUG) {
            TextureExporter.exportTextures("pbr_debug/atlas", this.id.method_12836() + "_" + this.id.method_12832().replaceAll("/", "_"), n4, n3, n, n2);
        }
    }

    public boolean tryUpload(int n, int n2, int n3) {
        try {
            this.upload(n, n2, n3);
            return true;
        }
        catch (Throwable throwable) {
            Iris.logger.error("Error loading PBR atlas: ", throwable);
            return false;
        }
    }

    protected void uploadSprite(class_1058 class_10582) {
        class_7764.class_5790 class_57902 = ((SpriteContentsAccessor)class_10582.method_45851()).getAnimatedTexture();
        if (class_57902 instanceof AnimatedTextureAccessor && this.animationTickers.containsKey(class_10582) && this.getFrameFromSprite(class_10582) != 0) {
            AnimatedTextureAccessor animatedTextureAccessor = (AnimatedTextureAccessor)class_57902;
            animatedTextureAccessor.invokeUploadFrame(((FrameInfoAccessor)animatedTextureAccessor.getFrames().get(this.getFrameFromSprite(class_10582))).getIndex(), class_10582.method_35806(), class_10582.method_35807());
        }
        class_10582.method_4584();
    }

    public int getFrameFromSprite(class_1058 class_10582) {
        if (this.animationTickers.containsKey(class_10582)) {
            return ((TickerAccessor)this.animationTickers.get(class_10582)).getFrame();
        }
        return 0;
    }

    public int getSubFrameFromSprite(class_1058 class_10582) {
        if (this.animationTickers.containsKey(class_10582)) {
            return ((TickerAccessor)this.animationTickers.get(class_10582)).getSubFrame();
        }
        return 0;
    }

    public void setFrameOnSprite(class_1058 class_10582, int n) {
        if (this.animationTickers.containsKey(class_10582)) {
            ((TickerAccessor)this.animationTickers.get(class_10582)).setFrame(n);
        }
    }

    public void setSubFrameOnSprite(class_1058 class_10582, int n) {
        if (this.animationTickers.containsKey(class_10582)) {
            ((TickerAccessor)this.animationTickers.get(class_10582)).setSubFrame(n);
        }
    }

    public void cycleAnimationFrames() {
        this.method_23207();
        this.animationTickers.forEach((class_10582, class_77652) -> class_77652.method_45824(class_10582.method_35806(), class_10582.method_35807()));
    }

    public void close() {
        PBRAtlasHolder pBRAtlasHolder = ((TextureAtlasExtension)this.atlasTexture).getPBRHolder();
        if (pBRAtlasHolder != null) {
            switch (this.type) {
                case NORMAL: {
                    pBRAtlasHolder.setNormalAtlas(null);
                    break;
                }
                case SPECULAR: {
                    pBRAtlasHolder.setSpecularAtlas(null);
                }
            }
        }
    }

    public void method_4625(class_3300 class_33002) {
    }
}

