/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.render.BaseFallbackConsumer;
import link.infra.indium.renderer.render.BaseMeshConsumer;
import link.infra.indium.renderer.render.BlockRenderInfo;
import link.infra.indium.renderer.render.MatrixRenderContext;
import link.infra.indium.renderer.render.SingleBlockLightDataCache;
import link.infra.indium.renderer.render.VertexConsumerQuadBufferer;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class NonTerrainBlockRenderContext
extends MatrixRenderContext {
    private final BlockRenderInfo blockInfo = new BlockRenderInfo();
    private final SingleBlockLightDataCache lightCache = new SingleBlockLightDataCache();
    private final AoCalculator aoCalc = new AoCalculator(this.blockInfo, this.lightCache);
    private final BaseMeshConsumer meshConsumer = new BaseMeshConsumer(new QuadBufferer(this::outputBuffer), this.blockInfo, this.aoCalc, this::transform);
    private class_4588 bufferBuilder;
    private boolean didOutput = false;
    private class_5819 random;
    private long seed;
    private final Supplier<class_5819> randomSupplier = () -> {
        this.random.method_43052(this.seed);
        return this.random;
    };
    private final BaseFallbackConsumer fallbackConsumer = new BaseFallbackConsumer(new QuadBufferer(this::outputBuffer), this.blockInfo, this.aoCalc, this::transform);

    private class_4588 outputBuffer(class_1921 renderLayer) {
        this.didOutput = true;
        return this.bufferBuilder;
    }

    public boolean render(class_1920 blockView, class_1087 model, class_2680 state, class_2338 pos, class_4587 matrixStack, class_4588 buffer, class_5819 random, long seed, int overlay) {
        this.bufferBuilder = buffer;
        this.matrix = matrixStack.method_23760().method_23761();
        this.normalMatrix = matrixStack.method_23760().method_23762();
        this.random = random;
        this.seed = seed;
        this.overlay = overlay;
        this.didOutput = false;
        this.aoCalc.clear();
        this.blockInfo.setBlockView(blockView);
        this.blockInfo.prepareForBlock(state, pos, model.method_4708(), seed);
        this.lightCache.reset(pos, blockView);
        ((FabricBakedModel)model).emitBlockQuads(blockView, state, pos, this.randomSupplier, (RenderContext)this);
        this.blockInfo.release();
        this.bufferBuilder = null;
        this.random = null;
        this.seed = seed;
        return this.didOutput;
    }

    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    public RenderContext.BakedModelConsumer bakedModelConsumer() {
        return this.fallbackConsumer;
    }

    public QuadEmitter getEmitter() {
        return this.meshConsumer.getEmitter();
    }

    private class QuadBufferer
    extends VertexConsumerQuadBufferer {
        QuadBufferer(Function<class_1921, class_4588> bufferFunc) {
            super(bufferFunc);
        }

        @Override
        protected Matrix4f matrix() {
            return NonTerrainBlockRenderContext.this.matrix;
        }

        @Override
        protected Matrix3f normalMatrix() {
            return NonTerrainBlockRenderContext.this.normalMatrix;
        }

        @Override
        protected int overlay() {
            return NonTerrainBlockRenderContext.this.overlay;
        }
    }
}

