/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.function.Function;
import link.infra.indium.other.SpriteFinderCache;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.BaseQuadRenderer;
import me.jellysquid.mods.sodium.client.model.IndexBufferBuilder;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadWinding;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import org.joml.Vector3fc;

public abstract class ChunkQuadBufferer
implements BaseQuadRenderer.QuadBufferer {
    protected final Function<class_1921, ChunkModelBuilder> builderFunc;
    private ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();

    protected abstract Vector3fc origin();

    protected abstract class_243 blockOffset();

    ChunkQuadBufferer(Function<class_1921, ChunkModelBuilder> builderFunc) {
        this.builderFunc = builderFunc;
    }

    @Override
    public void bufferQuad(MutableQuadViewImpl quad, class_1921 renderLayer) {
        this.bufferQuad(this.builderFunc.apply(renderLayer), quad, this.origin(), this.blockOffset());
    }

    public void bufferQuad(ChunkModelBuilder builder, MutableQuadViewImpl quad, Vector3fc origin, class_243 blockOffset) {
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        class_2350 cullFace = quad.cullFace();
        IndexBufferBuilder indices = builder.getIndexBuffer(cullFace != null ? ModelQuadFacing.fromDirection((class_2350)cullFace) : ModelQuadFacing.UNASSIGNED);
        for (int i = 0; i < 4; ++i) {
            ChunkVertexEncoder.Vertex out = vertices[i];
            out.x = origin.x() + quad.x(i) + (float)blockOffset.method_10216();
            out.y = origin.y() + quad.y(i) + (float)blockOffset.method_10214();
            out.z = origin.z() + quad.z(i) + (float)blockOffset.method_10215();
            int color = quad.spriteColor(i, 0);
            out.color = ColorABGR.pack((int)(color & 0xFF), (int)(color >> 8 & 0xFF), (int)(color >> 16 & 0xFF), (int)(color >> 24 & 0xFF));
            out.u = quad.spriteU(i, 0);
            out.v = quad.spriteV(i, 0);
            out.light = quad.lightmap(i);
        }
        indices.add(builder.getVertexBuffer().push(vertices), ModelQuadWinding.CLOCKWISE);
        class_1058 sprite = quad.cachedSprite();
        if (sprite == null) {
            sprite = SpriteFinderCache.forBlockAtlas().find((QuadView)quad, 0);
        }
        builder.addSprite(sprite);
    }
}

