/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.helper;

import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.minecraft.class_1058;
import net.minecraft.class_2350;

public class TextureHelper {
    private static final float NORMALIZER = 0.0625f;
    private static final VertexModifier[] ROTATIONS = new VertexModifier[]{null, (q, i, t) -> q.sprite(i, t, q.spriteV(i, t), 1.0f - q.spriteU(i, t)), (q, i, t) -> q.sprite(i, t, 1.0f - q.spriteU(i, t), 1.0f - q.spriteV(i, t)), (q, i, t) -> q.sprite(i, t, 1.0f - q.spriteV(i, t), q.spriteU(i, t))};
    private static final VertexModifier[] UVLOCKERS = new VertexModifier[6];

    private TextureHelper() {
    }

    public static void bakeSprite(MutableQuadView quad, int spriteIndex, class_1058 sprite, int bakeFlags) {
        if (quad.nominalFace() != null && (4 & bakeFlags) != 0) {
            TextureHelper.applyModifier(quad, spriteIndex, UVLOCKERS[quad.nominalFace().method_10146()]);
        } else if ((0x20 & bakeFlags) == 0) {
            TextureHelper.applyModifier(quad, spriteIndex, (q, i, t) -> q.sprite(i, t, q.spriteU(i, t) * 0.0625f, q.spriteV(i, t) * 0.0625f));
        }
        int rotation = bakeFlags & 3;
        if (rotation != 0) {
            TextureHelper.applyModifier(quad, spriteIndex, ROTATIONS[rotation]);
        }
        if ((8 & bakeFlags) != 0) {
            TextureHelper.applyModifier(quad, spriteIndex, (q, i, t) -> q.sprite(i, t, 1.0f - q.spriteU(i, t), q.spriteV(i, t)));
        }
        if ((0x10 & bakeFlags) != 0) {
            TextureHelper.applyModifier(quad, spriteIndex, (q, i, t) -> q.sprite(i, t, q.spriteU(i, t), 1.0f - q.spriteV(i, t)));
        }
        TextureHelper.interpolate(quad, spriteIndex, sprite);
    }

    private static void interpolate(MutableQuadView q, int spriteIndex, class_1058 sprite) {
        float uMin = sprite.method_4594();
        float uSpan = sprite.method_4577() - uMin;
        float vMin = sprite.method_4593();
        float vSpan = sprite.method_4575() - vMin;
        for (int i = 0; i < 4; ++i) {
            q.sprite(i, spriteIndex, uMin + q.spriteU(i, spriteIndex) * uSpan, vMin + q.spriteV(i, spriteIndex) * vSpan);
        }
    }

    private static void applyModifier(MutableQuadView quad, int spriteIndex, VertexModifier modifier) {
        for (int i = 0; i < 4; ++i) {
            modifier.apply(quad, i, spriteIndex);
        }
    }

    static {
        TextureHelper.UVLOCKERS[class_2350.field_11034.method_10146()] = (q, i, t) -> q.sprite(i, t, 1.0f - q.z(i), 1.0f - q.y(i));
        TextureHelper.UVLOCKERS[class_2350.field_11039.method_10146()] = (q, i, t) -> q.sprite(i, t, q.z(i), 1.0f - q.y(i));
        TextureHelper.UVLOCKERS[class_2350.field_11043.method_10146()] = (q, i, t) -> q.sprite(i, t, 1.0f - q.x(i), 1.0f - q.y(i));
        TextureHelper.UVLOCKERS[class_2350.field_11035.method_10146()] = (q, i, t) -> q.sprite(i, t, q.x(i), 1.0f - q.y(i));
        TextureHelper.UVLOCKERS[class_2350.field_11033.method_10146()] = (q, i, t) -> q.sprite(i, t, q.x(i), 1.0f - q.z(i));
        TextureHelper.UVLOCKERS[class_2350.field_11036.method_10146()] = (q, i, t) -> q.sprite(i, t, q.x(i), q.z(i));
    }

    @FunctionalInterface
    private static interface VertexModifier {
        public void apply(MutableQuadView var1, int var2, int var3);
    }
}

