/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.example.entity;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1819;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DynamicExampleEntity
extends class_1314
implements GeoEntity {
    private static final RawAnimation BLOCK_LEFT = RawAnimation.begin().thenPlay("attack.block.left");
    private static final RawAnimation BLOCK_RIGHT = RawAnimation.begin().thenPlay("attack.block.right");
    private static final RawAnimation AIM_LEFT_HAND = RawAnimation.begin().thenPlay("pose.aim.left");
    private static final RawAnimation AIM_RIGHT_HAND = RawAnimation.begin().thenPlay("pose.aim.right");
    private static final RawAnimation SPEAR_LEFT_HAND = RawAnimation.begin().thenPlay("pose.spear.left");
    private static final RawAnimation SPEAR_RIGHT_HAND = RawAnimation.begin().thenPlay("pose.spear.right");
    private static final RawAnimation INTERACT_LEFT = RawAnimation.begin().thenPlay("misc.interact.right");
    private static final RawAnimation INTERACT_RIGHT = RawAnimation.begin().thenPlay("misc.interact.right");
    private static final RawAnimation SPEAR_SWING = RawAnimation.begin().thenPlay("attack.spear");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);

    public DynamicExampleEntity(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericIdleController(this), new AnimationController<DynamicExampleEntity>(this, "Body", 20, this::poseBody), new AnimationController<DynamicExampleEntity>(this, "Left Hand", 10, state -> this.predicateHandPose(this.getLeftHand(), state)).triggerableAnim("interact", INTERACT_LEFT), new AnimationController<DynamicExampleEntity>(this, "Right Hand", 10, state -> this.predicateHandPose(this.getRightHand(), state)).triggerableAnim("interact", INTERACT_RIGHT), new AnimationController<DynamicExampleEntity>(this, "Dual Wield Pose", 10, this::poseDualWield), new AnimationController<DynamicExampleEntity>(this, "Dual Wield Attack", 10, this::attackDualWield));
    }

    protected PlayState poseBody(AnimationState<DynamicExampleEntity> state) {
        if (this.isWieldingTwoHandedWeapon()) {
            return PlayState.STOP;
        }
        if (this.method_5765()) {
            state.setAnimation(DefaultAnimations.SIT);
        } else if (this.method_18276()) {
            state.setAnimation(DefaultAnimations.SNEAK);
        }
        return PlayState.CONTINUE;
    }

    protected PlayState predicateHandPose(class_1268 hand, AnimationState<DynamicExampleEntity> state) {
        class_1799 heldStack = this.method_5998(hand);
        if (heldStack.method_7960() || this.isWieldingTwoHandedWeapon()) {
            return PlayState.STOP;
        }
        class_1792 handItem = heldStack.method_7909();
        if (this.method_6039() && (handItem instanceof class_1819 || handItem.method_7853(heldStack) == class_1839.field_8949)) {
            return state.setAndContinue(this.getLeftHand() == hand ? BLOCK_LEFT : BLOCK_RIGHT);
        }
        return PlayState.STOP;
    }

    private PlayState poseDualWield(AnimationState<DynamicExampleEntity> state) {
        if (!this.isWieldingTwoHandedWeapon()) {
            return PlayState.STOP;
        }
        for (class_1799 heldStack : this.method_5877()) {
            class_1839 useAnim = heldStack.method_7909().method_7853(heldStack);
            if (useAnim == class_1839.field_8953 || useAnim == class_1839.field_8947) {
                return state.setAndContinue(this.method_5961() ? AIM_LEFT_HAND : AIM_RIGHT_HAND);
            }
            if (useAnim != class_1839.field_8951) continue;
            return state.setAndContinue(this.method_5961() ? SPEAR_LEFT_HAND : SPEAR_RIGHT_HAND);
        }
        return PlayState.STOP;
    }

    private <E extends GeoAnimatable> PlayState attackDualWield(AnimationState<E> state) {
        if (!this.field_6252 || !this.isWieldingTwoHandedWeapon()) {
            return PlayState.STOP;
        }
        for (class_1799 heldStack : this.method_5877()) {
            if (heldStack.method_7909().method_7853(heldStack) != class_1839.field_8951) continue;
            return state.setAndContinue(SPEAR_SWING);
        }
        return PlayState.STOP;
    }

    public boolean isWieldingTwoHandedWeapon() {
        class_1799 mainHandStack = this.method_6047();
        class_1799 offhandStack = this.method_6079();
        if (mainHandStack.method_7909() instanceof class_1811 || offhandStack.method_7909() instanceof class_1811) {
            return true;
        }
        class_1839 anim = mainHandStack.method_7976();
        if (anim == class_1839.field_8953 || anim == class_1839.field_8947 || anim == class_1839.field_8951) {
            return true;
        }
        anim = offhandStack.method_7976();
        return anim == class_1839.field_8953 || anim == class_1839.field_8947 || anim == class_1839.field_8951;
    }

    protected class_1268 getLeftHand() {
        return this.method_5961() ? class_1268.field_5808 : class_1268.field_5810;
    }

    protected class_1268 getRightHand() {
        return !this.method_5961() ? class_1268.field_5808 : class_1268.field_5810;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.field_6002.method_8608() || stack.method_7960()) {
            return super.method_5992(player, hand);
        }
        class_1304 slot = class_1309.method_32326((class_1799)stack);
        this.method_5673(slot, stack.method_7972());
        player.method_43496((class_2561)class_2561.method_43469((String)"entity.geckolib.mutant_zombie.equip", (Object[])new Object[]{stack.method_7954()}));
        if (slot == class_1304.field_6173 || slot == class_1304.field_6171) {
            this.triggerAnim(this.getLeftHand() == hand ? "Left Hand" : "Right Hand", "interact");
        }
        return class_1269.field_5812;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

