/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam;

import java.util.HashMap;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5498;
import net.minecraft.class_743;
import net.minecraft.class_744;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.util.FreeCamera;
import net.xolt.freecam.util.FreecamPosition;

public class Freecam
implements ClientModInitializer {
    public static final class_310 MC = class_310.method_1551();
    private static class_304 freecamBind;
    private static class_304 playerControlBind;
    private static class_304 tripodResetBind;
    private static boolean freecamEnabled;
    private static boolean tripodEnabled;
    private static boolean playerControlEnabled;
    private static boolean disableNextTick;
    private static Integer activeTripod;
    private static FreeCamera freeCamera;
    private static HashMap<Integer, FreecamPosition> overworld_tripods;
    private static HashMap<Integer, FreecamPosition> nether_tripods;
    private static HashMap<Integer, FreecamPosition> end_tripods;

    public void onInitializeClient() {
        ModConfig.init();
        freecamBind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.freecam.toggle", class_3675.class_307.field_1668, 293, "category.freecam.freecam"));
        playerControlBind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.freecam.playerControl", class_3675.class_307.field_1668, -1, "category.freecam.freecam"));
        tripodResetBind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.freecam.tripodReset", class_3675.class_307.field_1668, -1, "category.freecam.freecam"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (tripodResetBind.method_1434()) {
                for (class_304 hotbarKey : Freecam.MC.field_1690.field_1852) {
                    while (hotbarKey.method_1436()) {
                        Freecam.resetCamera(hotbarKey.method_1429().method_1444());
                        while (tripodResetBind.method_1436()) {
                        }
                    }
                }
            }
            if (freecamBind.method_1434()) {
                for (class_304 hotbarKey : Freecam.MC.field_1690.field_1852) {
                    while (hotbarKey.method_1436()) {
                        Freecam.toggleTripod(hotbarKey.method_1429().method_1444());
                        while (freecamBind.method_1436()) {
                        }
                    }
                }
            } else if (freecamBind.method_1436()) {
                Freecam.toggle();
                while (freecamBind.method_1436()) {
                }
            }
            while (playerControlBind.method_1436()) {
                Freecam.switchControls();
            }
        });
    }

    public static void toggle() {
        if (tripodEnabled) {
            Freecam.toggleTripod(activeTripod);
            return;
        }
        if (freecamEnabled) {
            Freecam.onDisableFreecam();
        } else {
            Freecam.onEnableFreecam();
        }
        freecamEnabled = !freecamEnabled;
    }

    private static void toggleTripod(Integer keyCode) {
        if (keyCode == null) {
            return;
        }
        if (tripodEnabled) {
            if (activeTripod.equals(keyCode)) {
                Freecam.onDisableTripod();
                tripodEnabled = false;
            } else {
                Freecam.onDisableTripod();
                Freecam.onEnableTripod(keyCode);
            }
        } else {
            if (freecamEnabled) {
                Freecam.toggle();
            }
            Freecam.onEnableTripod(keyCode);
            tripodEnabled = true;
        }
    }

    public static void switchControls() {
        if (!Freecam.isEnabled()) {
            return;
        }
        if (playerControlEnabled) {
            Freecam.freeCamera.field_3913 = new class_743(Freecam.MC.field_1690);
        } else {
            Freecam.MC.field_1724.field_3913 = new class_743(Freecam.MC.field_1690);
            Freecam.freeCamera.field_3913 = new class_744();
        }
        playerControlEnabled = !playerControlEnabled;
    }

    private static void onEnableTripod(int keyCode) {
        if (Freecam.MC.field_1687 == null || Freecam.MC.field_1724 == null) {
            return;
        }
        Freecam.onEnable();
        FreecamPosition position = Freecam.getTripodsForDimension().get(keyCode);
        boolean chunkLoaded = false;
        if (position != null) {
            class_1923 chunkPos = position.getChunkPos();
            chunkLoaded = Freecam.MC.field_1687.method_2935().method_12123(chunkPos.field_9181, chunkPos.field_9180);
        }
        if (!chunkLoaded) {
            Freecam.resetCamera(keyCode);
            position = null;
        }
        freeCamera = position == null ? new FreeCamera(-420 - keyCode % 48) : new FreeCamera(-420 - keyCode % 48, position);
        freeCamera.spawn();
        MC.method_1504((class_1297)freeCamera);
        activeTripod = keyCode;
        if (ModConfig.INSTANCE.notifyTripod) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.openTripod").method_27693("" + activeTripod % 48), true);
        }
    }

    private static void onDisableTripod() {
        Freecam.getTripodsForDimension().put(activeTripod, new FreecamPosition((class_1297)freeCamera));
        Freecam.onDisable();
        if (Freecam.MC.field_1724 != null && ModConfig.INSTANCE.notifyTripod) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.closeTripod").method_27693("" + activeTripod % 48), true);
        }
        activeTripod = null;
    }

    private static void onEnableFreecam() {
        if (Freecam.MC.field_1687 == null || Freecam.MC.field_1724 == null) {
            return;
        }
        Freecam.onEnable();
        freeCamera = new FreeCamera(-420);
        freeCamera.spawn();
        MC.method_1504((class_1297)freeCamera);
        if (ModConfig.INSTANCE.notifyFreecam) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.enable"), true);
        }
    }

    private static void onDisableFreecam() {
        Freecam.onDisable();
        if (Freecam.MC.field_1724 != null && ModConfig.INSTANCE.notifyFreecam) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.disable"), true);
        }
    }

    private static void onEnable() {
        Freecam.MC.field_1730 = false;
        Freecam.MC.field_1773.method_35768(ModConfig.INSTANCE.showHand);
        if (Freecam.MC.field_1773.method_19418().method_19333()) {
            Freecam.MC.field_1690.method_31043(class_5498.field_26664);
        }
    }

    private static void onDisable() {
        Freecam.MC.field_1730 = true;
        Freecam.MC.field_1773.method_35768(true);
        MC.method_1504((class_1297)Freecam.MC.field_1724);
        playerControlEnabled = false;
        freeCamera.despawn();
        Freecam.freeCamera.field_3913 = new class_744();
        freeCamera = null;
        if (Freecam.MC.field_1724 != null) {
            Freecam.MC.field_1724.field_3913 = new class_743(Freecam.MC.field_1690);
        }
    }

    private static void resetCamera(int keyCode) {
        if (tripodEnabled && activeTripod == keyCode && freeCamera != null) {
            freeCamera.method_5719((class_1297)Freecam.MC.field_1724);
        } else {
            Freecam.getTripodsForDimension().put(keyCode, null);
        }
        if (ModConfig.INSTANCE.notifyTripod) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.tripodReset").method_27693("" + keyCode % 48), true);
        }
    }

    public static void clearTripods() {
        overworld_tripods = new HashMap();
        nether_tripods = new HashMap();
        end_tripods = new HashMap();
    }

    public static FreeCamera getFreeCamera() {
        return freeCamera;
    }

    public static HashMap<Integer, FreecamPosition> getTripodsForDimension() {
        if (Freecam.MC.field_1687 == null) {
            return overworld_tripods;
        }
        return switch (Freecam.MC.field_1687.method_44013().method_29177().method_12832()) {
            case "the_nether" -> nether_tripods;
            case "the_end" -> end_tripods;
            default -> overworld_tripods;
        };
    }

    public static class_304 getFreecamBind() {
        return freecamBind;
    }

    public static class_304 getTripodResetBind() {
        return tripodResetBind;
    }

    public static boolean disableNextTick() {
        return disableNextTick;
    }

    public static void setDisableNextTick(boolean damage) {
        disableNextTick = damage;
    }

    public static boolean isEnabled() {
        return freecamEnabled || tripodEnabled;
    }

    public static boolean isPlayerControlEnabled() {
        return playerControlEnabled;
    }

    static {
        freecamEnabled = false;
        tripodEnabled = false;
        playerControlEnabled = false;
        disableNextTick = false;
        activeTripod = null;
        overworld_tripods = new HashMap();
        nether_tripods = new HashMap();
        end_tripods = new HashMap();
    }
}

