/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson.api;

import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.api.ActivationHandler;
import dev.tr7zw.firstperson.api.PlayerOffsetHandler;
import java.util.ArrayList;
import java.util.List;

public final class FirstPersonAPI {
    private static List<PlayerOffsetHandler> playerOffsetHandlers = new ArrayList<PlayerOffsetHandler>();
    private static List<ActivationHandler> activationHandlers = new ArrayList<ActivationHandler>();

    private FirstPersonAPI() {
    }

    public static boolean isEnabled() {
        return FirstPersonModelCore.enabled;
    }

    public static void setEnabled(boolean enabled) {
        FirstPersonModelCore.enabled = enabled;
    }

    public static boolean isRenderingPlayer() {
        return FirstPersonModelCore.isRenderingPlayer;
    }

    public static void registerPlayerHandler(Object handler) {
        if (handler instanceof PlayerOffsetHandler) {
            PlayerOffsetHandler offset = (PlayerOffsetHandler)handler;
            playerOffsetHandlers.add(offset);
        }
        if (handler instanceof ActivationHandler) {
            ActivationHandler activation = (ActivationHandler)handler;
            activationHandlers.add(activation);
        }
    }

    public static List<PlayerOffsetHandler> getPlayerOffsetHandlers() {
        return playerOffsetHandlers;
    }

    public static List<ActivationHandler> getActivationHandlers() {
        return activationHandlers;
    }
}

