/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.networking;

import com.wildfire.gui.screen.WildfirePlayerListScreen;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.networking.PacketSendGenderInfo;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_634;

public class PacketSetHidden {
    public static final class_2960 ID = new class_2960("wildfire_gender", "set_hidden");

    public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        boolean hidden;
        UUID uuid;
        short length;
        byte[] rawData = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), rawData);
        try {
            length = buf.readShort();
            if (length < 0 || length > buf.readableBytes()) {
                System.err.println("Invalid string length: " + length + ", raw packet data: " + PacketSetHidden.bytesToHex(rawData));
                return;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to read string length from buffer, raw packet data: " + PacketSetHidden.bytesToHex(rawData));
            return;
        }
        byte[] uuidBytes = new byte[length];
        try {
            buf.readBytes(uuidBytes);
        }
        catch (Exception e) {
            System.err.println("Failed to read UUID bytes from buffer, raw packet data: " + PacketSetHidden.bytesToHex(rawData));
            return;
        }
        String rawUuid = new String(uuidBytes, StandardCharsets.UTF_8);
        try {
            uuid = UUID.fromString(rawUuid);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Failed to parse UUID: " + rawUuid + ", raw packet data: " + PacketSetHidden.bytesToHex(rawData));
            return;
        }
        try {
            hidden = buf.readBoolean();
        }
        catch (Exception e) {
            return;
        }
        client.execute(() -> {
            class_437 patt4701$temp;
            GenderPlayer plr;
            Map<UUID, GenderPlayer> map = WildfireGender.CLOTHING_PLAYERS;
            synchronized (map) {
                plr = WildfireGender.getOrAddPlayerById(uuid);
                plr.updateHidden(hidden);
                WildfireGender.CLOTHING_PLAYERS.put(uuid, plr);
            }
            if (plr.uuid.equals(client.field_1724.method_5667())) {
                GenderPlayer.saveGenderInfo(plr);
                PacketSendGenderInfo.send(plr);
            }
            if ((patt4701$temp = client.field_1755) instanceof WildfirePlayerListScreen) {
                WildfirePlayerListScreen screen = (WildfirePlayerListScreen)patt4701$temp;
                screen.markNeedsRefresh();
            }
        });
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

