/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.networking;

import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.networking.PacketGenderInfo;
import com.wildfire.main.networking.PacketSync;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class PacketSendGenderInfo
extends PacketGenderInfo {
    protected boolean hidden;

    public PacketSendGenderInfo(GenderPlayer plr) {
        super(plr);
        this.hidden = plr.isHidden();
        this.bustSize = Math.max(0.0f, Math.min(1.0f, plr.getBustSize()));
        this.bounceMultiplier = Math.max(0.0f, Math.min(1.0f, plr.getBounceMultiplierRaw()));
        this.floppyMultiplier = Math.max(0.0f, Math.min(1.0f, plr.getFloppiness()));
        this.breasts.updateXOffset(Math.max(-1.0f, Math.min(1.0f, plr.getBreasts().getXOffset())));
        this.breasts.updateYOffset(Math.max(-1.0f, Math.min(1.0f, plr.getBreasts().getYOffset())));
        this.breasts.updateZOffset(Math.max(-1.0f, Math.min(1.0f, plr.getBreasts().getZOffset())));
        this.breasts.updateCleavage(Math.max(0.0f, Math.min(1.0f, plr.getBreasts().getCleavage())));
    }

    public PacketSendGenderInfo(class_2540 buffer) {
        super(buffer);
        this.hidden = buffer.readBoolean();
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10797(this.uuid);
        buf.method_10817((Enum)this.gender);
        buf.writeFloat(this.bustSize);
        buf.writeBoolean(this.hurtSounds);
        buf.writeBoolean(this.breastPhysics);
        buf.writeBoolean(this.showInArmor);
        buf.writeFloat(this.bounceMultiplier);
        buf.writeFloat(this.floppyMultiplier);
        buf.writeFloat(this.breasts.getXOffset());
        buf.writeFloat(this.breasts.getYOffset());
        buf.writeFloat(this.breasts.getZOffset());
        buf.writeBoolean(this.breasts.isUniboob());
        buf.writeFloat(this.breasts.getCleavage());
        buf.writeBoolean(this.hidden);
        byte[] data = buf.copy().array();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void updateHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        byte[] rawData = buf.copy().array();
        if (rawData.length != 52) {
            return;
        }
        UUID uuid = buf.method_10790();
        GenderPlayer.Gender gender = (GenderPlayer.Gender)buf.method_10818(GenderPlayer.Gender.class);
        float bustSize = buf.readFloat();
        if (bustSize < 0.0f || bustSize > 1.0f) {
            return;
        }
        boolean hurtSounds = buf.readBoolean();
        boolean breastPhysics = buf.readBoolean();
        boolean showInArmor = buf.readBoolean();
        float bounceMultiplier = buf.readFloat();
        if (bounceMultiplier < 0.0f || bounceMultiplier > 1.0f) {
            return;
        }
        float floppyMultiplier = buf.readFloat();
        if (floppyMultiplier < 0.0f || floppyMultiplier > 1.0f) {
            return;
        }
        float xOffset = buf.readFloat();
        float yOffset = buf.readFloat();
        float zOffset = buf.readFloat();
        boolean uniboob = buf.readBoolean();
        float cleavage = buf.readFloat();
        boolean hidden = buf.readBoolean();
        if (player == null || !player.method_5667().equals(uuid)) {
            return;
        }
        GenderPlayer plr = WildfireGender.getOrAddPlayerById(uuid);
        plr.updateGender(gender);
        plr.updateBustSize(bustSize);
        plr.updateHurtSounds(hurtSounds);
        plr.updateBreastPhysics(breastPhysics);
        plr.updateShowBreastsInArmor(showInArmor);
        plr.updateBounceMultiplier(bounceMultiplier);
        plr.updateFloppiness(floppyMultiplier);
        plr.getBreasts().updateXOffset(xOffset);
        plr.getBreasts().updateYOffset(yOffset);
        plr.getBreasts().updateZOffset(zOffset);
        plr.getBreasts().updateUniboob(uniboob);
        plr.getBreasts().updateCleavage(cleavage);
        plr.updateHidden(hidden);
        plr.setSyncStatus(GenderPlayer.SyncStatus.SYNCED);
        PacketSync.sendToOthers(player, plr);
    }

    public static void send(GenderPlayer plr) {
        if (plr == null) {
            return;
        }
        PacketSendGenderInfo packet = new PacketSendGenderInfo(plr);
        class_2540 buffer = PacketByteBufs.create();
        packet.encode(buffer);
        byte[] data = buffer.copy().array();
        class_310.method_1551().method_1562().method_2883((class_2596)new class_2817(new class_2960("wildfire_gender", "gender_info"), buffer));
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

