/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.config;

import com.google.gson.JsonPrimitive;
import com.wildfire.main.config.NumberConfigKey;

public class FloatConfigKey
extends NumberConfigKey<Float> {
    public FloatConfigKey(String key, Float defaultValue) {
        super(key, defaultValue);
    }

    public FloatConfigKey(String key, float defaultValue, float minInclusive, float maxInclusive) {
        super(key, Float.valueOf(defaultValue), Float.valueOf(minInclusive), Float.valueOf(maxInclusive));
    }

    @Override
    protected Float fromPrimitive(JsonPrimitive primitive) {
        return Float.valueOf(primitive.getAsFloat());
    }

    public float getMinInclusive() {
        return this.minInclusive == null ? -3.4028235E38f : ((Float)this.minInclusive).floatValue();
    }

    public float getMaxInclusive() {
        return this.maxInclusive == null ? Float.MAX_VALUE : ((Float)this.maxInclusive).floatValue();
    }
}

