/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireEventHandler;
import com.wildfire.main.WildfireSounds;
import com.wildfire.main.networking.PacketReceiveGenderInfo;
import com.wildfire.main.networking.PacketSendGenderInfo;
import com.wildfire.main.networking.PacketSetHidden;
import com.wildfire.main.networking.PacketSync;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class WildfireGender
implements ClientModInitializer,
ModInitializer {
    public static final String VERSION = "2.9";
    public static final String MODID = "wildfire_gender";
    public static boolean modEnabled = true;
    public static final boolean SYNCING_ENABLED = false;
    private static final String PROTOCOL_VERSION = "2";
    public static Map<UUID, GenderPlayer> CLOTHING_PLAYERS = new HashMap<UUID, GenderPlayer>();

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketSetHidden.ID, PacketSetHidden::handle);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketReceiveGenderInfo.ID, PacketReceiveGenderInfo::handle);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketSync.ID, PacketSync::handle);
        WildfireEventHandler.registerClientEvents();
        WildfireSounds.register();
    }

    public void onInitialize() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960(MODID, "gender_info"), (server, player, handler, buf, responseSender) -> PacketSendGenderInfo.handle(server, player, handler, buf, responseSender));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static GenderPlayer getPlayerById(UUID id) {
        Map<UUID, GenderPlayer> map = CLOTHING_PLAYERS;
        synchronized (map) {
            return CLOTHING_PLAYERS.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GenderPlayer getOrAddPlayerById(UUID id) {
        Map<UUID, GenderPlayer> map = CLOTHING_PLAYERS;
        synchronized (map) {
            GenderPlayer plr = CLOTHING_PLAYERS.computeIfAbsent(id, uuid -> WildfireGender.loadGenderInfo(uuid, true));
            return plr;
        }
    }

    public static void loadGenderInfoAsync(UUID uuid, boolean markForSync) {
        Thread thread = new Thread(() -> {
            GenderPlayer plr = WildfireGender.loadGenderInfo(uuid, markForSync);
            Map<UUID, GenderPlayer> map = CLOTHING_PLAYERS;
            synchronized (map) {
                CLOTHING_PLAYERS.put(uuid, plr);
            }
        });
        thread.setName("WFGM_GetPlayer-" + uuid);
        thread.start();
    }

    public static void refreshAllGenders() {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GenderPlayer loadGenderInfo(UUID uuid, boolean markForSync) {
        GenderPlayer plr = GenderPlayer.loadCachedPlayer(uuid, markForSync);
        Map<UUID, GenderPlayer> map = CLOTHING_PLAYERS;
        synchronized (map) {
            CLOTHING_PLAYERS.put(uuid, plr);
        }
        if (class_310.method_1551().field_1724 != null && uuid.equals(class_310.method_1551().field_1724.method_5667())) {
            plr.setSyncStatus(GenderPlayer.SyncStatus.SYNCED);
            PacketSendGenderInfo.send(plr);
        }
        return plr;
    }

    public static interface WildfireCB {
        public void onExecute(boolean var1, Object var2);
    }
}

