/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.wildfire.main.Breasts;
import com.wildfire.main.networking.PacketSendGenderInfo;
import com.wildfire.physics.BreastPhysics;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class GenderPlayer {
    public final UUID uuid;
    private Gender gender = Gender.MALE;
    private float bust_size = 0.0f;
    private boolean breast_physics = true;
    private boolean breast_physics_armor = true;
    private boolean show_in_armor = true;
    private float bounceMultiplier = 1.0f;
    private float floppyMultiplier = 1.0f;
    private final Breasts breasts = new Breasts();
    private boolean hurtSounds = true;
    public SyncStatus syncStatus = SyncStatus.UNKNOWN;
    public boolean needsSync = false;
    public long lastSyncTime = 0L;
    private static final long SYNC_COOLDOWN = 1000L;
    private boolean hidden = false;
    private BreastPhysics leftBreastPhysics;
    private BreastPhysics rightBreastPhysics;
    public static final Gson GSON = new Gson();
    public boolean lockSettings = false;

    public BreastPhysics getLeftBreastPhysics() {
        return this.leftBreastPhysics;
    }

    public BreastPhysics getRightBreastPhysics() {
        return this.rightBreastPhysics;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean updateHidden(boolean value) {
        if (this.hidden == value) {
            return false;
        }
        this.hidden = value;
        if (class_310.method_1551().field_1724 != null && this.uuid.equals(class_310.method_1551().field_1724.method_5667())) {
            GenderPlayer.saveGenderInfo(this);
            PacketSendGenderInfo.send(this);
        }
        this.needsSync = true;
        return true;
    }

    public SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public void setSyncStatus(SyncStatus status) {
        this.syncStatus = status;
    }

    public GenderPlayer(UUID uuid) {
        this.uuid = uuid;
        this.syncStatus = SyncStatus.UNKNOWN;
        this.bust_size = 0.0f;
        this.bounceMultiplier = 1.0f;
        this.floppyMultiplier = 1.0f;
        this.leftBreastPhysics = new BreastPhysics(this);
        this.rightBreastPhysics = new BreastPhysics(this);
    }

    public GenderPlayer(UUID uuid, Gender gender, float bust_size, boolean hurtSounds, boolean breast_physics, boolean breast_physics_armor, boolean show_in_armor, float bounceMultiplier, float floppyMultiplier, float xOffset, float yOffset, float zOffset, boolean uniboob, float cleavage) {
        this.uuid = uuid;
        this.gender = gender;
        this.bust_size = Math.max(0.0f, Math.min(1.0f, bust_size));
        this.hurtSounds = hurtSounds;
        this.breast_physics = breast_physics;
        this.breast_physics_armor = breast_physics_armor;
        this.show_in_armor = show_in_armor;
        this.bounceMultiplier = Math.max(0.0f, Math.min(1.0f, bounceMultiplier));
        this.floppyMultiplier = Math.max(0.0f, Math.min(1.0f, floppyMultiplier));
        this.breasts.updateXOffset(Math.max(-1.0f, Math.min(1.0f, xOffset)));
        this.breasts.updateYOffset(Math.max(-1.0f, Math.min(1.0f, yOffset)));
        this.breasts.updateZOffset(Math.max(-1.0f, Math.min(1.0f, zOffset)));
        this.breasts.updateUniboob(uniboob);
        this.breasts.updateCleavage(Math.max(0.0f, Math.min(1.0f, cleavage)));
        this.leftBreastPhysics = new BreastPhysics(this);
        this.rightBreastPhysics = new BreastPhysics(this);
    }

    public Gender getGender() {
        return this.gender;
    }

    public boolean updateGender(Gender gender) {
        if (this.gender == gender) {
            return false;
        }
        this.gender = gender;
        if (class_310.method_1551().field_1724 != null && this.uuid.equals(class_310.method_1551().field_1724.method_5667())) {
            GenderPlayer.saveGenderInfo(this);
            PacketSendGenderInfo.send(this);
        }
        this.needsSync = true;
        return true;
    }

    public boolean updateBustSize(float value) {
        if (this.bust_size == (value = Math.max(0.0f, Math.min(1.0f, value)))) {
            return false;
        }
        this.bust_size = value;
        if (class_310.method_1551().field_1724 != null && this.uuid.equals(class_310.method_1551().field_1724.method_5667())) {
            GenderPlayer.saveGenderInfo(this);
            PacketSendGenderInfo.send(this);
        }
        this.needsSync = true;
        return true;
    }

    public float getBustSize() {
        return this.bust_size;
    }

    public boolean hasHurtSounds() {
        return this.hurtSounds;
    }

    public boolean updateHurtSounds(boolean value) {
        if (this.hurtSounds == value) {
            return false;
        }
        this.hurtSounds = value;
        if (class_310.method_1551().field_1724 != null && this.uuid.equals(class_310.method_1551().field_1724.method_5667())) {
            GenderPlayer.saveGenderInfo(this);
            PacketSendGenderInfo.send(this);
        }
        this.needsSync = true;
        return true;
    }

    public boolean hasBreastPhysics() {
        return this.breast_physics;
    }

    public boolean updateBreastPhysics(boolean value) {
        if (this.breast_physics == value) {
            return false;
        }
        this.breast_physics = value;
        if (class_310.method_1551().field_1724 != null && this.uuid.equals(class_310.method_1551().field_1724.method_5667())) {
            GenderPlayer.saveGenderInfo(this);
            PacketSendGenderInfo.send(this);
        }
        this.needsSync = true;
        return true;
    }

    public boolean hasArmorBreastPhysics() {
        return this.breast_physics_armor;
    }

    public boolean updateArmorBreastPhysics(boolean value) {
        if (this.breast_physics_armor == value) {
            return false;
        }
        this.breast_physics_armor = value;
        if (class_310.method_1551().field_1724 != null && this.uuid.equals(class_310.method_1551().field_1724.method_5667())) {
            GenderPlayer.saveGenderInfo(this);
            PacketSendGenderInfo.send(this);
        }
        this.needsSync = true;
        return true;
    }

    public boolean showBreastsInArmor() {
        return this.show_in_armor;
    }

    public boolean updateShowBreastsInArmor(boolean value) {
        if (this.show_in_armor == value) {
            return false;
        }
        this.show_in_armor = value;
        if (class_310.method_1551().field_1724 != null && this.uuid.equals(class_310.method_1551().field_1724.method_5667())) {
            GenderPlayer.saveGenderInfo(this);
            PacketSendGenderInfo.send(this);
        }
        this.needsSync = true;
        return true;
    }

    public float getBounceMultiplier() {
        return (float)Math.round(this.bounceMultiplier * 3.0f * 10.0f) / 10.0f;
    }

    public float getBounceMultiplierRaw() {
        return this.bounceMultiplier;
    }

    public boolean updateBounceMultiplier(float value) {
        if (this.bounceMultiplier == (value = Math.max(0.0f, Math.min(1.0f, value)))) {
            return false;
        }
        this.bounceMultiplier = value;
        if (class_310.method_1551().field_1724 != null && this.uuid.equals(class_310.method_1551().field_1724.method_5667())) {
            GenderPlayer.saveGenderInfo(this);
            PacketSendGenderInfo.send(this);
        }
        this.needsSync = true;
        return true;
    }

    public float getFloppiness() {
        return this.floppyMultiplier;
    }

    public boolean updateFloppiness(float value) {
        if (this.floppyMultiplier == (value = Math.max(0.0f, Math.min(1.0f, value)))) {
            return false;
        }
        this.floppyMultiplier = value;
        if (class_310.method_1551().field_1724 != null && this.uuid.equals(class_310.method_1551().field_1724.method_5667())) {
            GenderPlayer.saveGenderInfo(this);
            PacketSendGenderInfo.send(this);
        }
        this.needsSync = true;
        return true;
    }

    public Breasts getBreasts() {
        return this.breasts;
    }

    public static void saveGenderInfo(GenderPlayer plr) {
        if (plr == null) {
            return;
        }
        File f = new File(GenderPlayer.getPlayerConfig(), plr.uuid.toString() + ".json");
        try (FileWriter writer = new FileWriter(f);){
            GSON.toJson((JsonElement)GenderPlayer.toJsonObject(plr), (Appendable)writer);
            plr.needsSync = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static JsonObject toJsonObject(GenderPlayer plr) {
        JsonObject obj = new JsonObject();
        obj.addProperty("username", plr.uuid.toString());
        obj.addProperty("gender", plr.getGender().name());
        obj.addProperty("bust_size", (Number)Float.valueOf(plr.getBustSize()));
        obj.addProperty("hurt_sounds", Boolean.valueOf(plr.hasHurtSounds()));
        obj.addProperty("breast_physics", Boolean.valueOf(plr.hasBreastPhysics()));
        obj.addProperty("show_in_armor", Boolean.valueOf(plr.showBreastsInArmor()));
        obj.addProperty("bounce_multiplier", (Number)Float.valueOf(plr.getBounceMultiplierRaw()));
        obj.addProperty("floppy_multiplier", (Number)Float.valueOf(plr.getFloppiness()));
        Breasts breasts = plr.getBreasts();
        obj.addProperty("breasts_xOffset", (Number)Float.valueOf(breasts.getXOffset()));
        obj.addProperty("breasts_yOffset", (Number)Float.valueOf(breasts.getYOffset()));
        obj.addProperty("breasts_zOffset", (Number)Float.valueOf(breasts.getZOffset()));
        obj.addProperty("breasts_uniboob", Boolean.valueOf(breasts.isUniboob()));
        obj.addProperty("breasts_cleavage", (Number)Float.valueOf(breasts.getCleavage()));
        obj.addProperty("hidden", Boolean.valueOf(plr.hidden));
        return obj;
    }

    public static GenderPlayer fromJsonObject(JsonObject obj) {
        JsonElement elem;
        UUID uuid = UUID.fromString(obj.get("username").getAsString());
        GenderPlayer plr = new GenderPlayer(uuid);
        if (obj.has("gender") && (elem = obj.get("gender")).isJsonPrimitive()) {
            int ordinal;
            JsonPrimitive prim = elem.getAsJsonPrimitive();
            if (prim.isString()) {
                try {
                    plr.gender = Gender.valueOf(prim.getAsString());
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            } else if (prim.isNumber() && (ordinal = prim.getAsInt()) >= 0 && ordinal < Gender.values().length) {
                plr.gender = Gender.values()[ordinal];
            }
        }
        if (obj.has("bust_size")) {
            float bustSize = obj.get("bust_size").getAsFloat();
            plr.updateBustSize(Math.max(0.0f, Math.min(1.0f, bustSize)));
        }
        if (obj.has("hurt_sounds")) {
            plr.updateHurtSounds(obj.get("hurt_sounds").getAsBoolean());
        }
        if (obj.has("breast_physics")) {
            plr.updateBreastPhysics(obj.get("breast_physics").getAsBoolean());
        }
        if (obj.has("show_in_armor")) {
            plr.updateShowBreastsInArmor(obj.get("show_in_armor").getAsBoolean());
        }
        if (obj.has("bounce_multiplier")) {
            plr.updateBounceMultiplier(Math.max(0.0f, Math.min(1.0f, obj.get("bounce_multiplier").getAsFloat())));
        }
        if (obj.has("floppy_multiplier")) {
            plr.updateFloppiness(Math.max(0.0f, Math.min(1.0f, obj.get("floppy_multiplier").getAsFloat())));
        }
        Breasts breasts = plr.getBreasts();
        if (obj.has("breasts_xOffset")) {
            breasts.updateXOffset(Math.max(-1.0f, Math.min(1.0f, obj.get("breasts_xOffset").getAsFloat())));
        }
        if (obj.has("breasts_yOffset")) {
            breasts.updateYOffset(Math.max(-1.0f, Math.min(1.0f, obj.get("breasts_yOffset").getAsFloat())));
        }
        if (obj.has("breasts_zOffset")) {
            breasts.updateZOffset(Math.max(-1.0f, Math.min(1.0f, obj.get("breasts_zOffset").getAsFloat())));
        }
        if (obj.has("breasts_uniboob")) {
            breasts.updateUniboob(obj.get("breasts_uniboob").getAsBoolean());
        }
        if (obj.has("breasts_cleavage")) {
            breasts.updateCleavage(Math.max(0.0f, Math.min(1.0f, obj.get("breasts_cleavage").getAsFloat())));
        }
        if (obj.has("hidden")) {
            plr.updateHidden(obj.get("hidden").getAsBoolean());
        } else {
            plr.updateHidden(false);
        }
        plr.syncStatus = SyncStatus.CACHED;
        if (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_5667().equals(uuid)) {
            plr.syncStatus = SyncStatus.SYNCED;
            PacketSendGenderInfo.send(plr);
        }
        return plr;
    }

    public static GenderPlayer loadCachedPlayer(UUID uuid, boolean markForSync) {
        File f = new File(GenderPlayer.getPlayerConfig(), uuid.toString() + ".json");
        if (f.exists()) {
            GenderPlayer genderPlayer;
            FileReader reader = new FileReader(f);
            try {
                GenderPlayer plr = GenderPlayer.fromJsonObject(new JsonParser().parse((Reader)reader).getAsJsonObject());
                if (markForSync) {
                    plr.needsSync = true;
                    PacketSendGenderInfo.send(plr);
                }
                genderPlayer = plr;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return genderPlayer;
        }
        GenderPlayer plr = new GenderPlayer(uuid);
        if (markForSync) {
            plr.needsSync = true;
            PacketSendGenderInfo.send(plr);
        }
        return plr;
    }

    private static File getPlayerConfig() {
        File config = new File(FabricLoader.getInstance().getConfigDir().toFile(), "WildfireGender");
        if (!config.exists() && !config.mkdir()) {
            throw new RuntimeException("Failed to create config directory");
        }
        return config;
    }

    public static enum SyncStatus {
        SYNCED,
        UNKNOWN,
        CACHED;

    }

    public static enum Gender {
        MALE(false, "wildfire_gender.gender.male"),
        FEMALE(true, "wildfire_gender.gender.female"),
        OTHER(true, "wildfire_gender.gender.other");

        private final boolean canHaveBreasts;
        private final String translationKey;

        private Gender(boolean canHaveBreasts, String translationKey) {
            this.canHaveBreasts = canHaveBreasts;
            this.translationKey = translationKey;
        }

        public boolean canHaveBreasts() {
            return this.canHaveBreasts;
        }

        public boolean hasFemaleHurtSounds() {
            return this == FEMALE;
        }

        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)this.translationKey).method_27692(this == MALE ? class_124.field_1075 : (this == FEMALE ? class_124.field_1076 : class_124.field_1068));
        }
    }
}

