/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wildfire.main.config.FloatConfigKey;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_6382;

public class WildfireSlider
extends class_339 {
    private double value;
    private final double minValue;
    private final double maxValue;
    private final FloatConsumer valueUpdate;
    private final Float2ObjectFunction<class_2561> messageUpdate;
    private final FloatConsumer onSave;
    private float lastValue;
    private boolean changed;
    private boolean dragging;
    private long lastSaveTime = 0L;
    private static final long SAVE_COOLDOWN = 1000L;

    public WildfireSlider(int xPos, int yPos, int width, int height, FloatConfigKey config, double currentVal, FloatConsumer valueUpdate, Float2ObjectFunction<class_2561> messageUpdate, FloatConsumer onSave) {
        this(xPos, yPos, width, height, config.getMinInclusive(), config.getMaxInclusive(), currentVal, valueUpdate, messageUpdate, onSave);
    }

    public WildfireSlider(int xPos, int yPos, int width, int height, double minVal, double maxVal, double currentVal, FloatConsumer valueUpdate, Float2ObjectFunction<class_2561> messageUpdate, FloatConsumer onSave) {
        super(xPos, yPos, width, height, (class_2561)class_2561.method_43473());
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.valueUpdate = valueUpdate;
        this.messageUpdate = messageUpdate;
        this.onSave = onSave;
        this.setValueInternal(currentVal);
        this.lastValue = (float)currentVal;
        this.updateMessage();
    }

    protected int method_25356(boolean hovered) {
        return 0;
    }

    protected void updateMessage() {
        this.method_25355((class_2561)this.messageUpdate.get((float)this.getValue()));
    }

    protected void applyValue() {
        float newValue = (float)this.getValue();
        if (this.lastValue != newValue) {
            this.lastValue = newValue;
            this.changed = true;
            this.valueUpdate.accept(this.lastValue);
        }
    }

    public void save() {
        if (this.changed && System.currentTimeMillis() - this.lastSaveTime >= 1000L) {
            this.onSave.accept(this.lastValue);
            this.changed = false;
            this.lastSaveTime = System.currentTimeMillis();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void method_25357(double mouseX, double mouseY) {
        if (this.dragging) {
            this.dragging = false;
            this.applyValue();
            this.save();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean result = super.method_25404(keyCode, scanCode, modifiers);
        if (keyCode == 263 || keyCode == 262) {
            this.applyValue();
            this.save();
        }
        return result;
    }

    protected class_5250 method_25360() {
        return class_2561.method_43469((String)"gui.narrate.slider", (Object[])new Object[]{this.method_25369()});
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.field_22764) {
            RenderSystem.disableDepthTest();
            this.field_22762 = mouseX >= this.method_46426() && mouseY >= this.method_46427() && mouseX < this.method_46426() + this.field_22758 && mouseY < this.method_46427() + this.field_22759;
            int clr = 0x54000000;
            int xP = this.method_46426() + 4;
            class_437.method_25294((class_4587)matrices, (int)(xP - 2), (int)(this.method_46427() + 1), (int)(this.method_46426() + this.field_22758 - 1), (int)(this.method_46427() + this.field_22759 - 1), (int)-2145246686);
            int xPos = this.method_46426() + 4 + (int)(this.value * (double)(this.field_22758 - 6));
            class_437.method_25294((class_4587)matrices, (int)(this.method_46426() + 3), (int)(this.method_46427() + 2), (int)(xPos - 1), (int)(this.method_46427() + this.field_22759 - 2), (int)-1272831386);
            int xPos2 = this.method_46426() + 2 + (int)(this.value * (double)(this.field_22758 - 4));
            class_437.method_25294((class_4587)matrices, (int)(xPos2 - 2), (int)(this.method_46427() + 1), (int)xPos2, (int)(this.method_46427() + this.field_22759 - 1), (int)0x78FFFFFF);
            RenderSystem.enableDepthTest();
            class_327 font = class_310.method_1551().field_1772;
            WildfireSlider.method_27534((class_4587)matrices, (class_327)font, (class_2561)this.method_25369(), (int)(this.method_46426() + this.field_22758 / 2), (int)(this.method_46427() + (this.field_22759 - 8) / 2), (int)(this.field_22762 || this.changed ? 0xFFFF55 : 0xFFFFFF));
        }
    }

    public float getFloatValue() {
        return (float)this.getValue();
    }

    public double getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double value) {
        this.setValueInternal(value);
        this.applyValue();
    }

    private void setValueInternal(double value) {
        this.value = class_3532.method_15350((double)((value - this.minValue) / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
        this.updateMessage();
    }

    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (!this.dragging) {
            return;
        }
        this.value = (mouseX - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8);
        if (this.value < 0.0) {
            this.value = 0.0;
        }
        if (this.value > 1.0) {
            this.value = 1.0;
        }
        this.applyValue();
        this.updateMessage();
    }

    public void method_47399(class_6382 builder) {
    }
}

