/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wildfire.gui.WildfireButton;
import com.wildfire.gui.screen.WardrobeBrowserScreen;
import com.wildfire.gui.screen.WildfirePlayerListScreen;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1934;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_350;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_6382;
import net.minecraft.class_640;
import net.minecraft.class_746;

public class WildfirePlayerList
extends class_350<Entry> {
    private static final Ordering<class_640> ENTRY_ORDERING = Ordering.from((Comparator)new EntryOrderComparator());
    private static final class_2960 TXTR_SYNC = new class_2960("wildfire_gender", "textures/sync.png");
    private static final class_2960 TXTR_UNKNOWN = new class_2960("wildfire_gender", "textures/unknown.png");
    private static final class_2960 TXTR_CACHED = new class_2960("wildfire_gender", "textures/cached.png");
    private final int listWidth;
    private boolean loadingPlayers = true;
    private static WildfirePlayerListScreen parent;

    public WildfirePlayerList(WildfirePlayerListScreen parent, int listWidth, int top, int bottom) {
        super(class_310.method_1551(), parent.field_22789 - 4, parent.field_22790, top - 6, bottom, 20);
        WildfirePlayerList.parent = parent;
        this.listWidth = listWidth;
        this.refreshList();
    }

    protected int method_25329() {
        return WildfirePlayerList.parent.field_22789 / 2 + 53;
    }

    public int method_25322() {
        return this.listWidth;
    }

    public void refreshList() {
        this.method_25339();
        class_634 clientPlayNetworkHandler = this.field_22740.field_1724.field_3944;
        List list = ENTRY_ORDERING.sortedCopy((Iterable)clientPlayNetworkHandler.method_2880());
        class_310 mc = class_310.method_1551();
        class_746 clientPlayer = mc.field_1724;
        class_638 world = mc.field_1687;
        Iterator var9 = list.iterator();
        int index = 0;
        while (var9.hasNext()) {
            class_243 to;
            class_243 from;
            class_3965 hit;
            double distance;
            GenderPlayer gp;
            class_640 playerListEntry = (class_640)var9.next();
            class_1657 playerentity = world.method_18470(playerListEntry.method_2966().getId());
            if (playerentity == null || (gp = WildfireGender.getPlayerById(playerentity.method_5667())) != null && gp.isHidden() || playerentity != clientPlayer && ((distance = clientPlayer.method_19538().method_1022(playerentity.method_19538())) > 32.0 || (hit = world.method_17742(new class_3959(from = clientPlayer.method_33571(), to = playerentity.method_33571(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)clientPlayer))).method_17783() != class_239.class_240.field_1333)) continue;
            this.method_25321(new Entry(playerListEntry));
            ++index;
        }
    }

    protected void method_25325(class_4587 mStack) {
    }

    public boolean isLoadingPlayers() {
        boolean loadingPlayers = false;
        for (Entry child : this.method_25396()) {
            GenderPlayer aPlr = WildfireGender.getPlayerById(child.nInfo.method_2966().getId());
            if (aPlr != null) continue;
            loadingPlayers = true;
        }
        return loadingPlayers;
    }

    public void method_37020(class_6382 builder) {
    }

    @Environment(value=EnvType.CLIENT)
    public class Entry
    extends class_350.class_351<Entry> {
        private final String name;
        public final class_640 nInfo;
        private final WildfireButton btnOpenGUI;

        private Entry(class_640 nInfo) {
            this.nInfo = nInfo;
            this.name = nInfo.method_2966().getName();
            this.btnOpenGUI = new WildfireButton(0, 0, 112, 20, (class_2561)class_2561.method_43473(), button -> {
                GenderPlayer aPlr = WildfireGender.getPlayerById(nInfo.method_2966().getId());
                if (aPlr == null) {
                    return;
                }
                try {
                    class_310.method_1551().method_1507((class_437)new WardrobeBrowserScreen(parent, nInfo.method_2966().getId()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            GenderPlayer aPlr = WildfireGender.getPlayerById(nInfo.method_2966().getId());
            if (aPlr != null) {
                this.btnOpenGUI.field_22763 = !aPlr.lockSettings;
            }
        }

        public class_640 getNetworkInfo() {
            return this.nInfo;
        }

        public void method_25343(class_4587 m, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            class_327 font = class_310.method_1551().field_1772;
            class_1657 playerentity = class_310.method_1551().field_1687.method_18470(this.nInfo.method_2966().getId());
            GenderPlayer aPlr = WildfireGender.getPlayerById(this.nInfo.method_2966().getId());
            boolean flag1 = false;
            RenderSystem.setShaderTexture((int)0, (class_2960)this.nInfo.method_2968());
            int i3 = 8 + (flag1 ? 8 : 0);
            int j3 = 8 * (flag1 ? -1 : 1);
            class_437.method_25293((class_4587)m, (int)(left + 2), (int)(top + 2), (int)16, (int)16, (float)8.0f, (float)i3, (int)8, (int)j3, (int)64, (int)64);
            if (playerentity != null && playerentity.method_7348(class_1664.field_7563)) {
                int k3 = 8 + (flag1 ? 8 : 0);
                int l3 = 8 * (flag1 ? -1 : 1);
                class_437.method_25293((class_4587)m, (int)(left + 1), (int)(top + 1), (int)18, (int)18, (float)40.0f, (float)k3, (int)8, (int)l3, (int)64, (int)64);
            }
            font.method_1729(m, this.name, (float)(left + 23), (float)(top + 2), 0xFFFFFF);
            if (aPlr != null) {
                this.btnOpenGUI.field_22763 = !aPlr.lockSettings;
                font.method_30883(m, aPlr.getGender().getDisplayName(), (float)(left + 23), (float)(top + 11), 0xFFFFFF);
                if (aPlr.getSyncStatus() == GenderPlayer.SyncStatus.SYNCED) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)TXTR_SYNC);
                    class_437.method_25293((class_4587)m, (int)(left + 98), (int)(top + 11), (int)12, (int)8, (float)0.0f, (float)0.0f, (int)12, (int)8, (int)12, (int)8);
                    if (mouseX > left + 98 - 2 && mouseY > top + 11 - 2 && mouseX < left + 98 + 12 + 2 && mouseY < top + 20) {
                        parent.method_47415((class_2561)class_2561.method_43471((String)"wildfire_gender.player_list.state.synced"));
                    }
                } else if (aPlr.getSyncStatus() == GenderPlayer.SyncStatus.CACHED) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)TXTR_CACHED);
                    class_437.method_25293((class_4587)m, (int)(left + 98), (int)(top + 11), (int)12, (int)8, (float)0.0f, (float)0.0f, (int)12, (int)8, (int)12, (int)8);
                    if (mouseX > left + 98 - 2 && mouseY > top + 11 - 2 && mouseX < left + 98 + 12 + 2 && mouseY < top + 20) {
                        parent.method_47415((class_2561)class_2561.method_43471((String)"wildfire_gender.player_list.state.cached"));
                    }
                } else if (aPlr.getSyncStatus() == GenderPlayer.SyncStatus.UNKNOWN) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)TXTR_UNKNOWN);
                    class_437.method_25293((class_4587)m, (int)(left + 98), (int)(top + 11), (int)12, (int)8, (float)0.0f, (float)0.0f, (int)12, (int)8, (int)12, (int)8);
                }
            } else {
                this.btnOpenGUI.field_22763 = false;
                font.method_30883(m, (class_2561)class_2561.method_43471((String)"wildfire_gender.label.too_far").method_27692(class_124.field_1061), (float)(left + 23), (float)(top + 11), 0xFFFFFF);
            }
            this.btnOpenGUI.method_46421(left);
            this.btnOpenGUI.method_46419(top);
            this.btnOpenGUI.method_25394(m, mouseX, mouseY, partialTicks);
            if (this.btnOpenGUI.method_25367() || aPlr != null && mouseX > left && mouseX < left + entryWidth && mouseY > top && mouseY < top + entryHeight) {
                WildfirePlayerListScreen.HOVER_PLAYER = aPlr;
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0 && this.btnOpenGUI.method_25367()) {
                this.btnOpenGUI.method_25306();
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }

    private static class EntryOrderComparator
    implements Comparator<class_640> {
        private EntryOrderComparator() {
        }

        @Override
        public int compare(class_640 a, class_640 b) {
            class_268 team = a.method_2955();
            class_268 team2 = b.method_2955();
            return ComparisonChain.start().compareTrueFirst(a.method_2958() != class_1934.field_9219, b.method_2958() != class_1934.field_9219).compare((Comparable)((Object)(team != null ? team.method_1197() : "")), (Comparable)((Object)(team2 != null ? team2.method_1197() : ""))).compare((Object)a.method_2966().getName(), (Object)b.method_2966().getName(), String.CASE_INSENSITIVE_ORDER).result();
        }
    }
}

