/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.placeholder.v2.placeholders.client;

import de.keksuccino.fancymenu.menu.placeholder.v2.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.menu.placeholder.v2.Placeholder;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModVersionPlaceholder
extends Placeholder {
    public ModVersionPlaceholder() {
        super("modversion");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        if (!dps.values.containsKey("modid")) {
            return null;
        }
        return this.getModVersion(dps.values.get("modid"));
    }

    private String getModVersion(String modid) {
        Optional o;
        if (FabricLoader.getInstance().isModLoaded(modid) && (o = FabricLoader.getInstance().getModContainer(modid)).isPresent()) {
            ModContainer c = (ModContainer)o.get();
            return c.getMetadata().getVersion().getFriendlyString();
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("modid");
        return l;
    }

    @Override
    public String getDisplayName() {
        return Locals.localize((String)"helper.ui.dynamicvariabletextfield.variables.modversion", (String[])new String[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.dynamicvariabletextfield.variables.modversion.desc", (String[])new String[0]), (String)"%n%"));
    }

    @Override
    public String getCategory() {
        return Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.client", (String[])new String[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("modid", "some_mod_id");
        return DeserializedPlaceholderString.build(this.getIdentifier(), m);
    }
}

