/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.items.inputfield;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.api.item.CustomizationItem;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.menu.variables.VariableHandler;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.widget.WidgetUtils;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.io.IOException;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class InputFieldCustomizationItem
extends CustomizationItem {
    public String linkedVariable;
    public InputFieldType type = InputFieldType.TEXT;
    public int maxTextLength = 10000;
    public AdvancedTextField textField;
    public String lastValue = "";

    public InputFieldCustomizationItem(CustomizationItemContainer parentContainer, PropertiesSection item) {
        super(parentContainer, item);
        String var;
        String maxLengthString;
        InputFieldType t;
        this.linkedVariable = item.getEntryValue("linked_variable");
        String inputFieldTypeString = item.getEntryValue("input_field_type");
        if (inputFieldTypeString != null && (t = InputFieldType.getByName(inputFieldTypeString)) != null) {
            this.type = t;
        }
        if ((maxLengthString = item.getEntryValue("max_text_length")) != null && MathUtils.isInteger((String)maxLengthString)) {
            this.maxTextLength = Integer.parseInt(maxLengthString);
        }
        if (this.maxTextLength <= 0) {
            this.maxTextLength = 1;
        }
        class_437 current = class_310.method_1551().field_1755;
        this.textField = new AdvancedTextField(class_310.method_1551().field_1772, this.getPosX(current), this.getPosY(current), this.getWidth(), this.getHeight(), true, this.type.filter);
        this.textField.method_1880(this.maxTextLength);
        if (this.linkedVariable != null && (var = VariableHandler.getVariable(this.linkedVariable)) != null) {
            this.textField.method_1852(var);
        }
    }

    @Override
    public void render(class_4587 matrix, class_437 menu) throws IOException {
        if (this.shouldRender()) {
            RenderSystem.enableBlend();
            if (InputFieldCustomizationItem.isEditorActive()) {
                String var;
                this.textField.field_22763 = false;
                this.textField.method_1888(false);
                if (this.linkedVariable != null && (var = VariableHandler.getVariable(this.linkedVariable)) != null) {
                    this.textField.method_1852(var);
                }
            }
            this.textField.field_22760 = this.getPosX(menu);
            this.textField.field_22761 = this.getPosY(menu);
            this.textField.method_25358(this.getWidth());
            WidgetUtils.setHeight((class_339)this.textField, (int)this.getHeight());
            this.textField.method_25394(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), class_310.method_1551().method_1534());
            if (!InputFieldCustomizationItem.isEditorActive()) {
                if (this.linkedVariable != null) {
                    String val;
                    if (!this.lastValue.equals(this.textField.method_1882())) {
                        VariableHandler.setVariable(this.linkedVariable, this.textField.method_1882());
                    }
                    if ((val = VariableHandler.getVariable(this.linkedVariable)) != null) {
                        if (!this.textField.method_1882().equals(val)) {
                            this.textField.method_1852(val);
                        }
                    } else {
                        this.textField.method_1852("");
                    }
                }
                this.lastValue = this.textField.method_1882();
            }
        }
    }

    public static enum InputFieldType {
        INTEGER_ONLY("integer", CharacterFilter.getIntegerCharacterFiler()),
        DECIMAL_ONLY("decimal", CharacterFilter.getDoubleCharacterFiler()),
        URL("url", CharacterFilter.getUrlCharacterFilter()),
        TEXT("text", null);

        String name;
        CharacterFilter filter;

        private InputFieldType(String name, CharacterFilter filter) {
            this.name = name;
            this.filter = filter;
        }

        public String getName() {
            return this.name;
        }

        public CharacterFilter getFilter() {
            return this.filter;
        }

        public static InputFieldType getByName(String name) {
            for (InputFieldType i : InputFieldType.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }
}

