/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.animation;

import de.keksuccino.fancymenu.menu.animation.ResourcePackAnimationRenderer;
import de.keksuccino.fancymenu.menu.animation.exceptions.AnimationNotFoundException;
import de.keksuccino.konkrete.rendering.animation.ExternalTextureAnimationRenderer;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class AdvancedAnimation
implements IAnimationRenderer {
    private IAnimationRenderer introRenderer;
    private IAnimationRenderer animationRenderer;
    private boolean started = false;
    private String mainAudioPath;
    private String introAudioPath;
    private boolean muted = false;
    private boolean replayIntro = false;
    public String propertiesPath = null;
    protected boolean prepared = false;

    public AdvancedAnimation(@Nullable IAnimationRenderer introAnimation, IAnimationRenderer mainAnimation, @Nullable String introAudioPath, @Nullable String mainAudioPath, boolean replayIntro) throws AnimationNotFoundException {
        if (mainAnimation == null) {
            throw new AnimationNotFoundException("Animation cannot be null!");
        }
        this.animationRenderer = mainAnimation;
        this.introRenderer = introAnimation;
        this.mainAudioPath = mainAudioPath;
        this.introAudioPath = introAudioPath;
        this.replayIntro = replayIntro;
    }

    public boolean hasIntro() {
        return this.introRenderer != null;
    }

    public boolean isReady() {
        if (this.animationRenderer != null && this.hasIntro()) {
            if (this.animationRenderer.isReady() && this.introRenderer.isReady()) {
                return true;
            }
        } else if (this.animationRenderer != null) {
            return this.animationRenderer.isReady();
        }
        return false;
    }

    public void prepareAnimation() {
        if (!this.prepared) {
            if (this.mainAudioPath != null) {
                SoundHandler.registerSound((String)this.mainAudioPath, (String)this.mainAudioPath);
            }
            if (this.introAudioPath != null && this.hasIntro()) {
                SoundHandler.registerSound((String)this.introAudioPath, (String)this.introAudioPath);
            }
            if (this.animationRenderer != null) {
                this.animationRenderer.prepareAnimation();
            }
            if (this.hasIntro()) {
                this.introRenderer.prepareAnimation();
            }
            this.prepared = true;
        }
    }

    public void resetAnimation() {
        if (this.animationRenderer != null) {
            this.animationRenderer.resetAnimation();
        }
        if (this.hasIntro()) {
            this.introRenderer.resetAnimation();
        }
        this.started = false;
    }

    public boolean hasStarted() {
        return this.started;
    }

    public void render(class_4587 matrix) {
        if (this.isReady()) {
            this.started = true;
            if (!this.muted) {
                if (this.hasIntroAudio() && !this.introRenderer.isFinished() && (this.introRenderer.currentFrame() == 1 || this.introRenderer.currentFrame() > 1 && !SoundHandler.isPlaying((String)this.introAudioPath))) {
                    SoundHandler.stopSound((String)this.mainAudioPath);
                    SoundHandler.resetSound((String)this.introAudioPath);
                    SoundHandler.playSound((String)this.introAudioPath);
                }
                if (this.hasIntroAudio() && this.introRenderer.isFinished()) {
                    SoundHandler.stopSound((String)this.introAudioPath);
                }
                if (this.hasMainAudio() && !this.animationRenderer.isFinished() && (this.animationRenderer.currentFrame() == 1 || this.animationRenderer.currentFrame() > 1 && !SoundHandler.isPlaying((String)this.mainAudioPath))) {
                    if (this.hasIntroAudio()) {
                        SoundHandler.stopSound((String)this.introAudioPath);
                    }
                    SoundHandler.resetSound((String)this.mainAudioPath);
                    SoundHandler.playSound((String)this.mainAudioPath);
                    SoundHandler.setLooped((String)this.mainAudioPath, (boolean)true);
                }
            }
            if (this.hasIntro()) {
                this.introRenderer.setFPS(this.animationRenderer.getFPS());
                this.introRenderer.setWidth(this.animationRenderer.getWidth());
                this.introRenderer.setHeight(this.animationRenderer.getHeight());
                this.introRenderer.setPosX(this.animationRenderer.getPosX());
                this.introRenderer.setPosY(this.animationRenderer.getPosY());
                this.introRenderer.setLooped(false);
                if (!this.introRenderer.isFinished()) {
                    if (AdvancedAnimation.canRenderFrameOf(this.introRenderer, this.introRenderer.currentFrame())) {
                        this.introRenderer.render(matrix);
                    }
                } else if (AdvancedAnimation.canRenderFrameOf(this.animationRenderer, this.animationRenderer.currentFrame())) {
                    this.animationRenderer.render(matrix);
                }
            } else if (AdvancedAnimation.canRenderFrameOf(this.animationRenderer, this.animationRenderer.currentFrame())) {
                this.animationRenderer.render(matrix);
            }
        }
        if (this.isFinished() || this.muted) {
            this.stopAudio();
        }
    }

    public void setStretchImageToScreensize(boolean b) {
        if (this.hasIntro()) {
            this.introRenderer.setStretchImageToScreensize(b);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setStretchImageToScreensize(b);
        }
    }

    public void setHideAfterLastFrame(boolean b) {
        if (this.hasIntro()) {
            this.introRenderer.setHideAfterLastFrame(b);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setHideAfterLastFrame(b);
        }
    }

    public boolean isFinished() {
        if (this.hasIntro() && this.animationRenderer != null) {
            if (this.introRenderer.isFinished() && this.animationRenderer.isFinished()) {
                return true;
            }
        } else if (this.animationRenderer != null) {
            return this.animationRenderer.isFinished();
        }
        return false;
    }

    public void setWidth(int width) {
        if (this.hasIntro()) {
            this.introRenderer.setWidth(width);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setWidth(width);
        }
    }

    public void setHeight(int height) {
        if (this.hasIntro()) {
            this.introRenderer.setHeight(height);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setHeight(height);
        }
    }

    public void setPosX(int x) {
        if (this.hasIntro()) {
            this.introRenderer.setPosX(x);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setPosX(x);
        }
    }

    public void setPosY(int y) {
        if (this.hasIntro()) {
            this.introRenderer.setPosY(y);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setPosY(y);
        }
    }

    public int currentFrame() {
        int i = 0;
        if (this.hasIntro()) {
            i = this.introRenderer.currentFrame();
        }
        if (this.animationRenderer != null) {
            i += this.animationRenderer.currentFrame();
        }
        return i;
    }

    public int animationFrames() {
        int i = 0;
        if (this.hasIntro()) {
            i = this.introRenderer.animationFrames();
        }
        if (this.animationRenderer != null) {
            i += this.animationRenderer.animationFrames();
        }
        return i;
    }

    public String getPath() {
        if (this.animationRenderer != null) {
            return new File(this.animationRenderer.getPath()).toPath().getParent().toString();
        }
        return null;
    }

    public void setFPS(int fps) {
        if (this.hasIntro()) {
            this.introRenderer.setFPS(fps);
        }
        if (this.animationRenderer != null) {
            this.animationRenderer.setFPS(fps);
        }
    }

    public void setLooped(boolean b) {
        if (this.animationRenderer != null) {
            this.animationRenderer.setLooped(b);
        }
    }

    public int getFPS() {
        if (this.animationRenderer != null) {
            return this.animationRenderer.getFPS();
        }
        return 0;
    }

    public boolean isGettingLooped() {
        return this.animationRenderer.isGettingLooped();
    }

    public boolean isStretchedToStreensize() {
        if (this.animationRenderer != null) {
            return this.animationRenderer.isStretchedToStreensize();
        }
        return false;
    }

    public int getWidth() {
        return this.animationRenderer.getWidth();
    }

    public int getHeight() {
        return this.animationRenderer.getHeight();
    }

    public int getPosX() {
        return this.animationRenderer.getPosX();
    }

    public int getPosY() {
        return this.animationRenderer.getPosY();
    }

    public void setMuteAudio(boolean b) {
        this.muted = b;
    }

    public boolean hasMainAudio() {
        return this.mainAudioPath != null && SoundHandler.soundExists((String)this.mainAudioPath);
    }

    public boolean hasIntroAudio() {
        return this.hasIntro() && this.introAudioPath != null && SoundHandler.soundExists((String)this.introAudioPath);
    }

    public void stopAudio() {
        SoundHandler.stopSound((String)this.mainAudioPath);
        if (this.hasIntro()) {
            SoundHandler.stopSound((String)this.introAudioPath);
        }
    }

    public void resetAudio() {
        SoundHandler.resetSound((String)this.mainAudioPath);
        if (this.hasIntro()) {
            SoundHandler.resetSound((String)this.introAudioPath);
        }
    }

    public IAnimationRenderer getMainAnimationRenderer() {
        return this.animationRenderer;
    }

    public IAnimationRenderer getIntroAnimationRenderer() {
        return this.introRenderer;
    }

    public boolean replayIntro() {
        return this.replayIntro;
    }

    public void setOpacity(float opacity) {
        if (this.animationRenderer != null) {
            this.animationRenderer.setOpacity(opacity);
        }
        if (this.introRenderer != null) {
            this.introRenderer.setOpacity(opacity);
        }
    }

    public static boolean canRenderFrameOf(IAnimationRenderer renderer, int frame) {
        block8: {
            try {
                if (!renderer.isReady()) break block8;
                if (renderer instanceof ResourcePackAnimationRenderer) {
                    List<class_2960> l = ((ResourcePackAnimationRenderer)renderer).resources;
                    if (!l.isEmpty()) {
                        if (l.size() > frame) {
                            class_2960 r = l.get(frame);
                            class_3298 res = (class_3298)class_310.method_1551().method_1478().method_14486(r).get();
                            return res != null;
                        }
                        return true;
                    }
                    break block8;
                }
                if (renderer instanceof ExternalTextureAnimationRenderer) {
                    Field f = ExternalTextureAnimationRenderer.class.getDeclaredField("resources");
                    f.setAccessible(true);
                    List l = (List)f.get(renderer);
                    if (l != null && l.size() > frame) {
                        class_2960 r = ((ExternalTextureResourceLocation)l.get(frame)).getResourceLocation();
                        if (r != null) {
                            class_3298 res = (class_3298)class_310.method_1551().method_1478().method_14486(r).get();
                            return res != null;
                        }
                        break block8;
                    }
                    return true;
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

