/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mainwindow;

import de.keksuccino.fancymenu.FancyMenu;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_7367;

public class MainWindowHandler {
    private static String windowtitle = null;
    private static File icondir = new File(FancyMenu.MOD_DIR, "/minecraftwindow/icons");

    public static void init() {
        if (!icondir.exists()) {
            icondir.mkdirs();
        }
    }

    public static void handleForceFullscreen() {
        try {
            if (class_310.method_1551() != null && class_310.method_1551().method_22683() != null) {
                if (((Boolean)FancyMenu.config.getOrDefault("forcefullscreen", (Object)false)).booleanValue() && !class_310.method_1551().method_22683().method_4498()) {
                    class_310.method_1551().method_22683().method_4500();
                    FancyMenu.LOGGER.info("[FANCYMENU] Forced window to fullscreen!");
                }
            } else {
                FancyMenu.LOGGER.error("[FANCYMENU] Force fullscreen failed! Instance or window was NULL!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateWindowIcon() {
        if (((Boolean)FancyMenu.config.getOrDefault("customwindowicon", (Object)false)).booleanValue()) {
            try {
                File i16 = new File(icondir.getPath() + "/icon16x16.png");
                File i32 = new File(icondir.getPath() + "/icon32x32.png");
                if (!i16.exists() || !i32.exists()) {
                    System.out.println("## ERROR ## [FANCYMENU] Unable to set custom icons: 'icon16x16.png' or 'icon32x32.png' missing!");
                    return;
                }
                BufferedImage i16buff = ImageIO.read(i16);
                if (i16buff.getHeight() != 16 || i16buff.getWidth() != 16) {
                    System.out.println("'## ERROR ## [FANCYMENU] Unable to set custom icons: 'icon16x16.png' not 16x16!");
                    return;
                }
                BufferedImage i32buff = ImageIO.read(i32);
                if (i32buff.getHeight() != 32 || i32buff.getWidth() != 32) {
                    System.out.println("'## ERROR ## [FANCYMENU] Unable to set custom icons: 'icon32x32.png' not 32x32!");
                    return;
                }
                class_310.method_1551().method_22683().method_4491(class_7367.create((Path)i16.toPath()), class_7367.create((Path)i32.toPath()));
                System.out.println("[FANCYMENU] Custom minecraft icon successfully loaded!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateWindowTitle() {
        String s = (String)FancyMenu.config.getOrDefault("customwindowtitle", (Object)"");
        if (s != null && !s.equals("")) {
            windowtitle = s;
            MainWindowHandler.setWindowTitle();
        } else {
            windowtitle = null;
        }
    }

    private static void setWindowTitle() {
        if (windowtitle != null) {
            class_310.method_1551().method_22683().method_24286(windowtitle);
        }
    }

    public static String getCustomWindowTitle() {
        return windowtitle;
    }

    public static int getWindowGuiWidth() {
        class_437 s = class_310.method_1551().field_1755;
        if (s != null) {
            double mcScale = class_310.method_1551().method_22683().method_4476((int)class_310.method_1551().method_22683().method_4495(), ((Boolean)class_310.method_1551().field_1690.method_42437().method_41753()).booleanValue());
            float baseUIScale = 1.0f;
            float sc = (float)((double)baseUIScale * ((double)baseUIScale / mcScale));
            return (int)((float)s.field_22789 / sc);
        }
        return 0;
    }

    public static int getWindowGuiHeight() {
        class_437 s = class_310.method_1551().field_1755;
        if (s != null) {
            double mcScale = class_310.method_1551().method_22683().method_4476((int)class_310.method_1551().method_22683().method_4495(), ((Boolean)class_310.method_1551().field_1690.method_42437().method_41753()).booleanValue());
            float baseUIScale = 1.0f;
            float sc = (float)((double)baseUIScale * ((double)baseUIScale / mcScale));
            return (int)((float)s.field_22790 / sc);
        }
        return 0;
    }
}

