/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.api.background.example.with_input_string;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.api.Nonnull;
import de.keksuccino.fancymenu.api.background.MenuBackground;
import de.keksuccino.fancymenu.api.background.MenuBackgroundType;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.io.File;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ExampleMenuBackgroundForInputString
extends MenuBackground {
    private ExternalTextureResourceLocation imageLocation = null;

    public ExampleMenuBackgroundForInputString(@Nonnull MenuBackgroundType type, String imagePath) {
        super("unused_identifier", type);
        File imageFile = new File(imagePath);
        if (imageFile.exists() && (imageFile.getPath().toLowerCase().endsWith(".jpg") || imageFile.getPath().toLowerCase().endsWith(".jpeg") || imageFile.getPath().toLowerCase().endsWith(".png"))) {
            this.imageLocation = TextureHandler.getResource((String)imageFile.getPath());
            if (this.imageLocation != null) {
                this.imageLocation.loadTexture();
            }
        }
    }

    @Override
    public void onOpenMenu() {
    }

    @Override
    public void render(class_4587 matrix, class_437 screen, boolean keepAspectRatio) {
        try {
            if (this.imageLocation != null && this.imageLocation.isReady()) {
                RenderSystem.enableBlend();
                RenderUtils.bindTexture((class_2960)this.imageLocation.getResourceLocation());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!keepAspectRatio) {
                    class_332.method_25290((class_4587)matrix, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)screen.field_22789, (int)screen.field_22790, (int)screen.field_22789, (int)screen.field_22790);
                } else {
                    int w = this.imageLocation.getWidth();
                    int h = this.imageLocation.getHeight();
                    double ratio = (double)w / (double)h;
                    int wfinal = (int)((double)screen.field_22790 * ratio);
                    int screenCenterX = screen.field_22789 / 2;
                    if (wfinal < screen.field_22789) {
                        class_332.method_25290((class_4587)matrix, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)screen.field_22789, (int)screen.field_22790, (int)screen.field_22789, (int)screen.field_22790);
                    } else {
                        class_332.method_25290((class_4587)matrix, (int)(screenCenterX - wfinal / 2), (int)0, (float)1.0f, (float)1.0f, (int)wfinal, (int)screen.field_22790, (int)wfinal, (int)screen.field_22790);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

