/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.fabrishot.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import me.ramidzkh.fabrishot.Fabrishot;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;

public class Config {
    public static String CUSTOM_FILE_NAME = "huge_%time%";
    public static boolean OVERRIDE_SCREENSHOT_KEY = false;
    public static boolean SAVE_FILE = true;
    public static int CAPTURE_WIDTH = 3840;
    public static int CAPTURE_HEIGHT = 2160;
    public static int CAPTURE_DELAY = 3;
    private static final Path CONFIG = FabricLoader.getInstance().getConfigDir().resolve("fabrishot.properties");

    static void save() {
        Properties properties = new Properties();
        properties.put("custom_file_name", CUSTOM_FILE_NAME);
        properties.put("override_screenshot_key", String.valueOf(OVERRIDE_SCREENSHOT_KEY));
        properties.put("save_file", String.valueOf(SAVE_FILE));
        properties.put("width", String.valueOf(CAPTURE_WIDTH));
        properties.put("height", String.valueOf(CAPTURE_HEIGHT));
        properties.put("delay", String.valueOf(CAPTURE_DELAY));
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG, new OpenOption[0]);){
            properties.store(writer, "Fabrishot screenshot config");
        }
        catch (IOException exception) {
            LogManager.getLogger(Fabrishot.class).error(exception.getMessage(), (Throwable)exception);
        }
    }

    static {
        try (BufferedReader reader = Files.newBufferedReader(CONFIG);){
            Properties properties = new Properties();
            properties.load(reader);
            CUSTOM_FILE_NAME = properties.getProperty("custom_file_name", "huge_%time%");
            OVERRIDE_SCREENSHOT_KEY = Boolean.parseBoolean(properties.getProperty("override_screenshot_key"));
            SAVE_FILE = Boolean.parseBoolean(properties.getProperty("save_file"));
            CAPTURE_WIDTH = Integer.parseInt(properties.getProperty("width"));
            CAPTURE_HEIGHT = Integer.parseInt(properties.getProperty("height"));
            CAPTURE_DELAY = Integer.parseInt(properties.getProperty("delay"));
        }
        catch (Exception ignored) {
            Config.save();
        }
    }
}

