/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.fabrishot.capture;

import java.io.IOException;
import java.nio.file.Path;
import me.ramidzkh.fabrishot.MinecraftInterface;
import me.ramidzkh.fabrishot.capture.FramebufferCapturer;
import me.ramidzkh.fabrishot.capture.FramebufferWriter;
import me.ramidzkh.fabrishot.config.Config;
import net.minecraft.class_156;

public class CaptureTask {
    private final Path file;
    private int frame;
    private int displayWidth;
    private int displayHeight;

    public CaptureTask(Path file) {
        this.file = file;
    }

    public Path getFile() {
        return this.file;
    }

    public boolean onRenderTick() {
        if (this.frame == 0) {
            this.displayWidth = MinecraftInterface.getDisplayWidth();
            this.displayHeight = MinecraftInterface.getDisplayHeight();
            int width = Config.CAPTURE_WIDTH;
            int height = Config.CAPTURE_HEIGHT;
            MinecraftInterface.resize(width, height);
        } else if (this.frame >= Config.CAPTURE_DELAY) {
            try {
                FramebufferCapturer fbc = new FramebufferCapturer();
                fbc.capture();
                if (Config.SAVE_FILE) {
                    class_156.method_27958().execute(() -> {
                        FramebufferWriter fbw = new FramebufferWriter(this.file, fbc);
                        try {
                            fbw.write();
                        }
                        catch (IOException exception) {
                            exception.printStackTrace();
                        }
                    });
                }
            }
            finally {
                MinecraftInterface.resize(this.displayWidth, this.displayHeight);
            }
        }
        ++this.frame;
        return this.frame > Config.CAPTURE_DELAY;
    }
}

