/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.util.object;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.amerebagatelle.fabricskyboxes.FabricSkyBoxesClient;
import io.github.amerebagatelle.fabricskyboxes.util.object.Blender;
import java.util.function.Consumer;

public class Blend {
    public static final Blend DEFAULT = new Blend("", Blender.DEFAULT);
    public static final Blend DECORATIONS = new Blend("decorations", Blender.DECORATIONS);
    public static Codec<Blend> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("type", (Object)"").forGetter(Blend::getType), (App)Blender.CODEC.optionalFieldOf("blender", (Object)Blender.DEFAULT).forGetter(Blend::getBlender)).apply((Applicative)instance, Blend::new));
    private final String type;
    private final Blender blender;
    private final Consumer<Float> blendFunc;

    public Blend(String type, Blender blender) {
        this.type = type;
        this.blender = blender;
        if (!type.isEmpty()) {
            switch (type) {
                case "add": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                        RenderSystem.blendEquation((int)Blender.Equation.ADD.value);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
                    };
                    break;
                }
                case "subtract": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
                        RenderSystem.blendEquation((int)Blender.Equation.ADD.value);
                        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)1.0f);
                    };
                    break;
                }
                case "multiply": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                        RenderSystem.blendEquation((int)Blender.Equation.ADD.value);
                        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue());
                    };
                    break;
                }
                case "screen": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR);
                        RenderSystem.blendEquation((int)Blender.Equation.ADD.value);
                        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)1.0f);
                    };
                    break;
                }
                case "replace": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                        RenderSystem.blendEquation((int)Blender.Equation.ADD.value);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
                    };
                    break;
                }
                case "alpha": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                        RenderSystem.blendEquation((int)Blender.Equation.ADD.value);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
                    };
                    break;
                }
                case "burn": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR);
                        RenderSystem.blendEquation((int)Blender.Equation.ADD.value);
                        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)1.0f);
                    };
                    break;
                }
                case "dodge": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                        RenderSystem.blendEquation((int)Blender.Equation.ADD.value);
                        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)1.0f);
                    };
                    break;
                }
                case "disable": {
                    this.blendFunc = alpha -> {
                        RenderSystem.disableBlend();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
                    };
                    break;
                }
                case "decorations": {
                    this.blendFunc = Blender.DECORATIONS::applyBlendFunc;
                    break;
                }
                case "custom": {
                    this.blendFunc = this.blender::applyBlendFunc;
                    break;
                }
                default: {
                    FabricSkyBoxesClient.getLogger().error("Blend mode is set to an invalid or unsupported value.");
                    this.blendFunc = alpha -> {
                        RenderSystem.defaultBlendFunc();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
                    };
                    break;
                }
            }
        } else {
            this.blendFunc = alpha -> {
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
            };
        }
    }

    public void applyBlendFunc(float alpha) {
        this.blendFunc.accept(Float.valueOf(alpha));
    }

    public String getType() {
        return this.type;
    }

    public Blender getBlender() {
        return this.blender;
    }
}

