/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.util;

import com.google.common.collect.Range;
import com.mojang.serialization.Codec;
import io.github.amerebagatelle.fabricskyboxes.FabricSkyBoxesClient;
import io.github.amerebagatelle.fabricskyboxes.api.skyboxes.FSBSkybox;
import io.github.amerebagatelle.fabricskyboxes.api.skyboxes.Skybox;
import io.github.amerebagatelle.fabricskyboxes.util.object.MinMaxEntry;
import io.github.amerebagatelle.fabricskyboxes.util.object.RGBA;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_3532;

public class Utils {
    public static boolean checkRanges(double value, List<MinMaxEntry> minMaxEntries) {
        return minMaxEntries.isEmpty() || minMaxEntries.stream().anyMatch(minMaxEntry -> Range.closed((Comparable)Float.valueOf(minMaxEntry.getMin()), (Comparable)Float.valueOf(minMaxEntry.getMax())).contains((Comparable)Float.valueOf((float)value)));
    }

    public static <T> T warnIfDifferent(T initialValue, T finalValue, String message) {
        if (!initialValue.equals(finalValue) && FabricSkyBoxesClient.config().generalSettings.debugMode) {
            FabricSkyBoxesClient.getLogger().warn(message);
        }
        return finalValue;
    }

    public static int normalizeTickTime(int tickTime) {
        int result = tickTime % 24000;
        return result >= 0 ? result : result + 24000;
    }

    public static boolean isInTimeInterval(int currentTime, int startTime, int endTime) {
        if (currentTime < 0 || currentTime >= 24000) {
            throw new RuntimeException("Invalid current time, value must be between 0-23999: " + currentTime);
        }
        if (startTime <= endTime) {
            return currentTime >= startTime && currentTime <= endTime;
        }
        return currentTime >= startTime || currentTime <= endTime;
    }

    public static RGBA alphaBlendFogColors(List<Skybox> skyboxList, RGBA initialFogColor) {
        List<RGBA> activeColors = skyboxList.stream().filter(Skybox::isActive).filter(FSBSkybox.class::isInstance).map(FSBSkybox.class::cast).filter(fsbSkybox -> fsbSkybox.getProperties().isChangeFog()).map(fsbSkybox -> new RGBA(fsbSkybox.getProperties().getFogColors().getRed(), fsbSkybox.getProperties().getFogColors().getGreen(), fsbSkybox.getProperties().getFogColors().getBlue(), fsbSkybox.getAlpha() / fsbSkybox.getProperties().getMaxAlpha())).toList();
        if (activeColors.size() == 0) {
            return null;
        }
        RGBA destination = initialFogColor;
        for (RGBA source : activeColors) {
            float sourceAlphaInv = 1.0f - source.getAlpha();
            float red = source.getRed() * source.getAlpha() + destination.getRed() * sourceAlphaInv;
            float green = source.getGreen() * source.getAlpha() + destination.getGreen() * sourceAlphaInv;
            float blue = source.getBlue() * source.getAlpha() + destination.getBlue() * sourceAlphaInv;
            float alpha = source.getAlpha() * source.getAlpha() + destination.getAlpha() * sourceAlphaInv;
            destination = new RGBA(red, green, blue, alpha);
        }
        return destination;
    }

    public static RGBA weightedAdditiveBlendFogColors(List<Skybox> skyboxList, RGBA initialFogColor) {
        float[] colorSum = new float[4];
        List<RGBA> activeColors = skyboxList.stream().filter(Skybox::isActive).filter(FSBSkybox.class::isInstance).map(FSBSkybox.class::cast).filter(fsbSkybox -> fsbSkybox.getProperties().isChangeFog()).map(fsbSkybox -> new RGBA(fsbSkybox.getProperties().getFogColors().getRed(), fsbSkybox.getProperties().getFogColors().getGreen(), fsbSkybox.getProperties().getFogColors().getBlue(), fsbSkybox.getAlpha() / fsbSkybox.getProperties().getMaxAlpha())).toList();
        if (activeColors.size() == 0) {
            return null;
        }
        for (RGBA rgba : activeColors) {
            colorSum[0] = colorSum[0] + rgba.getRed() * rgba.getAlpha();
            colorSum[1] = colorSum[1] + rgba.getGreen() * rgba.getAlpha();
            colorSum[2] = colorSum[2] + rgba.getBlue() * rgba.getAlpha();
            colorSum[3] = colorSum[3] + rgba.getAlpha();
        }
        float finalAlpha = colorSum[3];
        RGBA activeColorsMixed = new RGBA(colorSum[0] / finalAlpha, colorSum[1] / finalAlpha, colorSum[2] / finalAlpha);
        Optional<RGBA> activeColorsHighestAlpha = activeColors.stream().max(Comparator.comparingDouble(RGBA::getAlpha));
        float activeColorsMaxAlpha = activeColorsHighestAlpha.get().getAlpha();
        float diffMul = 1.0f - activeColorsMaxAlpha;
        RGBA originalFogColorModified = new RGBA(initialFogColor.getRed() * diffMul, initialFogColor.getGreen() * diffMul, initialFogColor.getBlue() * diffMul);
        RGBA activeColorsMixedFinal = new RGBA(activeColorsMixed.getRed() * activeColorsMaxAlpha, activeColorsMixed.getGreen() * activeColorsMaxAlpha, activeColorsMixed.getBlue() * activeColorsMaxAlpha);
        return new RGBA(originalFogColorModified.getRed() + activeColorsMixedFinal.getRed(), originalFogColorModified.getGreen() + activeColorsMixedFinal.getGreen(), originalFogColorModified.getBlue() + activeColorsMixedFinal.getBlue());
    }

    public static float calculateFadeAlphaValue(float maxAlpha, int currentTime, int startFadeIn, int endFadeIn, int startFadeOut, int endFadeOut) {
        if (Utils.isInTimeInterval(currentTime, endFadeIn, startFadeOut)) {
            return maxAlpha;
        }
        if (Utils.isInTimeInterval(currentTime, startFadeIn, endFadeIn)) {
            return (float)(currentTime - startFadeIn) / (float)(endFadeIn - startFadeIn) * maxAlpha;
        }
        if (Utils.isInTimeInterval(currentTime, startFadeOut, endFadeOut)) {
            return 1.0f - (float)(currentTime - startFadeOut) / (float)(endFadeOut - startFadeOut) * maxAlpha;
        }
        return 0.0f;
    }

    public static float calculateConditionAlphaValue(float maxAlpha, float lastAlpha, int duration, boolean in) {
        if (duration == 0) {
            return lastAlpha;
        }
        if (in && maxAlpha == lastAlpha) {
            return maxAlpha;
        }
        if (!in && lastAlpha == 0.0f) {
            return 0.0f;
        }
        float alphaChange = maxAlpha / (float)duration;
        float result = in ? lastAlpha + alphaChange : lastAlpha - alphaChange;
        return class_3532.method_15363((float)result, (float)0.0f, (float)maxAlpha);
    }

    public static Codec<Integer> getClampedInteger(int min, int max) {
        if (min > max) {
            throw new UnsupportedOperationException("Maximum value was lesser than than the minimum value");
        }
        return Codec.INT.xmap(f -> class_3532.method_15340((int)f, (int)min, (int)max), Function.identity());
    }

    public static Codec<Float> getClampedFloat(float min, float max) {
        if (min > max) {
            throw new UnsupportedOperationException("Maximum value was lesser than than the minimum value");
        }
        return Codec.FLOAT.xmap(f -> Float.valueOf(class_3532.method_15363((float)f.floatValue(), (float)min, (float)max)), Function.identity());
    }

    public static Codec<Double> getClampedDouble(double min, double max) {
        if (min > max) {
            throw new UnsupportedOperationException("Maximum value was lesser than than the minimum value");
        }
        return Codec.DOUBLE.xmap(f -> class_3532.method_15350((double)f, (double)min, (double)max), Function.identity());
    }
}

