/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.skyboxes.textured;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.amerebagatelle.fabricskyboxes.api.skyboxes.RotatableSkybox;
import io.github.amerebagatelle.fabricskyboxes.mixin.skybox.WorldRendererAccess;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.AbstractSkybox;
import io.github.amerebagatelle.fabricskyboxes.util.object.Blend;
import io.github.amerebagatelle.fabricskyboxes.util.object.Conditions;
import io.github.amerebagatelle.fabricskyboxes.util.object.Decorations;
import io.github.amerebagatelle.fabricskyboxes.util.object.Properties;
import io.github.amerebagatelle.fabricskyboxes.util.object.Rotation;
import java.util.Objects;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class TexturedSkybox
extends AbstractSkybox
implements RotatableSkybox {
    public Rotation rotation;
    public Blend blend;

    protected TexturedSkybox() {
    }

    protected TexturedSkybox(Properties properties, Conditions conditions, Decorations decorations, Blend blend) {
        super(properties, conditions, decorations);
        this.blend = blend;
        this.rotation = properties.getRotation();
    }

    @Override
    public final void render(WorldRendererAccess worldRendererAccess, class_4587 matrices, Matrix4f matrix4f, float tickDelta, class_4184 camera, boolean thickFog) {
        double timeRotationY;
        double timeRotationX;
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34542);
        this.blend.applyBlendFunc(this.alpha);
        class_638 world = Objects.requireNonNull(class_310.method_1551().field_1687);
        Vector3f rotationStatic = this.rotation.getStatic();
        matrices.method_22903();
        double d = this.rotation.getRotationSpeedX() != 0.0f ? (this.rotation.getSkyboxRotation() ? 360.0 * class_3532.method_15367((double)((double)world.method_8532() / (24000.0 / (double)this.rotation.getRotationSpeedX())), (double)1.0) : 360.0 * (double)world.method_8597().method_28528((long)(24000.0 * class_3532.method_15367((double)((double)world.method_8532() / (24000.0 / (double)this.rotation.getRotationSpeedX())), (double)1.0)))) : (timeRotationX = 0.0);
        double d2 = this.rotation.getRotationSpeedY() != 0.0f ? (this.rotation.getSkyboxRotation() ? 360.0 * class_3532.method_15367((double)((double)world.method_8532() / (24000.0 / (double)this.rotation.getRotationSpeedY())), (double)1.0) : 360.0 * (double)world.method_8597().method_28528((long)(24000.0 * class_3532.method_15367((double)((double)world.method_8532() / (24000.0 / (double)this.rotation.getRotationSpeedY())), (double)1.0)))) : (timeRotationY = 0.0);
        double timeRotationZ = this.rotation.getRotationSpeedZ() != 0.0f ? (this.rotation.getSkyboxRotation() ? 360.0 * class_3532.method_15367((double)((double)world.method_8532() / (24000.0 / (double)this.rotation.getRotationSpeedZ())), (double)1.0) : 360.0 * (double)world.method_8597().method_28528((long)(24000.0 * class_3532.method_15367((double)((double)world.method_8532() / (24000.0 / (double)this.rotation.getRotationSpeedZ())), (double)1.0)))) : 0.0;
        this.applyTimeRotation(matrices, (float)timeRotationX, (float)timeRotationY, (float)timeRotationZ);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(rotationStatic.x()));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rotationStatic.y()));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(rotationStatic.z()));
        RenderSystem.enableTexture();
        this.renderSkybox(worldRendererAccess, matrices, tickDelta, camera, thickFog);
        RenderSystem.disableTexture();
        matrices.method_22909();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        this.renderDecorations(worldRendererAccess, matrices, matrix4f, tickDelta, bufferBuilder, this.alpha);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public abstract void renderSkybox(WorldRendererAccess var1, class_4587 var2, float var3, class_4184 var4, boolean var5);

    private void applyTimeRotation(class_4587 matrices, float timeRotationX, float timeRotationY, float timeRotationZ) {
        Vector3f timeRotationAxis = this.rotation.getAxis();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(timeRotationAxis.x()));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(timeRotationAxis.y()));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(timeRotationAxis.z()));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(timeRotationX));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(timeRotationY));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(timeRotationZ));
        matrices.method_22907(class_7833.field_40717.rotationDegrees(timeRotationAxis.z()));
        matrices.method_22907(class_7833.field_40715.rotationDegrees(timeRotationAxis.y()));
        matrices.method_22907(class_7833.field_40713.rotationDegrees(timeRotationAxis.x()));
    }

    public Blend getBlend() {
        return this.blend;
    }

    @Override
    public Rotation getRotation() {
        return this.rotation;
    }
}

