/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_handlers;

import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.utils.ETFUtils2;

public enum ETFDirectory {
    DOES_NOT_EXIST(null),
    ETF(new String[]{"textures", "etf/random"}),
    OLD_OPTIFINE(new String[]{"textures/entity", "optifine/mob"}),
    OPTIFINE(new String[]{"textures", "optifine/random"}),
    VANILLA(null);

    private static Object2ReferenceOpenHashMap<@NotNull class_2960, @NotNull ETFDirectory> ETF_DIRECTORY_CACHE;
    private final String[] replaceStrings;

    private ETFDirectory(String[] replaceStrings) {
        this.replaceStrings = replaceStrings;
    }

    public static void resetCache() {
        ETF_DIRECTORY_CACHE = new Object2ReferenceOpenHashMap();
    }

    public static Object2ReferenceOpenHashMap<@NotNull class_2960, @NotNull ETFDirectory> getCache() {
        if (ETF_DIRECTORY_CACHE == null) {
            ETF_DIRECTORY_CACHE = new Object2ReferenceOpenHashMap();
        }
        return ETF_DIRECTORY_CACHE;
    }

    @Nullable
    public static class_2960 getDirectoryVersionOf(class_2960 vanillaIdentifier) {
        ETFDirectory directory = ETFDirectory.getDirectoryOf(vanillaIdentifier);
        return switch (directory) {
            case DOES_NOT_EXIST -> null;
            case VANILLA -> vanillaIdentifier;
            default -> ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, directory);
        };
    }

    @NotNull
    public static ETFDirectory getDirectoryOf(class_2960 vanillaIdentifier) {
        Object2ReferenceOpenHashMap<@NotNull class_2960, @NotNull ETFDirectory> cache = ETFDirectory.getCache();
        if (!cache.containsKey((Object)vanillaIdentifier)) {
            cache.put((Object)vanillaIdentifier, (Object)ETFDirectory.findDirectoryOf(vanillaIdentifier));
        }
        return (ETFDirectory)((Object)cache.get((Object)vanillaIdentifier));
    }

    @NotNull
    private static ETFDirectory findDirectoryOf(class_2960 vanillaIdentifier) {
        Optional resource;
        if (vanillaIdentifier.method_12832().contains("etf/random/entity")) {
            resource = class_310.method_1551().method_1478().method_14486(vanillaIdentifier);
            if (resource.isPresent()) {
                return ETF;
            }
        } else if (vanillaIdentifier.method_12832().contains("optifine/random/entity")) {
            resource = class_310.method_1551().method_1478().method_14486(vanillaIdentifier);
            if (resource.isPresent()) {
                return OPTIFINE;
            }
        } else if (vanillaIdentifier.method_12832().contains("optifine/mob") && (resource = class_310.method_1551().method_1478().method_14486(vanillaIdentifier)).isPresent()) {
            return OLD_OPTIFINE;
        }
        ObjectArrayList foundDirectories = new ObjectArrayList();
        class_3300 resources = class_310.method_1551().method_1478();
        if (resources.method_14486(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, VANILLA)).isPresent()) {
            foundDirectories.add((Object)VANILLA);
        }
        if (resources.method_14486(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, OLD_OPTIFINE)).isPresent()) {
            foundDirectories.add((Object)OLD_OPTIFINE);
        }
        if (resources.method_14486(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, OPTIFINE)).isPresent()) {
            foundDirectories.add((Object)OPTIFINE);
        }
        if (resources.method_14486(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, ETF)).isPresent()) {
            foundDirectories.add((Object)ETF);
        }
        if (foundDirectories.isEmpty()) {
            return DOES_NOT_EXIST;
        }
        if (foundDirectories.size() == 1) {
            return (ETFDirectory)((Object)foundDirectories.get(0));
        }
        Object2ReferenceOpenHashMap resourcePackNames = new Object2ReferenceOpenHashMap();
        for (ETFDirectory directory : foundDirectories) {
            Optional resource2 = resources.method_14486(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, directory));
            resource2.ifPresent(value -> resourcePackNames.put((Object)value.method_14480(), (Object)directory));
        }
        String[] strArray = (String[])resourcePackNames.keySet().toArray((Object[])new String[0]);
        String returnedPack = ETFUtils2.returnNameOfHighestPackFromTheseMultiple(strArray);
        if (returnedPack != null) {
            return (ETFDirectory)((Object)resourcePackNames.get((Object)returnedPack));
        }
        return VANILLA;
    }

    @NotNull
    public static class_2960 getIdentifierAsDirectory(class_2960 identifier, ETFDirectory directory) {
        if (directory.doesReplace()) {
            return new class_2960(identifier.method_12836(), identifier.method_12832().replace(directory.replaceStrings[0], directory.replaceStrings[1]));
        }
        return identifier;
    }

    public boolean doesReplace() {
        return this.replaceStrings != null;
    }

    static {
        ETF_DIRECTORY_CACHE = null;
    }
}

