/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.jem_objects;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFOptiFinePartNameMappings;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.OptifineMobNameForFileAndEMFMapId;

public class EMFJemData {
    public final LinkedHashMap<String, LinkedHashMap<String, String>> allTopLevelAnimationsByVanillaPartName = new LinkedHashMap();
    public String texture = "";
    public int[] textureSize = null;
    public double shadow_size = 1.0;
    public LinkedList<EMFPartData> models = new LinkedList();
    public LinkedList<EMFPartData> originalModelsForReadingOnly;
    public String fileName = "none";
    public String filePath = "";
    public OptifineMobNameForFileAndEMFMapId mobModelIDInfo = null;
    public class_2960 customTexture = null;

    @Nullable
    public class_2960 validateJemTexture(String texture) {
        if (!((String)(texture = ((String)texture).trim())).isBlank()) {
            String[] directorySplit;
            if (!((String)texture).endsWith(".png")) {
                texture = (String)texture + ".png";
            }
            if (!((String)texture).contains("/") && (directorySplit = this.fileName.split("/")).length > 1) {
                String lastDirectoryComponentOfFileName = directorySplit[directorySplit.length - 1];
                String folderOfModel = this.fileName.replace(lastDirectoryComponentOfFileName, "");
                texture = folderOfModel + (String)texture;
            }
            class_2960 possibleTexture = new class_2960((String)texture);
            if (class_310.method_1551().method_1478().method_14486(possibleTexture).isPresent()) {
                return possibleTexture;
            }
        }
        return null;
    }

    public void prepare(String fileName, OptifineMobNameForFileAndEMFMapId mobModelIDInfo) {
        this.mobModelIDInfo = mobModelIDInfo;
        this.fileName = fileName;
        String[] directorySplit = fileName.split("/");
        if (directorySplit.length > 1) {
            String lastDirectoryComponentOfFileName = directorySplit[directorySplit.length - 1];
            this.filePath = fileName.replace(lastDirectoryComponentOfFileName, "");
        }
        this.originalModelsForReadingOnly = new LinkedList<EMFPartData>(this.models);
        this.customTexture = this.validateJemTexture(this.texture);
        String mapId = mobModelIDInfo.getMapId();
        Map<String, String> map = EMFOptiFinePartNameMappings.getMapOf(mapId, null);
        for (EMFPartData partData : this.models) {
            if (partData.part == null || !map.containsKey(partData.part)) continue;
            partData.part = map.get(partData.part);
        }
        for (EMFPartData model : this.models) {
            model.prepare(this.textureSize, this, this.customTexture);
        }
        TreeMap alphabeticalOrderedParts = new TreeMap(Comparator.naturalOrder());
        if (EMFConfig.getConfig().logModelCreationData) {
            EMFUtils.EMFModMessage("originalModelsForReadingOnly #= " + this.originalModelsForReadingOnly.size());
        }
        for (EMFPartData partData : this.originalModelsForReadingOnly) {
            String newId = EMFUtils.getIdUnique(alphabeticalOrderedParts.keySet(), partData.id);
            if (!newId.equals(partData.id)) {
                partData.id = newId;
            }
            alphabeticalOrderedParts.put(partData.id, partData);
        }
        if (EMFConfig.getConfig().logModelCreationData) {
            EMFUtils.EMFModMessage("alphabeticalOrderedParts = " + alphabeticalOrderedParts);
        }
        for (EMFPartData part : alphabeticalOrderedParts.values()) {
            if (part.animations == null) continue;
            for (LinkedHashMap linkedHashMap : part.animations) {
                LinkedHashMap thisPartsAnimations = new LinkedHashMap();
                linkedHashMap.forEach((key, anim) -> {
                    key = key.trim().replaceAll("\\s", "");
                    anim = anim.trim().replaceAll("\\s", "");
                    if (key.startsWith("this.")) {
                        key = key.replaceFirst("this", part.id);
                    }
                    if (anim.contains("this.")) {
                        anim = anim.replaceAll("this", part.id);
                    }
                    if (!key.isBlank() && !anim.isBlank()) {
                        thisPartsAnimations.put(key, anim);
                    }
                });
                if (thisPartsAnimations.isEmpty()) continue;
                if (this.allTopLevelAnimationsByVanillaPartName.containsKey(part.part)) {
                    this.allTopLevelAnimationsByVanillaPartName.get(part.part).putAll(thisPartsAnimations);
                    continue;
                }
                this.allTopLevelAnimationsByVanillaPartName.put(part.part, thisPartsAnimations);
            }
        }
    }

    public String toString() {
        return "EMF_JemData{texture='" + this.texture + "', textureSize=" + Arrays.toString(this.textureSize) + ", shadow_size=" + this.shadow_size + ", models=" + this.models.toString() + "}";
    }

    public static class EMFJemPrinter {
        public String texture = "";
        public int[] textureSize = new int[]{16, 16};
        public double shadow_size = 1.0;
        public LinkedList<EMFPartData.EMFPartPrinter> models = new LinkedList();
    }
}

