/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.animation_math_parser;

import traben.entity_model_features.models.animation.animation_math_parser.MathAction;
import traben.entity_model_features.models.animation.animation_math_parser.MathComponent;
import traben.entity_model_features.models.animation.animation_math_parser.MathConstant;
import traben.entity_model_features.models.animation.animation_math_parser.MathValue;

public class MathBinaryExpressionComponent
extends MathValue
implements MathComponent {
    private final MathComponent first;
    private final MathAction action;
    private final MathComponent second;

    private MathBinaryExpressionComponent(MathComponent first, MathAction action, MathComponent second, boolean isNegative) {
        super(isNegative);
        this.first = first;
        this.action = action;
        this.second = second;
    }

    public static MathComponent getOptimizedExpression(MathComponent first, MathAction action, MathComponent second) {
        return MathBinaryExpressionComponent.getOptimizedExpression(first, action, second, false);
    }

    public static MathComponent getOptimizedExpression(MathComponent first, MathAction action, MathComponent second, boolean isnegative) {
        MathBinaryExpressionComponent component = new MathBinaryExpressionComponent(first, action, second, isnegative);
        if (component.first.isConstant() && component.second.isConstant()) {
            return new MathConstant(component.get(), isnegative);
        }
        return component;
    }

    @Override
    public MathValue.ValueSupplier getSupplier() {
        return null;
    }

    @Override
    public float get() {
        float value = this.action.execute(this.first, this.second);
        return this.isNegative ? -value : value;
    }

    public String toString() {
        return "[oExp:{" + this.first + ", " + this.action + ", " + this.second + "}=" + this.get() + "]";
    }
}

