/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2586;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.mixin.accessor.ModelPartAccessor;
import traben.entity_model_features.models.EMFModelPartCustom;
import traben.entity_model_features.models.EMFModelPartRoot;
import traben.entity_model_features.models.EMFModelPartVanilla;
import traben.entity_model_features.models.animation.EMFAnimationHelper;
import traben.entity_texture_features.ETFApi;

public abstract class EMFModelPart
extends class_630 {
    public class_2960 textureOverride;
    protected class_287 MODIFIED_RENDER_BUFFER = null;

    public EMFModelPart(List<class_630.class_628> cuboids, Map<String, class_630> children) {
        super(cuboids, children);
    }

    @Nullable
    private class_2960 getTextureOverrideViaETF(int renderLight) {
        if (renderLight == 0xF000F2) {
            if (EMFAnimationHelper.getEMFEntity().entity() != null) {
                return ETFApi.getCurrentETFEmissiveTextureOfEntityOrNull((class_1297)EMFAnimationHelper.getEMFEntity().entity(), (class_2960)this.textureOverride);
            }
            if (EMFAnimationHelper.getEMFEntity().getBlockEntity() != null) {
                return null;
            }
            return null;
        }
        if (EMFAnimationHelper.getEMFEntity().entity() != null) {
            return ETFApi.getCurrentETFVariantTextureOfEntity((class_1297)EMFAnimationHelper.getEMFEntity().entity(), (class_2960)this.textureOverride);
        }
        if (EMFAnimationHelper.getEMFEntity().getBlockEntity() != null) {
            return ETFApi.getCurrentETFVariantTextureOfEntity((class_2586)EMFAnimationHelper.getEMFEntity().getBlockEntity(), (class_2960)this.textureOverride, (UUID)EMFAnimationHelper.getEMFEntity().getUuid());
        }
        return this.textureOverride;
    }

    void primaryRender(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.textureOverride != null && light != 0xF000F1 && EMFAnimationHelper.getEMFEntity() != null) {
            class_2960 texture = this.getTextureOverrideViaETF(light);
            if (texture != null) {
                try {
                    class_1921 layer = class_1921.method_23580((class_2960)texture);
                    if (this.MODIFIED_RENDER_BUFFER == null) {
                        this.MODIFIED_RENDER_BUFFER = new class_287(layer.method_22722());
                    }
                    this.MODIFIED_RENDER_BUFFER.method_1328(layer.method_23033(), layer.method_23031());
                    this.renderToSuper(matrices, (class_4588)this.MODIFIED_RENDER_BUFFER, light, overlay, red, green, blue, alpha);
                    layer.method_23012(this.MODIFIED_RENDER_BUFFER, 0, 0, 0);
                    this.MODIFIED_RENDER_BUFFER.method_1343();
                }
                catch (Exception exception) {}
            }
        } else {
            this.renderToSuper(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    void renderToSuper(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        super.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    protected void method_22702(class_4587.class_4665 entry, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        for (class_630.class_628 cuboid : ((ModelPartAccessor)((Object)this)).getCuboids()) {
            cuboid.method_32089(entry, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
    }

    public String toString() {
        return "generic emf part";
    }

    public Map<String, class_630> getChildrenEMF() {
        return ((ModelPartAccessor)((Object)this)).getChildren();
    }

    abstract class_630 getVanillaModelPartsOfCurrentState();

    public Object2ReferenceOpenHashMap<String, EMFModelPart> getAllChildPartsAsAnimationMap(String prefixableParents, int variantNum, Map<String, String> optifinePartNameMap) {
        EMFModelPart eMFModelPart = this;
        if (eMFModelPart instanceof EMFModelPartRoot) {
            EMFModelPartRoot root = (EMFModelPartRoot)eMFModelPart;
            root.setVariantStateTo(variantNum);
        }
        Object2ReferenceOpenHashMap mapOfAll = new Object2ReferenceOpenHashMap();
        Map<String, class_630> children = this.getChildrenEMF();
        for (class_630 part : children.values()) {
            boolean addThis;
            String thisKey;
            if (!(part instanceof EMFModelPart)) continue;
            EMFModelPart part3 = (EMFModelPart)part;
            if (part instanceof EMFModelPartCustom) {
                EMFModelPartCustom partc = (EMFModelPartCustom)part;
                thisKey = partc.id;
                addThis = true;
            } else if (part instanceof EMFModelPartVanilla) {
                EMFModelPartVanilla partv = (EMFModelPartVanilla)part;
                thisKey = partv.name;
                addThis = partv.isOptiFinePartSpecified;
            } else {
                thisKey = "NULL_KEY_NAME";
                addThis = false;
            }
            for (Map.Entry<String, String> entry : optifinePartNameMap.entrySet()) {
                if (!entry.getValue().equals(thisKey)) continue;
                thisKey = entry.getKey();
                break;
            }
            if (addThis) {
                mapOfAll.put((Object)thisKey, (Object)part3);
                if (prefixableParents.isBlank()) {
                    mapOfAll.putAll(part3.getAllChildPartsAsAnimationMap(thisKey, variantNum, optifinePartNameMap));
                    continue;
                }
                mapOfAll.put((Object)(prefixableParents + ":" + thisKey), (Object)part3);
                mapOfAll.putAll(part3.getAllChildPartsAsAnimationMap(prefixableParents + ":" + thisKey, variantNum, optifinePartNameMap));
                continue;
            }
            mapOfAll.putAll(part3.getAllChildPartsAsAnimationMap(prefixableParents, variantNum, optifinePartNameMap));
        }
        return mapOfAll;
    }

    public static class Animator
    implements Runnable {
        private Runnable animation = null;

        Animator() {
        }

        public Runnable getAnimation() {
            return this.animation;
        }

        public void setAnimation(Runnable animation) {
            this.animation = animation;
        }

        @Override
        public void run() {
            if (this.animation != null) {
                this.animation.run();
            }
        }
    }
}

