/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.config;

import io.github.kosmx.emotes.common.SerializableConfig;
import io.github.kosmx.emotes.common.tools.BiMap;
import io.github.kosmx.emotes.executor.dataTypes.InputKey;
import java.util.List;
import java.util.UUID;

public class ClientConfig
extends SerializableConfig {
    public final SerializableConfig.BooleanConfigEntry dark;
    public final SerializableConfig.BooleanConfigEntry oldChooseWheel;
    public final SerializableConfig.ConfigEntry<Boolean> enablePerspective;
    public final SerializableConfig.BooleanConfigEntry frontAsTPPerspective;
    public final SerializableConfig.ConfigEntry<Boolean> showIcons;
    public final SerializableConfig.ConfigEntry<Boolean> enableNSFW;
    public final SerializableConfig.ConfigEntry<Boolean> alwaysValidate;
    public final SerializableConfig.ConfigEntry<Boolean> enablePlayerSafety;
    public final SerializableConfig.ConfigEntry<Float> stopThreshold;
    public final SerializableConfig.ConfigEntry<Float> yRatio;
    public final SerializableConfig.ConfigEntry<Boolean> showHiddenConfig;
    public final SerializableConfig.ConfigEntry<Boolean> neverRemoveBadIcon;
    public final SerializableConfig.ConfigEntry<Boolean> exportBuiltin;
    public BiMap<UUID, InputKey> emoteKeyMap;
    public UUID[][] fastMenuEmotes;
    public final SerializableConfig.ConfigEntry<Boolean> hideWarningMessage;

    public ClientConfig() {
        this.dark = new SerializableConfig.BooleanConfigEntry("dark", (Boolean)false, false, (List<SerializableConfig.ConfigEntry<?>>)this.basics);
        this.oldChooseWheel = new SerializableConfig.BooleanConfigEntry("oldChooseWheel", (Boolean)false, false, (List<SerializableConfig.ConfigEntry<?>>)this.basics);
        this.enablePerspective = new SerializableConfig.BooleanConfigEntry("perspective", (Boolean)true, false, (List<SerializableConfig.ConfigEntry<?>>)this.basics);
        this.frontAsTPPerspective = new SerializableConfig.BooleanConfigEntry("default3rdPersonFront", (Boolean)false, false, (List<SerializableConfig.ConfigEntry<?>>)this.basics);
        this.showIcons = new SerializableConfig.BooleanConfigEntry("showicon", "showIcon", (Boolean)true, false, (List<SerializableConfig.ConfigEntry<?>>)this.basics);
        this.enableNSFW = new SerializableConfig.BooleanConfigEntry("enableNSFW", (Boolean)false, true, (List<SerializableConfig.ConfigEntry<?>>)this.basics);
        this.alwaysValidate = new SerializableConfig.BooleanConfigEntry("alwaysValidateEmote", (Boolean)false, true, (List<SerializableConfig.ConfigEntry<?>>)this.expert);
        this.enablePlayerSafety = new SerializableConfig.BooleanConfigEntry("playersafety", (Boolean)true, true, (List<SerializableConfig.ConfigEntry<?>>)this.expert);
        this.stopThreshold = new SerializableConfig.FloatConfigEntry("stopthreshold", "stopThreshold", Float.valueOf(0.04f), true, this.expert, "options.generic_value", -3.912f, 8.0f, 0.0f){

            @Override
            public double getConfigVal() {
                return Math.log(((Float)this.get()).floatValue());
            }

            @Override
            public void setConfigVal(double newVal) {
                this.set(Float.valueOf((float)Math.exp(newVal)));
            }
        };
        this.yRatio = new SerializableConfig.FloatConfigEntry("yratio", "yRatio", Float.valueOf(0.75f), true, this.expert, "options.percent_value", 0.0f, 100.0f, 1.0f){

            @Override
            public double getConfigVal() {
                return ((Float)this.get()).floatValue() * 100.0f;
            }

            @Override
            public void setConfigVal(double newVal) {
                this.set(Float.valueOf((float)(newVal / 100.0)));
            }

            @Override
            public double getTextVal() {
                return this.getConfigVal();
            }
        };
        this.showHiddenConfig = new SerializableConfig.BooleanConfigEntry("showHiddenConfig", false, true, this.expert, false);
        this.neverRemoveBadIcon = new SerializableConfig.BooleanConfigEntry("neverRemoveBadIcon", (Boolean)false, (List<SerializableConfig.ConfigEntry<?>>)this.expert, true);
        this.exportBuiltin = new SerializableConfig.BooleanConfigEntry("exportBuiltin", (Boolean)false, (List<SerializableConfig.ConfigEntry<?>>)this.expert, true);
        this.emoteKeyMap = new BiMap();
        this.fastMenuEmotes = new UUID[10][8];
        this.hideWarningMessage = new SerializableConfig.BooleanConfigEntry("hideWarning", (Boolean)false, (List<SerializableConfig.ConfigEntry<?>>)this.expert, true);
        this.loadEmotesServerSide.set(false);
    }
}

