/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items.bars;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.api.item.CustomizationItem;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public abstract class AbstractProgressBarCustomizationItem
extends CustomizationItem {
    public BarDirection direction = BarDirection.RIGHT;
    public String barColorHex = "#5295FF";
    public Color barColor = new Color(82, 149, 255);
    public String barTexturePath;
    public class_2960 barTexture = null;
    public String backgroundColorHex = "#ABC8F7";
    public Color backgroundColor = new Color(171, 200, 247);
    public String backgroundTexturePath;
    public class_2960 backgroundTexture = null;
    public boolean useProgressForElementOrientation = false;
    protected int lastProgressX = 0;
    protected int lastProgressY = 0;
    protected int lastProgressWidth = 0;
    protected int lastProgressHeight = 0;

    public AbstractProgressBarCustomizationItem(CustomizationItemContainer parentContainer, PropertiesSection item) {
        super(parentContainer, item);
        String barDirection;
        File f;
        Color c;
        String backgroundHex;
        File f2;
        Color c2;
        String barHex;
        String progressForElementOri = item.getEntryValue("progress_for_element_orientation");
        if (progressForElementOri != null && progressForElementOri.equalsIgnoreCase("true")) {
            this.useProgressForElementOrientation = true;
        }
        if ((barHex = item.getEntryValue("bar_color")) != null && !barHex.replace(" ", "").equals("") && (c2 = RenderUtils.getColorFromHexString((String)barHex)) != null) {
            this.barColorHex = barHex;
            this.barColor = c2;
        }
        this.barTexturePath = item.getEntryValue("bar_texture");
        if (this.barTexturePath != null && (f2 = new File(MenuCustomization.getAbsoluteGameDirectoryPath((String)this.barTexturePath))).exists() && (f2.getName().toLowerCase().endsWith(".jpg") || f2.getName().toLowerCase().endsWith(".jpeg") || f2.getName().toLowerCase().endsWith(".png"))) {
            this.barTexture = TextureHandler.getResource((String)f2.getAbsolutePath()).getResourceLocation();
        }
        if ((backgroundHex = item.getEntryValue("background_color")) != null && !backgroundHex.replace(" ", "").equals("") && (c = RenderUtils.getColorFromHexString((String)backgroundHex)) != null) {
            this.backgroundColorHex = backgroundHex;
            this.backgroundColor = c;
        }
        this.backgroundTexturePath = item.getEntryValue("background_texture");
        if (this.backgroundTexturePath != null && (f = new File(MenuCustomization.getAbsoluteGameDirectoryPath((String)this.backgroundTexturePath))).exists() && (f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".jpeg") || f.getName().toLowerCase().endsWith(".png"))) {
            this.backgroundTexture = TextureHandler.getResource((String)f.getAbsolutePath()).getResourceLocation();
        }
        if ((barDirection = item.getEntryValue("direction")) != null) {
            this.direction = BarDirection.byName(barDirection);
        }
    }

    public void render(class_4587 matrix, class_437 menu) throws IOException {
        if (this.shouldRender()) {
            RenderSystem.enableBlend();
            this.renderBackground(matrix, menu);
            this.renderProgress(matrix, menu);
        }
    }

    protected void renderProgress(class_4587 matrix, class_437 menu) {
        float currentProgress = Math.max(0.0f, Math.min(1.0f, this.getCurrentProgress()));
        int progressWidth = this.getWidth();
        int progressHeight = this.getHeight();
        int progressX = this.getPosX(menu);
        int progressY = this.getPosY(menu);
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (this.direction == BarDirection.LEFT || this.direction == BarDirection.RIGHT) {
            progressWidth = (int)((float)this.getWidth() * currentProgress);
        }
        if (this.direction == BarDirection.UP || this.direction == BarDirection.DOWN) {
            progressHeight = (int)((float)this.getHeight() * currentProgress);
        }
        if (this.direction == BarDirection.LEFT) {
            progressX += this.getWidth() - progressWidth;
            offsetX = this.getWidth() - progressWidth;
        }
        if (this.direction == BarDirection.UP) {
            progressY += this.getHeight() - progressHeight;
            offsetY = this.getHeight() - progressHeight;
        }
        this.lastProgressX = progressX;
        this.lastProgressY = progressY;
        this.lastProgressWidth = progressWidth;
        this.lastProgressHeight = progressHeight;
        if (this.barTexture != null) {
            RenderUtils.bindTexture((class_2960)this.barTexture);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
            AbstractProgressBarCustomizationItem.method_25290((class_4587)matrix, (int)progressX, (int)progressY, (float)offsetX, (float)offsetY, (int)progressWidth, (int)progressHeight, (int)this.getWidth(), (int)this.getHeight());
        } else if (this.barColor != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.fill((class_4587)matrix, (float)progressX, (float)progressY, (float)(progressX + progressWidth), (float)(progressY + progressHeight), (int)this.barColor.getRGB(), (float)this.opacity);
        }
    }

    protected void renderBackground(class_4587 matrix, class_437 menu) {
        if (this.backgroundTexture != null) {
            RenderUtils.bindTexture((class_2960)this.backgroundTexture);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
            AbstractProgressBarCustomizationItem.method_25290((class_4587)matrix, (int)this.getPosX(menu), (int)this.getPosY(menu), (float)0.0f, (float)0.0f, (int)this.getWidth(), (int)this.getHeight(), (int)this.getWidth(), (int)this.getHeight());
        } else if (this.barColor != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.fill((class_4587)matrix, (float)this.getPosX(menu), (float)this.getPosY(menu), (float)(this.getPosX(menu) + this.getWidth()), (float)(this.getPosY(menu) + this.getHeight()), (int)this.backgroundColor.getRGB(), (float)this.opacity);
        }
    }

    public abstract float getCurrentProgress();

    public int getProgressX() {
        return this.lastProgressX;
    }

    public int getProgressY() {
        return this.lastProgressY;
    }

    public int getProgressWidth() {
        return this.lastProgressWidth;
    }

    public int getProgressHeight() {
        return this.lastProgressHeight;
    }

    public static enum BarDirection {
        LEFT("left"),
        RIGHT("right"),
        UP("up"),
        DOWN("down");

        private String name;

        private BarDirection(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static BarDirection byName(String name) {
            for (BarDirection d : BarDirection.values()) {
                if (!d.name.equals(name)) continue;
                return d;
            }
            return LEFT;
        }
    }
}

