/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.moonlightconfigs.fabric.values;

import com.google.gson.JsonObject;
import java.util.function.Predicate;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigBuilder;
import nl.enjarai.doabarrelroll.moonlightconfigs.fabric.values.ConfigValue;

public class StringConfigValue
extends ConfigValue<String> {
    private final Predicate<Object> validator;

    public StringConfigValue(String name, String defaultValue, Predicate<Object> validator) {
        super(name, defaultValue);
        this.validator = validator;
    }

    @Override
    public boolean isValid(String value) {
        return this.validator.test(value);
    }

    @Override
    public void loadFromJson(JsonObject element) {
        if (element.has(this.name)) {
            try {
                this.value = element.get(this.name).getAsString();
                if (this.isValid((String)this.value)) {
                    return;
                }
                this.value = this.defaultValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConfigBuilder.LOGGER.warn("Config file had incorrect entry {}, correcting", (Object)this.name);
        } else {
            ConfigBuilder.LOGGER.warn("Config file had missing entry {}", (Object)this.name);
        }
    }

    @Override
    public void saveToJson(JsonObject object) {
        if (this.value == null) {
            this.value = this.defaultValue;
        }
        object.addProperty(this.name, (String)this.value);
    }
}

