/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.moonlightconfigs.fabric.values;

import java.util.Objects;
import net.minecraft.class_2561;
import nl.enjarai.doabarrelroll.moonlightconfigs.fabric.ConfigEntry;
import nl.enjarai.doabarrelroll.util.Value;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigValue<T>
extends ConfigEntry
implements Value<T> {
    protected final T defaultValue;
    protected T value;
    private String descriptionKey;

    public ConfigValue(String name, T defaultValue) {
        super(name);
        this.defaultValue = defaultValue;
        Objects.requireNonNull(defaultValue, "default value cant be null");
        assert (this.isValid(defaultValue)) : "default value is invalid";
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public abstract boolean isValid(T var1);

    @Override
    public void accept(T t) {
        if (!this.isValid(t)) {
            throw new IllegalArgumentException("value is invalid");
        }
        this.value = t;
    }

    public void set(T newValue) {
        this.value = newValue;
    }

    @Override
    public T get() {
        return this.value;
    }

    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    @Nullable
    public class_2561 getDescription() {
        if (this.descriptionKey == null) {
            return null;
        }
        return class_2561.method_43471((String)this.descriptionKey);
    }
}

