/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.moonlightconfigs.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigBuilder;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigSpec;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigType;
import nl.enjarai.doabarrelroll.moonlightconfigs.cloth_config.ClothConfigCompat;
import nl.enjarai.doabarrelroll.moonlightconfigs.fabric.ConfigSubCategory;
import nl.enjarai.doabarrelroll.moonlightconfigs.yacl.YACLCompat;

public class FabricConfigSpec
extends ConfigSpec {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_2960 res;
    private final ConfigSubCategory mainEntry;
    private final File file = this.getFullPath().toFile();
    private static final boolean YACL = FabricLoader.getInstance().isModLoaded("yet-another-config-lib");
    private static final boolean clothConfig = FabricLoader.getInstance().getAllMods().stream().anyMatch(container -> container.getMetadata().getId().startsWith("cloth-config"));

    public FabricConfigSpec(class_2960 name, ConfigSubCategory mainEntry, ConfigType type, boolean synced, Runnable changeCallback) {
        super(name, FabricLoader.getInstance().getConfigDir(), type, synced, changeCallback);
        this.mainEntry = mainEntry;
        this.res = name;
    }

    public ConfigSubCategory getMainEntry() {
        return this.mainEntry;
    }

    @Override
    public void register() {
        FabricConfigSpec.addTrackedSpec(this);
    }

    @Override
    public void loadFromFile() {
        JsonElement config = null;
        if (this.file.exists() && this.file.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(this.file);
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                config = (JsonElement)GSON.fromJson((Reader)bufferedReader, JsonElement.class);
            }
            catch (IOException e2) {
                throw new RuntimeException("Failed to load config", e2);
            }
        }
        if (config instanceof JsonObject) {
            JsonObject jo = (JsonObject)config;
            this.mainEntry.getEntries().forEach(e -> e.loadFromJson(jo));
        }
    }

    @Override
    public void save() {
        try (FileOutputStream stream = new FileOutputStream(this.file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            JsonObject jo = new JsonObject();
            this.mainEntry.getEntries().forEach(e -> e.saveToJson(jo));
            GSON.toJson((JsonElement)jo, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.onRefresh();
    }

    public class_2561 getName() {
        return class_2561.method_43470((String)ConfigBuilder.getReadableName(this.res.method_12832() + "_configs"));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_437 makeScreen(class_437 parent, class_2960 background) {
        if (YACL) {
            try {
                return YACLCompat.makeScreen(parent, this, background);
            }
            catch (Throwable t) {
                ConfigBuilder.LOGGER.error("Failed to create YACL screen, attempting fallback", t);
            }
        }
        if (clothConfig) {
            try {
                return ClothConfigCompat.makeScreen(parent, this, background);
            }
            catch (Throwable t) {
                ConfigBuilder.LOGGER.error("Failed to create Cloth Config screen", t);
            }
        }
        return null;
    }

    @Override
    public boolean hasConfigScreen() {
        return clothConfig || YACL;
    }

    @Override
    public void loadFromBytes(InputStream stream) {
        InputStreamReader inputStreamReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        JsonElement config = (JsonElement)GSON.fromJson((Reader)bufferedReader, JsonElement.class);
        if (config instanceof JsonObject) {
            JsonObject jo = (JsonObject)config;
            this.mainEntry.getEntries().forEach(e -> e.loadFromJson(jo));
        }
        this.onRefresh();
    }
}

