/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.moonlightconfigs.fabric;

import java.util.List;
import java.util.Stack;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigBuilder;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigType;
import nl.enjarai.doabarrelroll.moonlightconfigs.fabric.ConfigSubCategory;
import nl.enjarai.doabarrelroll.moonlightconfigs.fabric.FabricConfigSpec;
import nl.enjarai.doabarrelroll.moonlightconfigs.fabric.values.BoolConfigValue;
import nl.enjarai.doabarrelroll.moonlightconfigs.fabric.values.ColorConfigValue;
import nl.enjarai.doabarrelroll.moonlightconfigs.fabric.values.ConfigValue;
import nl.enjarai.doabarrelroll.moonlightconfigs.fabric.values.DoubleConfigValue;
import nl.enjarai.doabarrelroll.moonlightconfigs.fabric.values.EnumConfigValue;
import nl.enjarai.doabarrelroll.moonlightconfigs.fabric.values.IntConfigValue;
import nl.enjarai.doabarrelroll.moonlightconfigs.fabric.values.ListStringConfigValue;
import nl.enjarai.doabarrelroll.moonlightconfigs.fabric.values.StringConfigValue;
import nl.enjarai.doabarrelroll.util.CombinedValue;
import nl.enjarai.doabarrelroll.util.Value;
import org.jetbrains.annotations.NotNull;

public class ConfigBuilderImpl
extends ConfigBuilder {
    private final ConfigSubCategory mainCategory = new ConfigSubCategory(this.getName().method_12836());
    private final Stack<ConfigSubCategory> categoryStack = new Stack();

    public static ConfigBuilder create(class_2960 name, ConfigType type) {
        return new ConfigBuilderImpl(name, type);
    }

    public ConfigBuilderImpl(class_2960 name, ConfigType type) {
        super(name, type);
        this.categoryStack.push(this.mainCategory);
    }

    @Override
    @NotNull
    public FabricConfigSpec build() {
        assert (this.categoryStack.size() == 1);
        FabricConfigSpec spec = new FabricConfigSpec(this.getName(), this.mainCategory, this.type, this.synced, this.changeCallback);
        spec.loadFromFile();
        spec.save();
        return spec;
    }

    @Override
    protected String currentCategory() {
        return this.categoryStack.peek().getName();
    }

    @Override
    public ConfigBuilderImpl push(String name) {
        ConfigSubCategory cat = new ConfigSubCategory(name);
        cat.setTranslationKey(this.categoryTranslationKey(name));
        this.categoryStack.peek().addEntry(cat);
        this.categoryStack.push(cat);
        return this;
    }

    @Override
    public ConfigBuilderImpl pop() {
        assert (this.categoryStack.size() != 1);
        this.categoryStack.pop();
        return this;
    }

    private void doAddConfig(String name, ConfigValue<?> config) {
        config.setTranslationKey(this.translationKey(name));
        this.maybeAddTranslationString(name);
        if (this.currentlyDescription) {
            String tooltipKey = this.tooltipKey(name);
            config.setDescriptionKey(tooltipKey);
            this.currentlyDescription = false;
        }
        this.categoryStack.peek().addEntry(config);
    }

    @Override
    public Value<Boolean> define(String name, boolean defaultValue) {
        BoolConfigValue config = new BoolConfigValue(name, defaultValue);
        this.doAddConfig(name, config);
        return config;
    }

    @Override
    public Value<Double> define(String name, double defaultValue, double min, double max) {
        DoubleConfigValue config = new DoubleConfigValue(name, defaultValue, min, max);
        this.doAddConfig(name, config);
        return config;
    }

    @Override
    public Value<Integer> define(String name, int defaultValue, int min, int max) {
        IntConfigValue config = new IntConfigValue(name, defaultValue, min, max);
        this.doAddConfig(name, config);
        return config;
    }

    @Override
    public Value<Integer> defineColor(String name, int defaultValue) {
        ColorConfigValue config = new ColorConfigValue(name, defaultValue);
        this.doAddConfig(name, config);
        return config;
    }

    @Override
    public Value<String> define(String name, String defaultValue, Predicate<Object> validator) {
        StringConfigValue config = new StringConfigValue(name, defaultValue, validator);
        this.doAddConfig(name, config);
        return config;
    }

    @Override
    public <T extends String> Value<List<String>> define(String name, List<? extends T> defaultValue, Predicate<Object> predicate) {
        ListStringConfigValue config = new ListStringConfigValue(name, defaultValue, predicate);
        this.doAddConfig(name, config);
        return config;
    }

    @Override
    public <V extends Enum<V>> Value<V> define(String name, V defaultValue) {
        EnumConfigValue<V> config = new EnumConfigValue<V>(name, defaultValue);
        this.doAddConfig(name, config);
        return config;
    }

    public <T> Value<List<? extends T>> defineForgeList(String path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
        return new CombinedValue<List<? extends T>>(value -> {}, () -> defaultValue);
    }

    @Override
    protected void maybeAddTranslationString(String name) {
        this.comments.put(this.translationKey(name), ConfigBuilderImpl.getReadableName(name));
        super.maybeAddTranslationString(name);
    }
}

