/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.flight.util;

import java.util.function.BooleanSupplier;
import net.minecraft.class_3540;
import nl.enjarai.doabarrelroll.config.Sensitivity;
import nl.enjarai.doabarrelroll.flight.util.ConfiguresRotation;

public class RotationInstant {
    private final double pitch;
    private final double yaw;
    private final double roll;
    private final double renderDelta;

    public RotationInstant(double pitch, double yaw, double roll, double renderDelta) {
        this.pitch = pitch;
        this.yaw = yaw;
        this.roll = roll;
        this.renderDelta = renderDelta;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getRoll() {
        return this.roll;
    }

    public double getRenderDelta() {
        return this.renderDelta;
    }

    public RotationInstant add(double pitch, double yaw, double roll) {
        return new RotationInstant(this.pitch + pitch, this.yaw + yaw, this.roll + roll, this.renderDelta);
    }

    public RotationInstant addAbsolute(double x, double y, double currentRoll) {
        double cos = Math.cos(currentRoll);
        double sin = Math.sin(currentRoll);
        return new RotationInstant(this.pitch - y * cos - x * sin, this.yaw - y * sin + x * cos, this.roll, this.renderDelta);
    }

    public RotationInstant smooth(class_3540 pitchSmoother, class_3540 yawSmoother, class_3540 rollSmoother, Sensitivity smoothness) {
        return new RotationInstant(pitchSmoother.method_15429(this.pitch, smoothness.pitch * this.renderDelta), yawSmoother.method_15429(this.yaw, smoothness.yaw * this.renderDelta), rollSmoother.method_15429(this.roll, smoothness.roll * this.renderDelta), this.renderDelta);
    }

    public RotationInstant applySensitivity(Sensitivity sensitivity) {
        return new RotationInstant(this.pitch * sensitivity.pitch, this.yaw * sensitivity.yaw, this.roll * sensitivity.roll, this.renderDelta);
    }

    public RotationInstant useModifier(ConfiguresRotation modifier, BooleanSupplier condition) {
        return condition.getAsBoolean() ? modifier.apply(this) : this;
    }

    public RotationInstant useModifier(ConfiguresRotation modifier) {
        return this.useModifier(modifier, () -> true);
    }
}

