/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.config;

import architectury_inject_doabarrelroll_common_c330369828f049ee9ac0dc929a4bbdfe_c3986c1ba37efefe1b757a5dccd391083caff3a629f12113a0257b088550abe5doabarrelroll2621193devjar.PlatformMethods;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.DoABarrelRollClient;
import nl.enjarai.doabarrelroll.config.ActivationBehaviour;
import nl.enjarai.doabarrelroll.config.Sensitivity;
import nl.enjarai.doabarrelroll.config.SyncedModConfig;
import nl.enjarai.doabarrelroll.flight.util.RotationInstant;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigBuilder;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigSpec;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigType;
import nl.enjarai.doabarrelroll.util.Value;

public class ModConfig {
    public static ModConfig INSTANCE = new ModConfig();
    public ConfigSpec SPEC;
    private final Value<Boolean> MOD_ENABLED;
    private final Value<Boolean> SWITCH_ROLL_AND_YAW;
    private final Value<Boolean> MOMENTUM_BASED_MOUSE;
    private final Value<Boolean> SHOW_MOMENTUM_WIDGET;
    private final Value<Boolean> INVERT_PITCH;
    private final Value<ActivationBehaviour> ACTIVATION_BEHAVIOUR;
    private final Value<Boolean> ENABLE_BANKING;
    private final Value<Double> BANKING_STRENGTH;
    private final Value<Boolean> ENABLE_THRUST;
    private final Value<Double> MAX_THRUST;
    private final Value<Double> THRUST_ACCELERATION;
    private final Value<Boolean> THRUST_PARTICLES;
    private final Value<Double> SMOOTHING_PITCH;
    private final Value<Double> SMOOTHING_YAW;
    private final Value<Double> SMOOTHING_ROLL;
    private final Value<Double> DESKTOP_SENSITIVITY_PITCH;
    private final Value<Double> DESKTOP_SENSITIVITY_YAW;
    private final Value<Double> DESKTOP_SENSITIVITY_ROLL;
    private final Value<Double> CONTROLLER_SENSITIVITY_PITCH;
    private final Value<Double> CONTROLLER_SENSITIVITY_YAW;
    private final Value<Double> CONTROLLER_SENSITIVITY_ROLL;

    public static void touch() {
    }

    private ModConfig() {
        ConfigBuilder builder = ConfigBuilder.create(DoABarrelRoll.id("client"), ConfigType.CLIENT);
        builder.push("general");
        this.MOD_ENABLED = builder.define("mod_enabled", true);
        builder.push("controls");
        this.SWITCH_ROLL_AND_YAW = builder.withDescription().define("switch_roll_and_yaw", false);
        this.INVERT_PITCH = builder.define("invert_pitch", false);
        this.MOMENTUM_BASED_MOUSE = builder.withDescription().define("momentum_based_mouse", false);
        this.SHOW_MOMENTUM_WIDGET = builder.withDescription().define("show_momentum_widget", true);
        this.ACTIVATION_BEHAVIOUR = builder.withDescription().define("activation_behaviour", ActivationBehaviour.VANILLA);
        builder.pop();
        builder.push("banking");
        this.ENABLE_BANKING = builder.withDescription().define("enable_banking", true);
        this.BANKING_STRENGTH = builder.define("banking_strength", 20.0, 0.0, 100.0);
        builder.pop();
        if (!Objects.equals(PlatformMethods.getCurrentTarget(), "forge")) {
            builder.push("thrust");
            this.ENABLE_THRUST = builder.withDescription().define("enable_thrust", false);
            this.MAX_THRUST = builder.withDescription().define("max_thrust", 2.0, 0.1, 10.0);
            this.THRUST_ACCELERATION = builder.withDescription().define("thrust_acceleration", 0.01, 0.1, 1.0);
            this.THRUST_PARTICLES = builder.define("thrust_particles", true);
            builder.pop();
        } else {
            this.ENABLE_THRUST = Value.of(false);
            this.MAX_THRUST = Value.of(2.0);
            this.THRUST_ACCELERATION = Value.of(0.1);
            this.THRUST_PARTICLES = Value.of(true);
        }
        builder.pop();
        builder.push("sensitivity");
        builder.push("smoothing");
        this.SMOOTHING_PITCH = builder.define("smoothing_pitch", 1.0, 0.0, 2.0);
        this.SMOOTHING_YAW = builder.define("smoothing_yaw", 0.4, 0.0, 2.0);
        this.SMOOTHING_ROLL = builder.define("smoothing_roll", 1.0, 0.0, 2.0);
        builder.pop();
        builder.push("desktop");
        this.DESKTOP_SENSITIVITY_PITCH = builder.define("pitch", 1.0, 0.0, 2.0);
        this.DESKTOP_SENSITIVITY_YAW = builder.define("yaw", 0.4, 0.0, 2.0);
        this.DESKTOP_SENSITIVITY_ROLL = builder.define("roll", 1.0, 0.0, 2.0);
        builder.pop();
        if (!Objects.equals(PlatformMethods.getCurrentTarget(), "forge")) {
            builder.push("controller");
            this.CONTROLLER_SENSITIVITY_PITCH = builder.withDescription().define("pitch", 1.0, 0.0, 2.0);
            this.CONTROLLER_SENSITIVITY_YAW = builder.withDescription().define("yaw", 0.4, 0.0, 2.0);
            this.CONTROLLER_SENSITIVITY_ROLL = builder.withDescription().define("roll", 1.0, 0.0, 2.0);
            builder.pop();
        } else {
            this.CONTROLLER_SENSITIVITY_PITCH = Value.of(1.0);
            this.CONTROLLER_SENSITIVITY_YAW = Value.of(0.4);
            this.CONTROLLER_SENSITIVITY_ROLL = Value.of(1.0);
        }
        builder.pop();
        this.SPEC = builder.buildAndRegister();
    }

    public boolean getModEnabled() {
        return (Boolean)this.MOD_ENABLED.get();
    }

    public boolean getSwitchRollAndYaw() {
        return (Boolean)this.SWITCH_ROLL_AND_YAW.get();
    }

    public boolean getMomentumBasedMouse() {
        return (Boolean)this.MOMENTUM_BASED_MOUSE.get();
    }

    public boolean getShowMomentumWidget() {
        return (Boolean)this.SHOW_MOMENTUM_WIDGET.get();
    }

    public boolean getInvertPitch() {
        return (Boolean)this.INVERT_PITCH.get();
    }

    public ActivationBehaviour getActivationBehaviour() {
        return (ActivationBehaviour)((Object)this.ACTIVATION_BEHAVIOUR.get());
    }

    public boolean getEnableBanking() {
        return (Boolean)this.ENABLE_BANKING.get();
    }

    public double getBankingStrength() {
        return (Double)this.BANKING_STRENGTH.get();
    }

    public boolean getEnableThrust() {
        return (Boolean)this.ENABLE_THRUST.get() != false && DoABarrelRollClient.HANDSHAKE_CLIENT.getConfig().map(SyncedModConfig::allowThrusting).orElse(true) != false;
    }

    public double getMaxThrust() {
        return (Double)this.MAX_THRUST.get();
    }

    public double getThrustAcceleration() {
        return (Double)this.THRUST_ACCELERATION.get();
    }

    public boolean getThrustParticles() {
        return (Boolean)this.THRUST_PARTICLES.get();
    }

    public Sensitivity getSmoothing() {
        return new Sensitivity((Double)this.SMOOTHING_PITCH.get(), (Double)this.SMOOTHING_YAW.get(), (Double)this.SMOOTHING_ROLL.get());
    }

    public Sensitivity getDesktopSensitivity() {
        return new Sensitivity((Double)this.DESKTOP_SENSITIVITY_PITCH.get(), (Double)this.DESKTOP_SENSITIVITY_YAW.get(), (Double)this.DESKTOP_SENSITIVITY_ROLL.get());
    }

    public Sensitivity getControllerSensitivity() {
        return new Sensitivity((Double)this.CONTROLLER_SENSITIVITY_PITCH.get(), (Double)this.CONTROLLER_SENSITIVITY_YAW.get(), (Double)this.CONTROLLER_SENSITIVITY_ROLL.get());
    }

    public void setModEnabled(boolean enabled) {
        this.MOD_ENABLED.accept(enabled);
    }

    public void setSwitchRollAndYaw(boolean enabled) {
        this.SWITCH_ROLL_AND_YAW.accept(enabled);
    }

    public void setMomentumBasedMouse(boolean enabled) {
        this.MOMENTUM_BASED_MOUSE.accept(enabled);
    }

    public void setShowMomentumWidget(boolean enabled) {
        this.SHOW_MOMENTUM_WIDGET.accept(enabled);
    }

    public void setInvertPitch(boolean enabled) {
        this.INVERT_PITCH.accept(enabled);
    }

    public void setActivationBehaviour(ActivationBehaviour behaviour) {
        this.ACTIVATION_BEHAVIOUR.accept(behaviour);
    }

    public void setEnableBanking(boolean enabled) {
        this.ENABLE_BANKING.accept(enabled);
    }

    public void setBankingStrength(double strength) {
        this.BANKING_STRENGTH.accept(strength);
    }

    public void setEnableThrust(boolean enabled) {
        this.ENABLE_THRUST.accept(enabled);
    }

    public void setMaxThrust(double thrust) {
        this.MAX_THRUST.accept(thrust);
    }

    public void setThrustAcceleration(double acceleration) {
        this.THRUST_ACCELERATION.accept(acceleration);
    }

    public void setThrustParticles(boolean enabled) {
        this.THRUST_PARTICLES.accept(enabled);
    }

    public void setDesktopSensitivity(Sensitivity sensitivity) {
        this.DESKTOP_SENSITIVITY_PITCH.accept(sensitivity.pitch);
        this.DESKTOP_SENSITIVITY_YAW.accept(sensitivity.yaw);
        this.DESKTOP_SENSITIVITY_ROLL.accept(sensitivity.roll);
    }

    public void setControllerSensitivity(Sensitivity sensitivity) {
        this.CONTROLLER_SENSITIVITY_PITCH.accept(sensitivity.pitch);
        this.CONTROLLER_SENSITIVITY_YAW.accept(sensitivity.yaw);
        this.CONTROLLER_SENSITIVITY_ROLL.accept(sensitivity.roll);
    }

    public void save() {
        this.SPEC.save();
    }

    public RotationInstant configureRotation(RotationInstant rotationInstant) {
        double pitch = rotationInstant.getPitch();
        double yaw = rotationInstant.getYaw();
        double roll = rotationInstant.getRoll();
        if (!this.getSwitchRollAndYaw()) {
            double temp = yaw;
            yaw = roll;
            roll = temp;
        }
        if (this.getInvertPitch()) {
            pitch = -pitch;
        }
        return new RotationInstant(pitch, yaw, roll, rotationInstant.getRenderDelta());
    }

    public void notifyPlayerOfServerConfig(SyncedModConfig serverConfig) {
        if (!serverConfig.allowThrusting() && ((Boolean)this.ENABLE_THRUST.get()).booleanValue()) {
            class_310.method_1551().method_1566().method_1999((class_368)class_370.method_29047((class_310)class_310.method_1551(), (class_370.class_371)class_370.class_371.field_2218, (class_2561)class_2561.method_43471((String)"toast.do_a_barrel_roll"), (class_2561)class_2561.method_43471((String)"toast.do_a_barrel_roll.thrusting_disabled_by_server")));
        }
        if (serverConfig.forceEnabled() && !((Boolean)this.MOD_ENABLED.get()).booleanValue()) {
            class_310.method_1551().method_1566().method_1999((class_368)class_370.method_29047((class_310)class_310.method_1551(), (class_370.class_371)class_370.class_371.field_2218, (class_2561)class_2561.method_43471((String)"toast.do_a_barrel_roll"), (class_2561)class_2561.method_43471((String)"toast.do_a_barrel_roll.mod_forced_enabled_by_server")));
        }
    }
}

