/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll;

import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3540;
import net.minecraft.class_3673;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import nl.enjarai.doabarrelroll.MomentumCrosshairWidget;
import nl.enjarai.doabarrelroll.api.event.RollEvents;
import nl.enjarai.doabarrelroll.api.net.HandshakeClient;
import nl.enjarai.doabarrelroll.config.ActivationBehaviour;
import nl.enjarai.doabarrelroll.config.ModConfig;
import nl.enjarai.doabarrelroll.config.Sensitivity;
import nl.enjarai.doabarrelroll.config.SyncedModConfig;
import nl.enjarai.doabarrelroll.flight.ElytraMath;
import nl.enjarai.doabarrelroll.flight.RotationModifiers;
import nl.enjarai.doabarrelroll.flight.util.RotationInstant;
import nl.enjarai.doabarrelroll.util.MixinHooks;
import nl.enjarai.doabarrelroll.util.Vec2d;

public class DoABarrelRollClient {
    public static final HandshakeClient<SyncedModConfig> HANDSHAKE_CLIENT = new HandshakeClient<SyncedModConfig>(SyncedModConfig.TRANSFER_CODEC, ModConfig.INSTANCE::notifyPlayerOfServerConfig);
    public static final class_3540 PITCH_SMOOTHER = new class_3540();
    public static final class_3540 YAW_SMOOTHER = new class_3540();
    public static final class_3540 ROLL_SMOOTHER = new class_3540();
    private static double lastLookUpdate;
    private static double lastLerpUpdate;
    public static double landingLerp;
    public static class_243 left;
    public static Vec2d mouseTurnVec;
    public static double throttle;

    public static void init() {
        RollEvents.SHOULD_ROLL_CHECK.register(DoABarrelRollClient::isFallFlying);
        RollEvents.EARLY_CAMERA_MODIFIERS.register((rotationDelta, currentRotation) -> rotationDelta.useModifier(RotationModifiers::manageThrottle, ModConfig.INSTANCE::getEnableThrust).useModifier(RotationModifiers.strafeButtons(1800.0)), 10, DoABarrelRollClient::isFallFlying);
        RollEvents.EARLY_CAMERA_MODIFIERS.register((rotationDelta, currentRotation) -> rotationDelta.useModifier(ModConfig.INSTANCE::configureRotation), 20, DoABarrelRollClient::isFallFlying);
        RollEvents.LATE_CAMERA_MODIFIERS.register((rotationDelta, currentRotation) -> rotationDelta.smooth(PITCH_SMOOTHER, YAW_SMOOTHER, ROLL_SMOOTHER, ModConfig.INSTANCE.getSmoothing()).useModifier(RotationModifiers::banking, ModConfig.INSTANCE::getEnableBanking), 10, DoABarrelRollClient::isFallFlying);
    }

    public static boolean updateMouse(class_746 player, double cursorDeltaX, double cursorDeltaY) {
        if (!DoABarrelRollClient.isRolling()) {
            return true;
        }
        landingLerp = 0.0;
        if (ModConfig.INSTANCE.getMomentumBasedMouse()) {
            Vec2d turnVec = mouseTurnVec.add(new Vec2d(cursorDeltaX, cursorDeltaY).multiply(0.0033333334140479565));
            if (turnVec.lengthSquared() > 1.0) {
                turnVec = turnVec.normalize();
            }
            mouseTurnVec = turnVec;
            double delta = DoABarrelRollClient.getDelta();
            Vec2d readyTurnVec = mouseTurnVec.multiply(1200.0f * (float)delta);
            DoABarrelRollClient.changeElytraLook(readyTurnVec.y, readyTurnVec.x, 0.0, ModConfig.INSTANCE.getDesktopSensitivity(), delta);
        } else {
            mouseTurnVec = Vec2d.ZERO;
            DoABarrelRollClient.changeElytraLook(cursorDeltaY, cursorDeltaX, 0.0, ModConfig.INSTANCE.getDesktopSensitivity());
        }
        return false;
    }

    public static void onWorldRender(class_310 client, float tickDelta, class_4587 matrix) {
        double time = class_3673.method_15974();
        double lerpDelta = time - lastLerpUpdate;
        lastLerpUpdate = time;
        if (!DoABarrelRollClient.isRolling()) {
            landingLerp = class_3532.method_16436((double)class_3532.method_15350((double)(lerpDelta * 2.0), (double)0.0, (double)1.0), (double)landingLerp, (double)1.0);
            if (landingLerp > 0.9) {
                landingLerp = 1.0;
            }
            DoABarrelRollClient.clearValues();
            if (client.field_1724 != null) {
                left = left.method_35590(ElytraMath.getAssumedLeft(client.field_1724.method_36454()), landingLerp);
            }
        } else if (client.method_1493()) {
            lastLookUpdate = class_3673.method_15974();
        } else {
            DoABarrelRollClient.changeElytraLook(0.0, 0.0, 0.0, ModConfig.INSTANCE.getDesktopSensitivity());
        }
        if (client.field_1724 != null && landingLerp < 1.0) {
            double angle = -Math.acos(class_3532.method_15350((double)left.method_1026(ElytraMath.getAssumedLeft(client.field_1724.method_36454())), (double)-1.0, (double)1.0)) * 57.29577951308232;
            if (left.method_10214() < 0.0) {
                angle *= -1.0;
            }
            if (client.field_1690.method_31044().method_31035()) {
                angle *= -1.0;
            }
            matrix.method_22907(class_7833.field_40718.rotationDegrees((float)angle));
        }
    }

    public static void onRenderCrosshair(class_4587 matrices, int scaledWidth, int scaledHeight) {
        if (!(DoABarrelRollClient.isFallFlying() && ModConfig.INSTANCE.getMomentumBasedMouse() && ModConfig.INSTANCE.getShowMomentumWidget())) {
            return;
        }
        MomentumCrosshairWidget.render(matrices, scaledWidth, scaledHeight, mouseTurnVec);
    }

    private static void clearValues() {
        PITCH_SMOOTHER.method_15428();
        YAW_SMOOTHER.method_15428();
        ROLL_SMOOTHER.method_15428();
        mouseTurnVec = Vec2d.ZERO;
        lastLookUpdate = class_3673.method_15974();
        throttle = 0.0;
    }

    private static double getDelta() {
        double time = class_3673.method_15974();
        double delta = time - lastLookUpdate;
        lastLookUpdate = time;
        return delta;
    }

    public static void changeElytraLook(double pitch, double yaw, double roll, Sensitivity sensitivity) {
        DoABarrelRollClient.changeElytraLook(pitch, yaw, roll, sensitivity, DoABarrelRollClient.getDelta());
    }

    public static void changeElytraLook(double pitch, double yaw, double roll, Sensitivity sensitivity, double delta) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        RotationInstant rotDelta = new RotationInstant(pitch, yaw, roll, delta);
        double currentRoll = ElytraMath.getRoll(player.method_36454(), left);
        RotationInstant currentRotation = new RotationInstant(player.method_36455(), player.method_36454(), currentRoll, 0.0);
        ElytraMath.changeElytraLookDirectly(player, RollEvents.lateCameraModifiers(RollEvents.earlyCameraModifiers(rotDelta, currentRotation).applySensitivity(sensitivity), currentRotation));
    }

    public static boolean isFallFlying() {
        class_746 player;
        if (!HANDSHAKE_CLIENT.getConfig().map(SyncedModConfig::forceEnabled).orElse(false).booleanValue()) {
            boolean hybrid;
            boolean bl = hybrid = ModConfig.INSTANCE.getActivationBehaviour() == ActivationBehaviour.HYBRID || ModConfig.INSTANCE.getActivationBehaviour() == ActivationBehaviour.HYBRID_TOGGLE;
            if (hybrid && !MixinHooks.thirdJump) {
                return false;
            }
            if (!ModConfig.INSTANCE.getModEnabled()) {
                return false;
            }
        }
        return (player = class_310.method_1551().field_1724) != null && player.method_6128();
    }

    public static boolean isRolling() {
        return RollEvents.shouldRoll();
    }

    static {
        landingLerp = 1.0;
        mouseTurnVec = Vec2d.ZERO;
        throttle = 0.0;
    }
}

