/*
 * Decompiled with CFR 0.152.
 */
package grondag.darkness;

import grondag.darkness.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.function.Function;
import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_765;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Darkness {
    public static Logger LOG = LogManager.getLogger((String)"Darkness");
    static boolean darkOverworld;
    static boolean darkDefault;
    static boolean darkNether;
    static double darkNetherFogEffective;
    static double darkNetherFogConfigured;
    static boolean darkEnd;
    static double darkEndFogEffective;
    static double darkEndFogConfigured;
    static boolean darkSkyless;
    static boolean blockLightOnly;
    static boolean ignoreMoonPhase;
    public static boolean enabled;
    private static final float[][] LUMINANCE;

    private static void computeConfigValues() {
        darkNetherFogEffective = darkNether ? darkNetherFogConfigured : 1.0;
        darkEndFogEffective = darkEnd ? darkEndFogConfigured : 1.0;
    }

    private static File getConfigFile() {
        File configDir = Platform.configDirectory().toFile();
        if (!configDir.exists()) {
            LOG.warn("[Darkness] Could not access configuration directory: " + configDir.getAbsolutePath());
        }
        return new File(configDir, "darkness.properties");
    }

    public static void saveConfig() {
        File configFile = Darkness.getConfigFile();
        Properties properties = new Properties();
        properties.put("only_affect_block_light", Boolean.toString(blockLightOnly));
        properties.put("ignore_moon_phase", Boolean.toString(ignoreMoonPhase));
        properties.put("dark_overworld", Boolean.toString(darkOverworld));
        properties.put("dark_default", Boolean.toString(darkDefault));
        properties.put("dark_nether", Boolean.toString(darkNether));
        properties.put("dark_nether_fog", Double.toString(darkNetherFogConfigured));
        properties.put("dark_end", Boolean.toString(darkEnd));
        properties.put("dark_end_fog", Double.toString(darkEndFogConfigured));
        properties.put("dark_skyless", Boolean.toString(darkSkyless));
        try (FileOutputStream stream = new FileOutputStream(configFile);){
            properties.store(stream, "Darkness properties file");
        }
        catch (IOException e) {
            LOG.warn("[Darkness] Could not store property file '" + configFile.getAbsolutePath() + "'", (Throwable)e);
        }
    }

    public static boolean blockLightOnly() {
        return blockLightOnly;
    }

    public static double darkNetherFog() {
        return darkNetherFogEffective;
    }

    public static double darkEndFog() {
        return darkEndFogEffective;
    }

    private static boolean isDark(class_1937 world) {
        class_5321 dimType = world.method_27983();
        if (dimType == class_1937.field_25179) {
            return darkOverworld;
        }
        if (dimType == class_1937.field_25180) {
            return darkNether;
        }
        if (dimType == class_1937.field_25181) {
            return darkEnd;
        }
        if (world.method_8597().comp_642()) {
            return darkDefault;
        }
        return darkSkyless;
    }

    private static float skyFactor(class_1937 world) {
        if (!blockLightOnly && Darkness.isDark(world)) {
            if (world.method_8597().comp_642()) {
                float angle = world.method_30274(0.0f);
                if (angle > 0.25f && angle < 0.75f) {
                    float oldWeight = Math.max(0.0f, Math.abs(angle - 0.5f) - 0.2f) * 20.0f;
                    float moon = ignoreMoonPhase ? 0.0f : world.method_30272();
                    return class_3532.method_16439((float)(oldWeight * oldWeight * oldWeight), (float)(moon * moon), (float)1.0f);
                }
                return 1.0f;
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public static int darken(int c, int blockIndex, int skyIndex) {
        float lTarget = LUMINANCE[blockIndex][skyIndex];
        float r = (float)(c & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c >> 16 & 0xFF) / 255.0f;
        float l = Darkness.luminance(r, g, b);
        float f = l > 0.0f ? Math.min(1.0f, lTarget / l) : 0.0f;
        return f == 1.0f ? c : 0xFF000000 | Math.round(f * r * 255.0f) | Math.round(f * g * 255.0f) << 8 | Math.round(f * b * 255.0f) << 16;
    }

    public static float luminance(float r, float g, float b) {
        return r * 0.2126f + g * 0.7152f + b * 0.0722f;
    }

    public static void updateLuminance(float tickDelta, class_310 client, class_757 worldRenderer, float prevFlicker) {
        class_638 world = client.field_1687;
        if (world != null) {
            if (!Darkness.isDark((class_1937)world) || client.field_1724.method_6059(class_1294.field_5925) || client.field_1724.method_6059(class_1294.field_5927) && client.field_1724.method_3140() > 0.0f || world.method_23789() > 0) {
                enabled = false;
                return;
            }
            enabled = true;
            float dimSkyFactor = Darkness.skyFactor((class_1937)world);
            float ambient = world.method_23783(1.0f);
            class_2874 dim = world.method_8597();
            boolean blockAmbient = !Darkness.isDark((class_1937)world);
            for (int skyIndex = 0; skyIndex < 16; ++skyIndex) {
                float skyFactor = 1.0f - (float)skyIndex / 15.0f;
                skyFactor = 1.0f - skyFactor * skyFactor * skyFactor * skyFactor;
                float min = (skyFactor *= dimSkyFactor) * 0.05f;
                float rawAmbient = ambient * skyFactor;
                float minAmbient = rawAmbient * (1.0f - min) + min;
                float skyBase = class_765.method_23284((class_2874)dim, (int)skyIndex) * minAmbient;
                min = 0.35f * skyFactor;
                float skyRed = skyBase * (rawAmbient * (1.0f - min) + min);
                float skyGreen = skyBase * (rawAmbient * (1.0f - min) + min);
                float skyBlue = skyBase;
                if (worldRenderer.method_3195(tickDelta) > 0.0f) {
                    float skyDarkness = worldRenderer.method_3195(tickDelta);
                    skyRed = skyRed * (1.0f - skyDarkness) + skyRed * 0.7f * skyDarkness;
                    skyGreen = skyGreen * (1.0f - skyDarkness) + skyGreen * 0.6f * skyDarkness;
                    skyBlue = skyBlue * (1.0f - skyDarkness) + skyBlue * 0.6f * skyDarkness;
                }
                for (int blockIndex = 0; blockIndex < 16; ++blockIndex) {
                    float blockFactor = 1.0f;
                    if (!blockAmbient) {
                        blockFactor = 1.0f - (float)blockIndex / 15.0f;
                        blockFactor = 1.0f - blockFactor * blockFactor * blockFactor * blockFactor;
                    }
                    float blockBase = blockFactor * class_765.method_23284((class_2874)dim, (int)blockIndex) * (prevFlicker * 0.1f + 1.5f);
                    min = 0.4f * blockFactor;
                    float blockGreen = blockBase * ((blockBase * (1.0f - min) + min) * (1.0f - min) + min);
                    float blockBlue = blockBase * (blockBase * blockBase * (1.0f - min) + min);
                    float red = skyRed + blockBase;
                    float green = skyGreen + blockGreen;
                    float blue = skyBlue + blockBlue;
                    float f = Math.max(skyFactor, blockFactor);
                    min = 0.03f * f;
                    red = red * (0.99f - min) + min;
                    green = green * (0.99f - min) + min;
                    blue = blue * (0.99f - min) + min;
                    if (world.method_27983() == class_1937.field_25181) {
                        red = skyFactor * 0.22f + blockBase * 0.75f;
                        green = skyFactor * 0.28f + blockGreen * 0.75f;
                        blue = skyFactor * 0.25f + blockBlue * 0.75f;
                    }
                    if (red > 1.0f) {
                        red = 1.0f;
                    }
                    if (green > 1.0f) {
                        green = 1.0f;
                    }
                    if (blue > 1.0f) {
                        blue = 1.0f;
                    }
                    float gamma = ((Double)client.field_1690.method_42473().method_41753()).floatValue() * f;
                    float invRed = 1.0f - red;
                    float invGreen = 1.0f - green;
                    float invBlue = 1.0f - blue;
                    invRed = 1.0f - invRed * invRed * invRed * invRed;
                    invGreen = 1.0f - invGreen * invGreen * invGreen * invGreen;
                    invBlue = 1.0f - invBlue * invBlue * invBlue * invBlue;
                    red = red * (1.0f - gamma) + invRed * gamma;
                    green = green * (1.0f - gamma) + invGreen * gamma;
                    blue = blue * (1.0f - gamma) + invBlue * gamma;
                    min = 0.03f * f;
                    red = red * (0.99f - min) + min;
                    green = green * (0.99f - min) + min;
                    blue = blue * (0.99f - min) + min;
                    if (red > 1.0f) {
                        red = 1.0f;
                    }
                    if (green > 1.0f) {
                        green = 1.0f;
                    }
                    if (blue > 1.0f) {
                        blue = 1.0f;
                    }
                    if (red < 0.0f) {
                        red = 0.0f;
                    }
                    if (green < 0.0f) {
                        green = 0.0f;
                    }
                    if (blue < 0.0f) {
                        blue = 0.0f;
                    }
                    Darkness.LUMINANCE[blockIndex][skyIndex] = Darkness.luminance(red, green, blue);
                }
            }
        }
    }

    static {
        File configFile = Darkness.getConfigFile();
        Properties properties = new Properties();
        if (configFile.exists()) {
            try (FileInputStream stream = new FileInputStream(configFile);){
                properties.load(stream);
            }
            catch (IOException e) {
                LOG.warn("[Darkness] Could not read property file '" + configFile.getAbsolutePath() + "'", (Throwable)e);
            }
        }
        ignoreMoonPhase = properties.computeIfAbsent("ignore_moon_phase", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false")).equals("true");
        blockLightOnly = properties.computeIfAbsent("only_affect_block_light", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false")).equals("true");
        darkOverworld = properties.computeIfAbsent("dark_overworld", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")).equals("true");
        darkDefault = properties.computeIfAbsent("dark_default", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")).equals("true");
        darkNether = properties.computeIfAbsent("dark_nether", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")).equals("true");
        darkEnd = properties.computeIfAbsent("dark_end", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")).equals("true");
        darkSkyless = properties.computeIfAbsent("dark_skyless", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")).equals("true");
        try {
            darkNetherFogConfigured = Double.parseDouble(properties.computeIfAbsent("dark_nether_fog", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0.5")).toString());
            darkNetherFogConfigured = class_3532.method_15350((double)darkNetherFogConfigured, (double)0.0, (double)1.0);
        }
        catch (Exception e) {
            darkNetherFogConfigured = 0.5;
            LOG.warn("[Darkness] Invalid configuration value for 'dark_nether_fog'. Using default value.");
        }
        try {
            darkEndFogConfigured = Double.parseDouble(properties.computeIfAbsent("dark_end_fog", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0.0")).toString());
            darkEndFogConfigured = class_3532.method_15350((double)darkEndFogConfigured, (double)0.0, (double)1.0);
        }
        catch (Exception e) {
            darkEndFogConfigured = 0.0;
            LOG.warn("[Darkness] Invalid configuration value for 'dark_end_fog'. Using default value.");
        }
        Darkness.computeConfigValues();
        Darkness.saveConfig();
        enabled = false;
        LUMINANCE = new float[16][16];
    }
}

