/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.newsclub.net.unix.AFDatagramChannel;
import org.newsclub.net.unix.AFSelector;
import org.newsclub.net.unix.AFServerSocketChannel;
import org.newsclub.net.unix.AFSocketChannel;
import org.newsclub.net.unix.AFSocketCore;

final class AFSelectionKey
extends SelectionKey {
    private static final int OP_INVALID = 128;
    private final AFSelector sel;
    private final AFSocketCore core;
    private int ops;
    private final SelectableChannel chann;
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private int opsReady;

    AFSelectionKey(AFSelector selector, AbstractSelectableChannel ch, int ops, Object att) {
        this.chann = ch;
        this.sel = selector;
        this.ops = ops;
        if (ch instanceof AFDatagramChannel) {
            this.core = ((AFDatagramChannel)ch).getAFCore();
        } else if (ch instanceof AFSocketChannel) {
            this.core = ((AFSocketChannel)ch).getAFCore();
        } else if (ch instanceof AFServerSocketChannel) {
            this.core = ((AFServerSocketChannel)ch).getAFCore();
        } else {
            throw new UnsupportedOperationException();
        }
        this.attach(att);
    }

    @Override
    public SelectableChannel channel() {
        return this.chann;
    }

    @Override
    public Selector selector() {
        return this.sel;
    }

    @Override
    public boolean isValid() {
        return !this.hasOpInvalid() && !this.cancelled.get() && this.chann.isOpen() && this.sel.isOpen();
    }

    boolean hasOpInvalid() {
        return (this.opsReady & 0x80) != 0;
    }

    @Override
    public void cancel() {
        this.sel.remove(this);
        this.cancelNoRemove();
    }

    void cancelNoRemove() {
        if (!this.cancelled.compareAndSet(false, true) || !this.chann.isOpen()) {
            return;
        }
        this.cancel1();
    }

    private void cancel1() {
    }

    @Override
    public int interestOps() {
        return this.ops;
    }

    @Override
    public SelectionKey interestOps(int interestOps) {
        this.ops = interestOps;
        return this;
    }

    @Override
    public int readyOps() {
        return this.opsReady & 0xFFFFFF7F;
    }

    AFSocketCore getAFCore() {
        return this.core;
    }

    void setOpsReady(int opsReady) {
        this.opsReady = opsReady;
    }

    public String toString() {
        return super.toString() + "[" + this.readyOps() + ";valid=" + this.isValid() + ";channel=" + this.channel() + "]";
    }
}

