/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.impl.PairConsumer;
import forge.com.gitlab.cdagaming.craftpresence.impl.TupleConsumer;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import net.minecraft.client.gui.screens.Screen;

public class DynamicEditorGui
extends ExtendedScreen {
    private final TupleConsumer<DynamicEditorGui, String, String> onAdjustEntry;
    private final TupleConsumer<DynamicEditorGui, String, String> onRemoveEntry;
    private final PairConsumer<String, DynamicEditorGui> onAdjustInit;
    private final PairConsumer<String, DynamicEditorGui> onNewInit;
    private final PairConsumer<String, DynamicEditorGui> onSpecificCallback;
    private final PairConsumer<String, DynamicEditorGui> onHoverPrimaryCallback;
    private final PairConsumer<String, DynamicEditorGui> onHoverSecondaryCallback;
    public String attributeName;
    public String primaryMessage;
    public String secondaryMessage;
    public String originalPrimaryMessage;
    public String originalSecondaryMessage;
    public String mainTitle;
    public String primaryText;
    public String secondaryText;
    public boolean isNewValue;
    public boolean isDefaultValue;
    public boolean willRenderSecondaryInput;
    public boolean overrideSecondaryRender = false;
    public int maxPrimaryLength = -1;
    public int maxSecondaryLength = -1;
    private ExtendedButtonControl proceedButton;
    private ExtendedTextControl primaryInput;
    private ExtendedTextControl secondaryInput;
    private String removeMessage;

    public DynamicEditorGui(Screen parentScreen, String attributeName, PairConsumer<String, DynamicEditorGui> onNewInit, PairConsumer<String, DynamicEditorGui> onAdjustInit, TupleConsumer<DynamicEditorGui, String, String> onAdjustEntry, TupleConsumer<DynamicEditorGui, String, String> onRemoveEntry, PairConsumer<String, DynamicEditorGui> onSpecificCallback, PairConsumer<String, DynamicEditorGui> onHoverPrimaryCallback, PairConsumer<String, DynamicEditorGui> onHoverSecondaryCallback) {
        super(parentScreen);
        this.attributeName = attributeName;
        this.isNewValue = StringUtils.isNullOrEmpty(attributeName);
        this.isDefaultValue = !StringUtils.isNullOrEmpty(attributeName) && "default".equals(attributeName);
        this.onNewInit = onNewInit;
        this.onAdjustInit = onAdjustInit;
        this.onAdjustEntry = onAdjustEntry;
        this.onRemoveEntry = onRemoveEntry;
        this.onSpecificCallback = onSpecificCallback;
        this.onHoverPrimaryCallback = onHoverPrimaryCallback;
        this.onHoverSecondaryCallback = onHoverSecondaryCallback;
    }

    public DynamicEditorGui(Screen parentScreen, String attributeName, PairConsumer<String, DynamicEditorGui> onNewInit, PairConsumer<String, DynamicEditorGui> onAdjustInit, TupleConsumer<DynamicEditorGui, String, String> onAdjustEntry, TupleConsumer<DynamicEditorGui, String, String> onRemoveEntry, PairConsumer<String, DynamicEditorGui> onSpecificCallback, PairConsumer<String, DynamicEditorGui> onHoverPrimaryCallback) {
        this(parentScreen, attributeName, onNewInit, onAdjustInit, onAdjustEntry, onRemoveEntry, onSpecificCallback, onHoverPrimaryCallback, (name, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.value.name", new Object[0])), (ExtendedScreen)((Object)screenInstance), true));
    }

    public DynamicEditorGui(Screen parentScreen, String attributeName, PairConsumer<String, DynamicEditorGui> onNewInit, PairConsumer<String, DynamicEditorGui> onAdjustInit, TupleConsumer<DynamicEditorGui, String, String> onAdjustEntry, TupleConsumer<DynamicEditorGui, String, String> onRemoveEntry, PairConsumer<String, DynamicEditorGui> onSpecificCallback) {
        this(parentScreen, attributeName, onNewInit, onAdjustInit, onAdjustEntry, onRemoveEntry, onSpecificCallback, (name, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.value.message", new Object[0])), (ExtendedScreen)((Object)screenInstance), true));
    }

    @Override
    public void initializeUi() {
        int controlIndex = 1;
        if (this.isNewValue) {
            this.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.editor.add.new", new Object[0]);
            if (this.onNewInit != null) {
                this.onNewInit.accept(this.attributeName, this);
            }
        } else if (this.onAdjustInit != null) {
            this.onAdjustInit.accept(this.attributeName, this);
        }
        boolean bl = this.willRenderSecondaryInput = this.isNewValue || this.overrideSecondaryRender;
        if (StringUtils.isNullOrEmpty(this.primaryText)) {
            this.primaryText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]);
        }
        if (StringUtils.isNullOrEmpty(this.secondaryText)) {
            this.secondaryText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.value.name", new Object[0]);
        }
        this.removeMessage = ModUtils.TRANSLATOR.translate("gui.config.message.remove", this.primaryText.replaceAll("[^a-zA-Z0-9]", ""));
        this.primaryInput = this.addControl(new ExtendedTextControl(this.getFontRenderer(), this.getScreenWidth() / 2 + 3, CraftPresence.GUIS.getButtonY(controlIndex++), 180, 20));
        if (this.maxPrimaryLength > 0) {
            this.primaryInput.setControlMaxLength(this.maxPrimaryLength);
        }
        if (!StringUtils.isNullOrEmpty(this.primaryMessage)) {
            this.primaryInput.setControlMessage(this.primaryMessage);
        }
        if (this.onSpecificCallback != null && !this.isNewValue) {
            this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, CraftPresence.GUIS.getButtonY(controlIndex++), 180, 20, "gui.config.message.button.icon.change", () -> this.onSpecificCallback.accept(this.attributeName, this), new String[0]));
        }
        if (this.willRenderSecondaryInput) {
            this.secondaryInput = this.addControl(new ExtendedTextControl(this.getFontRenderer(), this.getScreenWidth() / 2 + 3, CraftPresence.GUIS.getButtonY(controlIndex++), 180, 20));
            if (this.maxSecondaryLength > 0) {
                this.secondaryInput.setControlMaxLength(this.maxSecondaryLength);
            }
            if (!StringUtils.isNullOrEmpty(this.secondaryMessage)) {
                this.secondaryInput.setControlMessage(this.secondaryMessage);
            }
        }
        this.proceedButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 30, 180, 20, "gui.config.message.button.back", () -> {
            if (StringUtils.isNullOrEmpty(this.attributeName) && this.willRenderSecondaryInput && !StringUtils.isNullOrEmpty(this.secondaryInput.getControlMessage())) {
                this.attributeName = this.secondaryInput.getControlMessage();
            }
            if (this.isAdjusting() && this.onAdjustEntry != null) {
                this.onAdjustEntry.accept(this, this.willRenderSecondaryInput ? this.secondaryInput.getControlMessage() : this.attributeName, this.primaryInput.getControlMessage());
            }
            if (this.isRemoving() && this.onRemoveEntry != null) {
                this.onRemoveEntry.accept(this, this.willRenderSecondaryInput ? this.secondaryInput.getControlMessage() : this.attributeName, this.primaryInput.getControlMessage());
            }
            CraftPresence.GUIS.openScreen(this.parentScreen);
        }, () -> {
            if (!this.proceedButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])), this, true);
            }
        }, new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        this.renderString(this.mainTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(this.mainTitle) / 2.0f, 15.0f, 0xFFFFFF);
        this.renderString(this.primaryText, (float)this.getScreenWidth() / 2.0f - 130.0f, this.primaryInput.getControlPosY() + 5, 0xFFFFFF);
        if (this.willRenderSecondaryInput) {
            this.renderString(this.secondaryText, (float)this.getScreenWidth() / 2.0f - 130.0f, this.secondaryInput.getControlPosY() + 5, 0xFFFFFF);
        }
        if (!this.isNewValue && !this.isDefaultValue) {
            this.renderString(this.removeMessage, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(this.removeMessage) / 2.0f, this.getScreenHeight() - 45, 0xFFFFFF);
        }
        this.proceedButton.setControlMessage(this.isAdjusting() || this.isRemoving() ? "gui.config.message.button.continue" : "gui.config.message.button.back");
        this.proceedButton.setControlEnabled(this.isValidEntries());
    }

    @Override
    public void postRender() {
        boolean isHoveringOverSecondary;
        boolean isHoveringOverPrimary = CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 130.0f, this.primaryInput.getControlPosY() + 5, this.getStringWidth(this.primaryText), this.getFontHeight());
        boolean bl = isHoveringOverSecondary = this.willRenderSecondaryInput && CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 130.0f, this.secondaryInput.getControlPosY() + 5, this.getStringWidth(this.secondaryText), this.getFontHeight());
        if (isHoveringOverPrimary && this.onHoverPrimaryCallback != null) {
            this.onHoverPrimaryCallback.accept(this.attributeName, this);
        }
        if (isHoveringOverSecondary && this.onHoverSecondaryCallback != null) {
            this.onHoverSecondaryCallback.accept(this.attributeName, this);
        }
    }

    private boolean isAdjusting() {
        boolean areEitherEmpty;
        String primaryText = this.primaryInput != null ? this.primaryInput.getControlMessage() : "";
        boolean isPrimaryEmpty = StringUtils.isNullOrEmpty(primaryText);
        String secondaryText = this.secondaryInput != null ? this.secondaryInput.getControlMessage() : "";
        boolean isSecondaryEmpty = StringUtils.isNullOrEmpty(secondaryText);
        boolean bl = areEitherEmpty = isPrimaryEmpty || isSecondaryEmpty;
        if (this.willRenderSecondaryInput) {
            return !areEitherEmpty && (!primaryText.equals(this.primaryMessage) || !secondaryText.equals(this.secondaryMessage));
        }
        if (this.isDefaultValue) {
            return !isPrimaryEmpty && !primaryText.equals(this.primaryMessage);
        }
        return !primaryText.equals(this.primaryMessage);
    }

    private boolean isRemoving() {
        String primaryText = this.primaryInput != null ? this.primaryInput.getControlMessage() : "";
        boolean isPrimaryEmpty = StringUtils.isNullOrEmpty(primaryText);
        if (!this.isDefaultValue && !this.isNewValue) {
            return isPrimaryEmpty || primaryText.equalsIgnoreCase(this.originalPrimaryMessage) && !this.primaryMessage.equals(this.originalPrimaryMessage);
        }
        return false;
    }

    private boolean isValidEntries() {
        String primaryText = this.primaryInput != null ? this.primaryInput.getControlMessage() : "";
        boolean isPrimaryEmpty = StringUtils.isNullOrEmpty(primaryText);
        if (this.isDefaultValue) {
            return !isPrimaryEmpty;
        }
        return true;
    }
}

