/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ScrollableListControl
extends ObjectSelectionList<StringEntry> {
    public String currentValue;
    public List<String> itemList;
    public RenderType renderType;
    public boolean visible = true;

    public ScrollableListControl(Minecraft mc, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue) {
        this(mc, width, height, topIn, bottomIn, slotHeightIn, itemList, currentValue, RenderType.None);
    }

    public ScrollableListControl(Minecraft mc, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue, RenderType renderType) {
        super(mc, width, height, topIn, bottomIn, slotHeightIn);
        this.itemList = itemList;
        this.currentValue = currentValue;
        this.renderType = renderType;
        if (renderType == RenderType.ItemData) {
            CraftPresence.TILE_ENTITIES.getEntities();
        }
        this.updateEntries();
    }

    public void setSelected(StringEntry entry) {
        super.m_6987_((AbstractSelectionList.Entry)entry);
        if (entry != null) {
            this.currentValue = entry.displayName;
        }
    }

    protected int m_5773_() {
        return this.itemList.size();
    }

    protected void m_7733_(@Nonnull PoseStack matrixStack) {
        if (this.m_5773_() != this.m_6702_().size()) {
            this.m_93516_();
            this.updateEntries();
        }
    }

    public void updateEntries() {
        for (String item : this.itemList) {
            StringEntry dataEntry = new StringEntry(item, this.renderType);
            this.m_7085_((AbstractSelectionList.Entry)dataEntry);
            if (!item.equals(this.currentValue)) continue;
            this.setSelected(dataEntry);
        }
        if (this.m_93511_() != null) {
            this.m_93494_((AbstractSelectionList.Entry)((StringEntry)this.m_93511_()));
        }
    }

    public Font getFontRenderer() {
        return this.f_93386_.f_91062_ != null ? this.f_93386_.f_91062_ : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        Objects.requireNonNull(this.getFontRenderer());
        return 9;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public static enum RenderType {
        DiscordAsset,
        CustomDiscordAsset,
        ServerData,
        EntityData,
        ItemData,
        None;

    }

    public class StringEntry
    extends ObjectSelectionList.Entry<StringEntry> {
        private final RenderType renderType;
        private String displayName;

        public StringEntry(String name) {
            this(name, RenderType.None);
        }

        public StringEntry(String name, RenderType renderType) {
            this.displayName = name;
            this.renderType = renderType;
        }

        public void m_6311_(@Nonnull PoseStack matrices, int index, int yPos, int xPos, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int xOffset = xPos;
            if (!CraftPresence.CONFIG.stripExtraGuiElements && (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.CustomDiscordAsset || this.renderType == RenderType.ServerData && CraftPresence.SERVER.enabled || this.renderType == RenderType.EntityData && CraftPresence.ENTITIES.enabled || this.renderType == RenderType.ItemData && CraftPresence.TILE_ENTITIES.enabled)) {
                ResourceLocation texture = new ResourceLocation("");
                if (this.renderType == RenderType.ServerData) {
                    ServerData data = CraftPresence.SERVER.getDataFromName(this.displayName);
                    if (data != null) {
                        String assetUrl = "data:image/unknown;base64," + data.m_105388_();
                        texture = ImageUtils.getTextureFromUrl(this.displayName, new Pair<ImageUtils.InputType, Object>(ImageUtils.InputType.ByteStream, assetUrl));
                    }
                } else if (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.CustomDiscordAsset) {
                    String assetUrl = DiscordAssetUtils.getUrl(this.renderType == RenderType.CustomDiscordAsset ? DiscordAssetUtils.CUSTOM_ASSET_LIST : DiscordAssetUtils.ASSET_LIST, this.displayName);
                    texture = ImageUtils.getTextureFromUrl(this.displayName, assetUrl);
                } else if (this.renderType == RenderType.EntityData) {
                    if (StringUtils.isValidUuid(this.displayName)) {
                        this.displayName = StringUtils.getFromUuid(this.displayName);
                        texture = ImageUtils.getTextureFromUrl(this.displayName, String.format(CraftPresence.CONFIG.playerSkinEndpoint, this.displayName));
                    }
                } else if (this.renderType == RenderType.ItemData) {
                    texture = CraftPresence.TILE_ENTITIES.TILE_ENTITY_RESOURCES.getOrDefault(this.displayName, texture);
                }
                if (!ImageUtils.isTextureNull(texture)) {
                    CraftPresence.GUIS.drawTextureRect(0.0, xOffset, (double)yPos + 4.5, 32.0f, 32.0f, 0.0f, texture);
                }
                xOffset += 35;
            }
            ScrollableListControl.this.getFontRenderer().m_92750_(matrices, this.displayName, (float)xOffset, (float)yPos + ((float)entryHeight / 2.0f - (float)ScrollableListControl.this.getFontHeight() / 2.0f), 0xFFFFFF);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.onPressed();
                return true;
            }
            return false;
        }

        private void onPressed() {
            ScrollableListControl.this.setSelected(this);
        }

        public Component m_142172_() {
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.displayName});
        }
    }
}

