/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.impl.discord.ArgumentType;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityUtils {
    private final List<String> ENTITY_CLASSES = Lists.newArrayList();
    private final List<Pair<String, String>> entityTargetArgs = Lists.newArrayList();
    private final List<Pair<String, String>> entityRidingArgs = Lists.newArrayList();
    public boolean isInUse = false;
    public boolean enabled = false;
    public String CURRENT_TARGET_NAME;
    public String CURRENT_RIDING_NAME;
    public List<String> ENTITY_NAMES = Lists.newArrayList();
    public List<String> CURRENT_TARGET_TAGS = Lists.newArrayList();
    public List<String> CURRENT_RIDING_TAGS = Lists.newArrayList();
    public Entity CURRENT_TARGET;
    public Entity CURRENT_RIDING;
    private CompoundTag CURRENT_TARGET_TAG;
    private CompoundTag CURRENT_RIDING_TAG;

    private void emptyData() {
        this.ENTITY_NAMES.clear();
        this.ENTITY_CLASSES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_TARGET = null;
        this.CURRENT_RIDING = null;
        this.CURRENT_TARGET_NAME = null;
        this.CURRENT_RIDING_NAME = null;
        this.CURRENT_TARGET_TAG = null;
        this.CURRENT_RIDING_TAG = null;
        this.CURRENT_TARGET_TAGS.clear();
        this.CURRENT_RIDING_TAGS.clear();
        this.entityTargetArgs.clear();
        this.entityRidingArgs.clear();
        this.isInUse = false;
        CraftPresence.CLIENT.removeArgumentsMatching(ArgumentType.Text, "&TARGETENTITY:", "&RIDINGENTITY:");
        CraftPresence.CLIENT.initArgument(ArgumentType.Text, "&TARGETENTITY&", "&RIDINGENTITY&");
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.enablePerEntity : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.ENTITY_NAMES.isEmpty() || this.ENTITY_CLASSES.isEmpty());
        if (needsUpdate) {
            this.getEntities();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateEntityData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else if (this.isInUse) {
            this.emptyData();
        }
    }

    private void updateEntityData() {
        boolean hasRidingChanged;
        String NEW_CURRENT_RIDING_NAME;
        String NEW_CURRENT_TARGET_NAME;
        HitResult NEW_HIT_RESULT = CraftPresence.instance.f_91077_;
        Entity NEW_CURRENT_TARGET = null;
        if (NEW_HIT_RESULT != null) {
            switch (NEW_HIT_RESULT.m_6662_()) {
                case ENTITY: {
                    EntityHitResult entityHitResult = (EntityHitResult)NEW_HIT_RESULT;
                    NEW_CURRENT_TARGET = entityHitResult.m_82443_();
                }
            }
        }
        Entity NEW_CURRENT_RIDING = CraftPresence.player.m_20202_();
        if (NEW_CURRENT_TARGET instanceof Player) {
            Player NEW_CURRENT_PLAYER_TARGET = (Player)NEW_CURRENT_TARGET;
            NEW_CURRENT_TARGET_NAME = StringUtils.stripColors(NEW_CURRENT_PLAYER_TARGET.m_36316_().getId().toString());
        } else {
            String string = NEW_CURRENT_TARGET_NAME = NEW_CURRENT_TARGET != null ? StringUtils.stripColors(NEW_CURRENT_TARGET.m_5446_().getString()) : "";
        }
        if (NEW_CURRENT_RIDING instanceof Player) {
            Player NEW_CURRENT_PLAYER_RIDING = (Player)NEW_CURRENT_RIDING;
            NEW_CURRENT_RIDING_NAME = StringUtils.stripColors(NEW_CURRENT_PLAYER_RIDING.m_36316_().getId().toString());
        } else {
            NEW_CURRENT_RIDING_NAME = NEW_CURRENT_RIDING != null ? StringUtils.stripColors(NEW_CURRENT_RIDING.m_5446_().getString()) : "";
        }
        boolean hasTargetChanged = NEW_CURRENT_TARGET != null && !NEW_CURRENT_TARGET.equals((Object)this.CURRENT_TARGET) || !NEW_CURRENT_TARGET_NAME.equals(this.CURRENT_TARGET_NAME) || NEW_CURRENT_TARGET == null && this.CURRENT_TARGET != null;
        boolean bl = hasRidingChanged = NEW_CURRENT_RIDING != null && !NEW_CURRENT_RIDING.equals((Object)this.CURRENT_RIDING) || !NEW_CURRENT_RIDING_NAME.equals(this.CURRENT_RIDING_NAME) || NEW_CURRENT_RIDING == null && this.CURRENT_RIDING != null;
        if (hasTargetChanged) {
            ArrayList NEW_CURRENT_TARGET_TAGS;
            this.CURRENT_TARGET = NEW_CURRENT_TARGET;
            this.CURRENT_TARGET_TAG = this.CURRENT_TARGET != null ? this.CURRENT_TARGET.m_20240_(new CompoundTag()) : null;
            ArrayList arrayList = NEW_CURRENT_TARGET_TAGS = this.CURRENT_TARGET_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_TARGET_TAG.m_128431_()) : Lists.newArrayList();
            if (!NEW_CURRENT_TARGET_TAGS.equals(this.CURRENT_TARGET_TAGS)) {
                this.CURRENT_TARGET_TAGS = NEW_CURRENT_TARGET_TAGS;
            }
            this.CURRENT_TARGET_NAME = NEW_CURRENT_TARGET_NAME;
        }
        if (hasRidingChanged) {
            ArrayList NEW_CURRENT_RIDING_TAGS;
            this.CURRENT_RIDING = NEW_CURRENT_RIDING;
            this.CURRENT_RIDING_TAG = this.CURRENT_RIDING != null ? this.CURRENT_RIDING.m_20240_(new CompoundTag()) : null;
            ArrayList arrayList = NEW_CURRENT_RIDING_TAGS = this.CURRENT_RIDING_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_RIDING_TAG.m_128431_()) : Lists.newArrayList();
            if (!NEW_CURRENT_RIDING_TAGS.equals(this.CURRENT_RIDING_TAGS)) {
                this.CURRENT_RIDING_TAGS = NEW_CURRENT_RIDING_TAGS;
            }
            this.CURRENT_RIDING_NAME = NEW_CURRENT_RIDING_NAME;
        }
        if (hasTargetChanged || hasRidingChanged) {
            this.updateEntityPresence();
        }
    }

    public void updateEntityPresence() {
        String defaultEntityTargetMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityTargetMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String defaultEntityRidingMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityRidingMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String targetEntityMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityTargetMessages, this.CURRENT_TARGET_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultEntityTargetMessage);
        String ridingEntityMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityRidingMessages, this.CURRENT_RIDING_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultEntityRidingMessage);
        this.entityTargetArgs.clear();
        this.entityRidingArgs.clear();
        this.entityTargetArgs.add(new Pair<String, String>("&ENTITY&", this.getEntityName(this.CURRENT_TARGET, this.CURRENT_TARGET_NAME)));
        this.entityRidingArgs.add(new Pair<String, String>("&ENTITY&", this.getEntityName(this.CURRENT_RIDING, this.CURRENT_RIDING_NAME)));
        if (!this.CURRENT_TARGET_TAGS.isEmpty()) {
            for (String string : this.CURRENT_TARGET_TAGS) {
                this.entityTargetArgs.add(new Pair<CallSite, String>((CallSite)((Object)("&" + string + "&")), this.CURRENT_TARGET_TAG.m_128423_(string).toString()));
            }
        }
        if (!this.CURRENT_RIDING_TAGS.isEmpty()) {
            for (String string : this.CURRENT_RIDING_TAGS) {
                this.entityRidingArgs.add(new Pair<CallSite, String>((CallSite)((Object)("&" + string + "&")), this.CURRENT_RIDING_TAG.m_128423_(string).toString()));
            }
        }
        for (Pair pair : this.entityTargetArgs) {
            CraftPresence.CLIENT.syncArgument("&TARGETENTITY:" + ((String)pair.getFirst()).substring(1), (String)pair.getSecond(), ArgumentType.Text);
        }
        for (Pair pair : this.entityRidingArgs) {
            CraftPresence.CLIENT.syncArgument("&RIDINGENTITY:" + ((String)pair.getFirst()).substring(1), (String)pair.getSecond(), ArgumentType.Text);
        }
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            StringUtils.addEntriesNotPresent(this.entityTargetArgs, CraftPresence.CLIENT.generalArgs);
            StringUtils.addEntriesNotPresent(this.entityRidingArgs, CraftPresence.CLIENT.generalArgs);
        }
        String CURRENT_TARGET_MESSAGE = StringUtils.sequentialReplaceAnyCase(targetEntityMessage, this.entityTargetArgs);
        String string = StringUtils.sequentialReplaceAnyCase(ridingEntityMessage, this.entityRidingArgs);
        if (this.CURRENT_TARGET != null) {
            CraftPresence.CLIENT.syncArgument("&TARGETENTITY&", CURRENT_TARGET_MESSAGE, ArgumentType.Text);
        } else {
            CraftPresence.CLIENT.removeArgumentsMatching(ArgumentType.Text, "&TARGETENTITY:");
            CraftPresence.CLIENT.initArgument(ArgumentType.Text, "&TARGETENTITY&");
        }
        if (this.CURRENT_RIDING != null) {
            CraftPresence.CLIENT.syncArgument("&RIDINGENTITY&", string, ArgumentType.Text);
        } else {
            CraftPresence.CLIENT.removeArgumentsMatching(ArgumentType.Text, "&RIDINGENTITY:");
            CraftPresence.CLIENT.initArgument(ArgumentType.Text, "&RIDINGENTITY&");
        }
    }

    public String generateArgumentMessage(String argumentFormat, String subArgumentFormat, ArgumentType ... types) {
        types = types != null && types.length > 0 ? types : ArgumentType.values();
        HashMap argumentData = Maps.newHashMap();
        for (ArgumentType type : types) {
            ArrayList queuedEntries = Lists.newArrayList();
            if (type == ArgumentType.Text) {
                queuedEntries.add(subArgumentFormat + "ENTITY&");
            }
            argumentData.put(type, queuedEntries);
        }
        return CraftPresence.CLIENT.generateArgumentMessage(argumentFormat, subArgumentFormat, argumentData);
    }

    public String getEntityName(Entity entity, String original) {
        return StringUtils.isValidUuid(original) ? entity.m_7755_().getString() : original;
    }

    public List<String> getListFromName(String name) {
        String string = name = !StringUtils.isNullOrEmpty(name) ? name : "";
        return name.equalsIgnoreCase(this.CURRENT_TARGET_NAME) ? this.CURRENT_TARGET_TAGS : (name.equalsIgnoreCase(this.CURRENT_RIDING_NAME) ? this.CURRENT_RIDING_TAGS : Lists.newArrayList());
    }

    public String generatePlaceholderString(String name, boolean addExtraData, List<String> tags) {
        StringBuilder finalString = new StringBuilder(addExtraData ? "" : "\n{");
        if (!tags.isEmpty()) {
            for (int i = 0; i < tags.size(); ++i) {
                String tagName = tags.get(i);
                finalString.append(addExtraData ? "\n - " : "").append("&").append(tagName).append("&");
                if (addExtraData) {
                    String tagValue;
                    String string = tags.equals(this.CURRENT_TARGET_TAGS) ? this.CURRENT_TARGET_TAG.m_128423_(tagName).toString() : (tagValue = tags.equals(this.CURRENT_RIDING_TAGS) ? this.CURRENT_RIDING_TAG.m_128423_(tagName).toString() : null);
                    if (StringUtils.isNullOrEmpty(tagValue)) continue;
                    finalString.append(String.format(" (%s \"%s\")", ModUtils.TRANSLATOR.translate("gui.config.message.editor.preview", new Object[0]), tagValue.length() >= 128 ? "<...>" : tagValue));
                    continue;
                }
                if (i >= tags.size() - 1) continue;
                finalString.append(",");
                if (i % 5 != 4) continue;
                finalString.append("\n");
            }
        }
        if (!addExtraData) {
            finalString.append("}");
        }
        return (!StringUtils.isNullOrEmpty(name) ? name : "None") + " " + (!StringUtils.isNullOrEmpty(finalString.toString()) && !finalString.toString().equals("\n{}") ? finalString.toString() : "\\n - N/A");
    }

    public void getEntities() {
        String[] part;
        ArrayList defaultEntityTypes = Lists.newArrayList((Iterator)BuiltInRegistries.f_256780_.iterator());
        if (!defaultEntityTypes.isEmpty()) {
            for (EntityType entityLocation : defaultEntityTypes) {
                if (entityLocation == null) continue;
                String entityName = entityLocation.m_20676_().getString();
                Class<?> entityClass = entityLocation.getClass();
                if (!this.ENTITY_NAMES.contains(entityName)) {
                    this.ENTITY_NAMES.add(entityName);
                }
                if (this.ENTITY_CLASSES.contains(entityClass.getName())) continue;
                this.ENTITY_CLASSES.add(entityClass.getName());
            }
        }
        if (CraftPresence.SERVER.enabled) {
            for (PlayerInfo playerInfo : CraftPresence.SERVER.currentPlayerList) {
                String uuidString = playerInfo.m_105312_().getId().toString();
                if (StringUtils.isNullOrEmpty(uuidString) || this.ENTITY_NAMES.contains(uuidString)) continue;
                this.ENTITY_NAMES.add(uuidString);
            }
        }
        for (String entityTargetMessage : CraftPresence.CONFIG.entityTargetMessages) {
            if (StringUtils.isNullOrEmpty(entityTargetMessage) || StringUtils.isNullOrEmpty((part = entityTargetMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.ENTITY_NAMES.contains(part[0])) continue;
            this.ENTITY_NAMES.add(part[0]);
        }
        for (String entityRidingMessage : CraftPresence.CONFIG.entityRidingMessages) {
            if (StringUtils.isNullOrEmpty(entityRidingMessage) || StringUtils.isNullOrEmpty((part = entityRidingMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.ENTITY_NAMES.contains(part[0])) continue;
            this.ENTITY_NAMES.add(part[0]);
        }
        this.verifyEntities();
    }

    private void verifyEntities() {
    }
}

