/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils;

import com.google.common.collect.Lists;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.impl.Predicate;
import forge.com.gitlab.cdagaming.craftpresence.impl.Tuple;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.ArrayUtils;

public class StringUtils {
    public static final String UNKNOWN_BASE64_ID = "data:image/unknown;base64";
    private static final char COLOR_CHAR = '\u00a7';
    public static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static final Pattern BASE64_PATTERN = Pattern.compile("data:(?<type>.+?);base64,(?<data>.+)");
    private static final Pattern UUID_PATTERN = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");
    private static final Pattern BRACKET_PATTERN = Pattern.compile("\\([^0-9]*\\d+[^0-9]*\\)");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(.*?)\\s(.*?)");
    private static final Pattern ALPHANUMERIC_PATTERN = Pattern.compile(".*[a-zA-Z0-9].*");

    public static Color getColorFromHex(String hexColor) {
        try {
            if (hexColor.length() == 7 && !StringUtils.isNullOrEmpty(hexColor.substring(1))) {
                int r = Integer.valueOf(hexColor.substring(1, 3), 16);
                int g = Integer.valueOf(hexColor.substring(3, 5), 16);
                int b = Integer.valueOf(hexColor.substring(5, 7), 16);
                return new Color(r, g, b);
            }
            if (hexColor.length() == 6 && !hexColor.startsWith("#")) {
                int r = Integer.valueOf(hexColor.substring(0, 2), 16);
                int g = Integer.valueOf(hexColor.substring(2, 4), 16);
                int b = Integer.valueOf(hexColor.substring(4, 6), 16);
                return new Color(r, g, b);
            }
            return Color.white;
        }
        catch (Exception ex) {
            return Color.white;
        }
    }

    public static String getConvertedString(String original, String encoding, boolean decode) {
        try {
            if (decode) {
                return new String(original.getBytes(), encoding).replaceAll("\\s+", " ");
            }
            return new String(original.getBytes(encoding)).replaceAll("\\s+", " ");
        }
        catch (Exception ex) {
            return original;
        }
    }

    public static double roundDouble(double value, int places) {
        if (places >= 0) {
            double mod = 1.0;
            for (int i = 0; i < places; ++i) {
                mod /= 10.0;
            }
            return value + mod * 0.5 - (value + mod * 0.5) % mod;
        }
        return value;
    }

    public static String getHexFromColor(Color color) {
        return "0x" + StringUtils.toSafeHexValue(color.getAlpha()) + StringUtils.toSafeHexValue(color.getRed()) + StringUtils.toSafeHexValue(color.getGreen()) + StringUtils.toSafeHexValue(color.getBlue());
    }

    private static String toSafeHexValue(int number) {
        StringBuilder builder = new StringBuilder(Integer.toHexString(number & 0xFF));
        while (builder.length() < 2) {
            builder.append("0");
        }
        return builder.toString().toUpperCase();
    }

    public static Pair<String, List<String>> getMatches(String regexValue, Object original) {
        return original != null ? StringUtils.getMatches(regexValue, original.toString()) : new Pair<String, List<String>>("", Lists.newArrayList());
    }

    public static Pair<String, List<String>> getMatches(String regexValue, String original) {
        ArrayList matches = Lists.newArrayList();
        if (!StringUtils.isNullOrEmpty(original)) {
            Pattern pattern = Pattern.compile(regexValue);
            Matcher m = pattern.matcher(original);
            while (m.find()) {
                matches.add(m.group());
            }
        }
        return new Pair<String, List<String>>(original, matches);
    }

    public static String removeMatches(Pair<String, List<String>> matchData, List<Pair<String, String>> parsedMatchData, int maxMatches) {
        String finalString = "";
        if (matchData != null) {
            finalString = matchData.getFirst();
            List<String> matchList = matchData.getSecond();
            if (!matchList.isEmpty()) {
                int foundMatches = 0;
                for (String match : matchList) {
                    boolean isValidScan = foundMatches >= maxMatches;
                    boolean alreadyRemoved = false;
                    if (parsedMatchData != null && !parsedMatchData.isEmpty()) {
                        for (Pair<String, String> parsedArgument : parsedMatchData) {
                            if (!parsedArgument.getFirst().equalsIgnoreCase(match) || !StringUtils.isNullOrEmpty(parsedArgument.getSecond())) continue;
                            finalString = finalString.replaceFirst(match, "");
                            alreadyRemoved = true;
                            break;
                        }
                    }
                    if (alreadyRemoved) continue;
                    if (isValidScan) {
                        finalString = finalString.replaceFirst(match, "");
                    }
                    ++foundMatches;
                }
            }
        }
        return finalString;
    }

    public static String replaceAnyCase(String source, String targetToReplace, String replaceWith) {
        return StringUtils.replaceAnyCase(source, targetToReplace, replaceWith, true);
    }

    public static String replaceAnyCase(String source, String targetToReplace, String replaceWith, boolean allowMinified) {
        if (!StringUtils.isNullOrEmpty(source)) {
            String finalString = Pattern.compile(targetToReplace, 82).matcher(source).replaceAll(Matcher.quoteReplacement(replaceWith));
            if (allowMinified) {
                Object minifiedTarget = StringUtils.minifyString(targetToReplace, 4);
                if (!((String)minifiedTarget).endsWith("&")) {
                    minifiedTarget = (String)minifiedTarget + "&";
                }
                finalString = Pattern.compile((String)minifiedTarget, 82).matcher(finalString).replaceAll(Matcher.quoteReplacement(replaceWith));
            }
            return finalString;
        }
        return "";
    }

    @SafeVarargs
    public static String sequentialReplaceAnyCase(String source, List<Pair<String, String>> ... replaceArgs) {
        return StringUtils.sequentialReplaceAnyCase(source, true, replaceArgs);
    }

    @SafeVarargs
    public static String sequentialReplaceAnyCase(String source, boolean allowMinified, List<Pair<String, String>> ... replaceArgs) {
        if (!StringUtils.isNullOrEmpty(source)) {
            String finalResult = source;
            for (List<Pair<String, String>> replaceData : replaceArgs) {
                if (replaceData.isEmpty()) continue;
                for (Pair<String, String> replacementData : replaceData) {
                    finalResult = StringUtils.replaceAnyCase(finalResult, replacementData.getFirst(), replacementData.getSecond(), allowMinified);
                }
            }
            return finalResult;
        }
        return "";
    }

    public static String minifyString(String source, int length) {
        if (!StringUtils.isNullOrEmpty(source)) {
            return length >= 0 ? source.substring(0, length) : source;
        }
        return "";
    }

    public static boolean isNullOrEmpty(String entry, boolean allowWhitespace) {
        if (entry != null) {
            entry = allowWhitespace ? entry : entry.trim();
        }
        return entry == null || entry.isEmpty() || entry.equalsIgnoreCase("null");
    }

    public static boolean isNullOrEmpty(String entry) {
        return StringUtils.isNullOrEmpty(entry, false);
    }

    public static boolean isValidBoolean(Object entry) {
        return entry != null && StringUtils.isValidBoolean(entry.toString());
    }

    public static boolean isValidBoolean(String entry) {
        return !StringUtils.isNullOrEmpty(entry) && (entry.equalsIgnoreCase("true") || entry.equalsIgnoreCase("false"));
    }

    public static boolean isValidColorCode(String entry) {
        return !StringUtils.isNullOrEmpty(entry) && (entry.startsWith("#") || entry.length() == 6 || entry.startsWith("0x") || StringUtils.getValidInteger(entry).getFirst() != false);
    }

    public static Pair<Boolean, Integer> getValidInteger(Object entry) {
        return entry != null ? StringUtils.getValidInteger(entry.toString()) : new Pair<Boolean, Integer>(false, 0);
    }

    public static Pair<Boolean, Integer> getValidInteger(String entry) {
        Pair<Boolean, Integer> finalSet = new Pair<Boolean, Integer>();
        if (!StringUtils.isNullOrEmpty(entry)) {
            try {
                finalSet.setSecond(Integer.parseInt(entry));
                finalSet.setFirst(true);
            }
            catch (Exception ex) {
                finalSet.setFirst(false);
            }
        } else {
            finalSet.setFirst(false);
        }
        return finalSet;
    }

    public static Pair<Boolean, Long> getValidLong(String entry) {
        Pair<Boolean, Long> finalSet = new Pair<Boolean, Long>();
        if (!StringUtils.isNullOrEmpty(entry)) {
            try {
                finalSet.setSecond(Long.parseLong(entry));
                finalSet.setFirst(true);
            }
            catch (Exception ex) {
                finalSet.setFirst(false);
            }
        } else {
            finalSet.setFirst(false);
        }
        return finalSet;
    }

    public static String formatAddress(String input, boolean returnPort) {
        if (!StringUtils.isNullOrEmpty(input)) {
            String[] formatted = input.split(":", 2);
            return !returnPort ? (StringUtils.elementExists(formatted, 0) ? formatted[0].trim() : "127.0.0.1") : (StringUtils.elementExists(formatted, 1) ? formatted[1].trim() : "25565");
        }
        return !returnPort ? "127.0.0.1" : "25565";
    }

    public static boolean containsWhitespace(String original) {
        return StringUtils.isNullOrEmpty(original) || WHITESPACE_PATTERN.matcher(original).find();
    }

    public static boolean containsAlphaNumeric(String original) {
        return !StringUtils.isNullOrEmpty(original) && ALPHANUMERIC_PATTERN.matcher(original).find();
    }

    public static String formatAsIcon(String original) {
        String formattedKey = original;
        if (StringUtils.isNullOrEmpty(formattedKey)) {
            return formattedKey;
        }
        if (StringUtils.containsWhitespace(formattedKey)) {
            formattedKey = formattedKey.replaceAll("\\s+", "");
        }
        if (formattedKey.contains("'")) {
            formattedKey = formattedKey.replaceAll("'", "");
        }
        if (formattedKey.contains(".")) {
            formattedKey = formattedKey.replaceAll("\\.", "_");
        }
        if (formattedKey.contains("(")) {
            formattedKey = formattedKey.replaceAll("\\(", "_");
        }
        if (formattedKey.contains(")")) {
            formattedKey = formattedKey.replaceAll("\\)", "_");
        }
        if (BRACKET_PATTERN.matcher(formattedKey).find()) {
            formattedKey = BRACKET_PATTERN.matcher(formattedKey).replaceAll("");
        }
        if (STRIP_COLOR_PATTERN.matcher(formattedKey).find()) {
            formattedKey = STRIP_COLOR_PATTERN.matcher(formattedKey).replaceAll("");
        }
        return formattedKey.toLowerCase().trim();
    }

    public static Tuple<Boolean, String, String> isBase64(String original) {
        String formattedKey = original;
        String imageIdentifier = "";
        Tuple<Boolean, String, String> finalData = new Tuple<Boolean, String, String>(false, imageIdentifier, formattedKey);
        if (!StringUtils.isNullOrEmpty(formattedKey)) {
            if (formattedKey.contains(",")) {
                String[] splitData = formattedKey.split(",", 2);
                imageIdentifier = splitData[0];
                formattedKey = splitData[1];
            }
            finalData.setFirst(BASE64_PATTERN.matcher(imageIdentifier + "," + formattedKey).find());
            finalData.setSecond(imageIdentifier);
            finalData.setThird(formattedKey);
        }
        return finalData;
    }

    public static boolean isValidUuid(String input) {
        return !StringUtils.isNullOrEmpty(input) && UUID_PATTERN.matcher(input).find();
    }

    public static String getFromUuid(String input, boolean trimmed) {
        if (!StringUtils.isValidUuid(input)) {
            return input;
        }
        if (trimmed) {
            return input.replace("-", "");
        }
        return UUID_PATTERN.matcher(input).replaceFirst("$1-$2-$3-$4-$5");
    }

    public static String getFromUuid(String input) {
        return StringUtils.getFromUuid(input, false);
    }

    public static String getFromUuid(UUID input) {
        return StringUtils.getFromUuid(input.toString());
    }

    public static UUID getAsUuid(String input) {
        return UUID.fromString(StringUtils.getFromUuid(input, false));
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, List<T> newList) {
        for (T entry : newList) {
            if (original.contains(entry)) continue;
            original.add(entry);
        }
        return original;
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, Predicate<? super T> filter, List<T> newList) {
        newList = Lists.newArrayList(StringUtils.filter(newList, filter));
        return StringUtils.addEntriesNotPresent(original, newList);
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, Set<T> newList) {
        return StringUtils.addEntriesNotPresent(original, Lists.newArrayList(newList));
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, Predicate<? super T> filter, Set<T> newList) {
        newList = new HashSet<T>(StringUtils.filter(newList, filter));
        return StringUtils.addEntriesNotPresent(original, newList);
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, T[] newList) {
        return StringUtils.addEntriesNotPresent(original, Arrays.asList(newList));
    }

    public static String[] adjustArraySize(String[] theArray, int adjustBy) {
        int currentSize = theArray.length;
        int newSize = currentSize + adjustBy;
        String[] newArray = new String[newSize];
        System.arraycopy(theArray, 0, newArray, 0, theArray.length);
        return newArray;
    }

    public static String[] addToArray(String[] array, int index, String message) {
        if (array.length <= index) {
            int extendNum = index - array.length;
            String[] newArray = StringUtils.adjustArraySize(array, extendNum + 1);
            newArray[index] = message;
            return newArray;
        }
        array[index] = message;
        return array;
    }

    public static String[] removeFromArray(String[] originalArray, String searchTerm, int searchIndex, String splitCharacter) {
        String[] resultArray = originalArray;
        if (originalArray.length > 0) {
            for (int indexNumber = 0; indexNumber < originalArray.length; ++indexNumber) {
                String part = originalArray[indexNumber];
                String[] splitPart = part.split(splitCharacter);
                if (StringUtils.isNullOrEmpty(splitPart[searchIndex]) || !splitPart[searchIndex].equalsIgnoreCase(searchTerm)) continue;
                resultArray = (String[])ArrayUtils.remove((Object[])originalArray, (int)indexNumber);
                break;
            }
        }
        return resultArray;
    }

    public static String getConfigPart(String[] original, String searchTerm, int searchIndex, int resultIndex, String splitCharacter, String alternativeMessage) {
        String formattedKey = "";
        boolean matched = false;
        for (String part : original) {
            String[] splitPart = part.split(splitCharacter);
            if (!splitPart[searchIndex].equalsIgnoreCase(searchTerm) || !StringUtils.elementExists(splitPart, resultIndex)) continue;
            formattedKey = splitPart[resultIndex];
            matched = true;
            break;
        }
        return !matched && !StringUtils.isNullOrEmpty(alternativeMessage) ? alternativeMessage : formattedKey;
    }

    public static String[] setConfigPart(String[] original, String searchTerm, int searchIndex, int resultIndex, String splitCharacter, String newMessage) {
        int indexNumber = -1;
        boolean replacing = false;
        Object[] formatted = original;
        if (!StringUtils.isNullOrEmpty(Arrays.toString(formatted))) {
            for (Object part : formatted) {
                ++indexNumber;
                String[] splitPart = ((String)part).split(splitCharacter);
                if (!splitPart[searchIndex].equalsIgnoreCase(searchTerm)) continue;
                replacing = true;
                if (StringUtils.elementExists(splitPart, resultIndex)) {
                    String formattedText = ((String)part).replace(splitPart[resultIndex], newMessage);
                    formatted[indexNumber] = formattedText;
                    break;
                }
                formatted[indexNumber] = (String)part + splitCharacter + newMessage;
                break;
            }
            if (!replacing) {
                formatted = StringUtils.addToArray(original, indexNumber + 1, searchTerm + splitCharacter + newMessage);
            }
        }
        return formatted;
    }

    public static String formatWord(String original) {
        return StringUtils.formatWord(original, false);
    }

    public static String formatWord(String original, boolean avoid) {
        return StringUtils.formatWord(original, avoid, false);
    }

    public static String formatWord(String original, boolean avoid, boolean skipSymbolReplacement) {
        return StringUtils.formatWord(original, avoid, skipSymbolReplacement, -1);
    }

    public static String formatWord(String original, boolean avoid, boolean skipSymbolReplacement, int caseCheckTimes) {
        String formattedKey = original;
        if (StringUtils.isNullOrEmpty(formattedKey) || avoid) {
            return formattedKey;
        }
        if (StringUtils.containsWhitespace(formattedKey)) {
            formattedKey = formattedKey.replaceAll("\\s+", " ");
        }
        if (!skipSymbolReplacement) {
            if (formattedKey.contains("_")) {
                formattedKey = formattedKey.replaceAll("_", " ");
            }
            if (formattedKey.contains("-")) {
                formattedKey = formattedKey.replaceAll("-", " ");
            }
            if (BRACKET_PATTERN.matcher(formattedKey).find()) {
                formattedKey = BRACKET_PATTERN.matcher(formattedKey).replaceAll("");
            }
            if (STRIP_COLOR_PATTERN.matcher(formattedKey).find()) {
                formattedKey = STRIP_COLOR_PATTERN.matcher(formattedKey).replaceAll("");
            }
        }
        return StringUtils.removeRepeatWords(StringUtils.capitalizeWord(formattedKey, caseCheckTimes)).trim();
    }

    public static String removeRepeatWords(String original) {
        String[] wordList;
        if (StringUtils.isNullOrEmpty(original)) {
            return original;
        }
        String lastWord = "";
        StringBuilder finalString = new StringBuilder();
        for (String word : wordList = original.split(" ")) {
            if (!StringUtils.isNullOrEmpty(lastWord) && word.equalsIgnoreCase(lastWord)) continue;
            finalString.append(word).append(" ");
            lastWord = word;
        }
        return finalString.toString().trim();
    }

    public static String formatIdentifier(String originalId, boolean formatToId) {
        return StringUtils.formatIdentifier(originalId, formatToId, false);
    }

    public static String formatIdentifier(String originalId, boolean formatToId, boolean avoid) {
        StringBuilder formattedKey = new StringBuilder(originalId);
        if (StringUtils.isNullOrEmpty(formattedKey.toString())) {
            return formattedKey.toString();
        }
        if (formattedKey.toString().contains("WorldProvider")) {
            formattedKey = new StringBuilder(formattedKey.toString().replace("WorldProvider", ""));
        }
        if (formattedKey.toString().contains("BiomeGen")) {
            formattedKey = new StringBuilder(formattedKey.toString().replace("BiomeGen", ""));
        }
        if (formattedKey.toString().contains("MobSpawner")) {
            formattedKey = new StringBuilder(formattedKey.toString().replace("MobSpawner", ""));
        }
        if (StringUtils.containsWhitespace(formattedKey.toString())) {
            formattedKey = new StringBuilder(formattedKey.toString().replaceAll("\\s+", " "));
        }
        if (formattedKey.toString().contains(":")) {
            formattedKey = new StringBuilder(formattedKey.toString().split(":", 2)[1]);
        }
        if (formattedKey.toString().contains("{") || formattedKey.toString().contains("}")) {
            formattedKey = new StringBuilder(formattedKey.toString().replaceAll("[{}]", ""));
        }
        if (formattedKey.toString().equalsIgnoreCase("surface")) {
            formattedKey = new StringBuilder("overworld");
        } else if (formattedKey.toString().equalsIgnoreCase("hell") || formattedKey.toString().equalsIgnoreCase("nether")) {
            formattedKey = new StringBuilder("the_nether");
        } else if (formattedKey.toString().equalsIgnoreCase("end") || formattedKey.toString().equalsIgnoreCase("sky")) {
            formattedKey = new StringBuilder("the_end");
        }
        if (formatToId) {
            return StringUtils.formatAsIcon(formattedKey.toString().replace(" ", "_"));
        }
        return StringUtils.formatWord(formattedKey.toString(), avoid);
    }

    public static String getFormatFromString(String text) {
        StringBuilder s = new StringBuilder();
        int index = -1;
        int stringLength = text.length();
        while ((index = text.indexOf(167, index + 1)) != -1) {
            char currentCharacter;
            if (index >= stringLength - 1 || !STRIP_COLOR_PATTERN.matcher(String.valueOf(currentCharacter = text.charAt(index + 1))).find()) continue;
            s = new StringBuilder("\u00a7" + currentCharacter);
        }
        return s.toString();
    }

    public static String capitalizeWord(String str, int timesToCheck) {
        StringBuilder s = new StringBuilder();
        int charIndex = 32;
        int timesLeft = timesToCheck;
        for (int index = 0; index < str.length(); ++index) {
            if (charIndex == 32 && str.charAt(index) != ' ' && (timesLeft > 0 || timesLeft == -1)) {
                s.append(Character.toUpperCase(str.charAt(index)));
                if (timesLeft > 0) {
                    --timesLeft;
                }
            } else {
                s.append(str.charAt(index));
            }
            charIndex = str.charAt(index);
        }
        return s.toString().trim();
    }

    public static String capitalizeWord(String str) {
        return StringUtils.capitalizeWord(str, -1);
    }

    public static List<String> splitTextByNewLine(String original) {
        if (!StringUtils.isNullOrEmpty(original)) {
            String formattedText = original;
            if (formattedText.contains("\n")) {
                formattedText = original.replace("\n", "&newline&");
            }
            if (formattedText.contains("\\n")) {
                formattedText = original.replace("\\n", "&newline&");
            }
            if (formattedText.contains("\\\\n+")) {
                formattedText = original.replace("\\\\n+", "&newline&");
            }
            return Lists.newArrayList((Object[])formattedText.split("&newline&"));
        }
        return Lists.newArrayList();
    }

    public static void sendMessageToPlayer(Entity sender, String message) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            List<String> lines = StringUtils.splitTextByNewLine(message);
            if (!lines.isEmpty()) {
                for (String line : lines) {
                    player.m_5661_((Component)Component.m_237113_((String)line), false);
                }
            }
        }
    }

    public static boolean elementExists(String[] data, int index) {
        return StringUtils.elementExists(Arrays.asList(data), index);
    }

    public static boolean elementExists(List<String> data, int index) {
        boolean result;
        try {
            result = data.size() >= index && !StringUtils.isNullOrEmpty(data.get(index));
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public static <E> boolean removeIf(Collection<E> collection, Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        Iterator<E> each = collection.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.next())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    public static <E> Collection<E> filter(Collection<E> collection, Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        Iterator<E> each = collection.iterator();
        while (each.hasNext()) {
            if (filter.test(each.next())) continue;
            each.remove();
        }
        return collection;
    }

    public static Object lookupObject(Class<?> classToAccess, Object instance, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            try {
                if (!StringUtils.doesClassContainField(classToAccess, fieldName)) continue;
                Field lookupField = classToAccess.getDeclaredField(fieldName);
                lookupField.setAccessible(true);
                return lookupField.get(instance);
            }
            catch (Error | Exception ex) {
                if (!ModUtils.IS_VERBOSE) continue;
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static boolean doesClassContainField(Class<?> classToAccess, String fieldName) {
        return !StringUtils.filter(Lists.newArrayList((Object[])classToAccess.getDeclaredFields()), f -> f.getName().equals(fieldName)).isEmpty();
    }

    public static void updateField(Class<?> classToAccess, Object instance, Tuple<?, ?, ?> ... fieldData) {
        for (Tuple<?, ?, ?> currentData : fieldData) {
            try {
                Field lookupField = classToAccess.getDeclaredField(currentData.getFirst().toString());
                lookupField.setAccessible(true);
                if (currentData.getThird() != null) {
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(lookupField, lookupField.getModifiers() & Integer.parseInt(currentData.getThird().toString()));
                }
                lookupField.set(instance, currentData.getSecond());
                if (!ModUtils.IS_VERBOSE) continue;
                ModUtils.LOG.debugInfo(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.update.dynamic", currentData.toString(), classToAccess.getName()), new Object[0]);
            }
            catch (Exception ex) {
                if (!ModUtils.IS_VERBOSE) continue;
                ex.printStackTrace();
            }
        }
    }

    public static void executeMethod(Class<?> classToAccess, Object instance, List<Pair<String, Pair<Object[], Class<?>[]>>> methodData) {
        for (Pair<String, Pair<Object[], Class<?>[]>> methodInstance : methodData) {
            try {
                Method lookupMethod = classToAccess.getDeclaredMethod(methodInstance.getFirst(), methodInstance.getSecond().getSecond());
                lookupMethod.setAccessible(true);
                lookupMethod.invoke(instance, methodInstance.getSecond().getFirst());
            }
            catch (Error | Exception ex) {
                if (!ModUtils.IS_VERBOSE) continue;
                ex.printStackTrace();
            }
        }
    }

    public static String stripColors(String input) {
        return StringUtils.isNullOrEmpty(input) ? input : STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
    }
}

