/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.impl.discord.ArgumentType;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.DiscordUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.CheckBoxControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import net.minecraft.client.gui.screens.Screen;

public class AdvancedSettingsGui
extends ExtendedScreen {
    private ExtendedButtonControl proceedButton;
    private ExtendedButtonControl guiMessagesButton;
    private ExtendedButtonControl itemMessagesButton;
    private ExtendedButtonControl entityTargetMessagesButton;
    private ExtendedButtonControl entityRidingMessagesButton;
    private CheckBoxControl enableCommandsButton;
    private CheckBoxControl enablePerGuiButton;
    private CheckBoxControl enablePerItemButton;
    private CheckBoxControl enablePerEntityButton;
    private CheckBoxControl renderTooltipsButton;
    private CheckBoxControl formatWordsButton;
    private CheckBoxControl debugModeButton;
    private CheckBoxControl verboseModeButton;
    private CheckBoxControl allowPlaceholderPreviewsButton;
    private CheckBoxControl allowPlaceholderOperatorsButton;
    private ExtendedTextControl splitCharacter;
    private ExtendedTextControl refreshRate;

    AdvancedSettingsGui(Screen parentScreen) {
        super(parentScreen);
    }

    @Override
    public void initializeUi() {
        this.splitCharacter = this.addControl(new ExtendedTextControl(this.getFontRenderer(), this.getScreenWidth() / 2 - 60, CraftPresence.GUIS.getButtonY(1), 45, 20));
        this.splitCharacter.setControlMessage(CraftPresence.CONFIG.splitCharacter);
        this.splitCharacter.setControlMaxLength(1);
        this.refreshRate = this.addControl(new ExtendedTextControl(this.getFontRenderer(), this.getScreenWidth() / 2 + 103, CraftPresence.GUIS.getButtonY(1), 45, 20));
        this.refreshRate.setControlMessage(Integer.toString(CraftPresence.CONFIG.refreshRate));
        this.refreshRate.setControlMaxLength(3);
        int calc1 = this.getScreenWidth() / 2 - 160;
        int calc2 = this.getScreenWidth() / 2 + 3;
        this.guiMessagesButton = this.addControl(new ExtendedButtonControl(calc1, CraftPresence.GUIS.getButtonY(2), 160, 20, "gui.config.name.advanced.gui_messages", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.gui", new Object[0]), CraftPresence.GUIS.GUI_NAMES, null, null, true, true, ScrollableListControl.RenderType.None, null, (currentValue, parentScreen) -> CraftPresence.GUIS.openScreen(new DynamicEditorGui((Screen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.guiMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        }, (attributeName, screenInstance) -> {
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.gui.edit_specific_gui", attributeName);
            screenInstance.originalPrimaryMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.guiMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
            screenInstance.primaryMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.guiMessages, attributeName, 0, 1, CraftPresence.CONFIG.splitCharacter, screenInstance.originalPrimaryMessage);
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.guiMessages = StringUtils.setConfigPart(CraftPresence.CONFIG.guiMessages, attributeName, 0, 1, CraftPresence.CONFIG.splitCharacter, inputText);
            if (!CraftPresence.GUIS.GUI_NAMES.contains(attributeName)) {
                CraftPresence.GUIS.GUI_NAMES.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.guiMessages = StringUtils.removeFromArray(CraftPresence.CONFIG.guiMessages, attributeName, 0, CraftPresence.CONFIG.splitCharacter);
            CraftPresence.GUIS.GUI_NAMES.remove(attributeName);
        }, null, (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.gui_messages", CraftPresence.GUIS.generateArgumentMessage(new ArgumentType[0]))), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true))))), () -> {
            if (!this.guiMessagesButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.enable_per_gui", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.gui_messages", CraftPresence.GUIS.generateArgumentMessage(new ArgumentType[0]))), this, true);
            }
        }, new String[0]));
        this.itemMessagesButton = this.addControl(new ExtendedButtonControl(calc2, CraftPresence.GUIS.getButtonY(2), 160, 20, "gui.config.name.advanced.item_messages", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.item", new Object[0]), CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES, null, null, true, true, ScrollableListControl.RenderType.ItemData, null, (currentValue, parentScreen) -> CraftPresence.GUIS.openScreen(new DynamicEditorGui((Screen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        }, (attributeName, screenInstance) -> {
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.item.edit_specific_item", attributeName);
            screenInstance.originalPrimaryMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
            screenInstance.primaryMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, attributeName, 0, 1, CraftPresence.CONFIG.splitCharacter, screenInstance.originalPrimaryMessage);
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.itemMessages = StringUtils.setConfigPart(CraftPresence.CONFIG.itemMessages, attributeName, 0, 1, CraftPresence.CONFIG.splitCharacter, inputText);
            if (!CraftPresence.TILE_ENTITIES.ITEM_NAMES.contains(attributeName)) {
                CraftPresence.TILE_ENTITIES.ITEM_NAMES.add((String)attributeName);
            }
            if (!CraftPresence.TILE_ENTITIES.BLOCK_NAMES.contains(attributeName)) {
                CraftPresence.TILE_ENTITIES.BLOCK_NAMES.add((String)attributeName);
            }
            CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES.remove(attributeName);
            CraftPresence.TILE_ENTITIES.verifyEntities();
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.itemMessages = StringUtils.removeFromArray(CraftPresence.CONFIG.itemMessages, attributeName, 0, CraftPresence.CONFIG.splitCharacter);
            CraftPresence.TILE_ENTITIES.ITEM_NAMES.remove(attributeName);
            CraftPresence.TILE_ENTITIES.BLOCK_NAMES.remove(attributeName);
            CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES.remove(attributeName);
        }, null, (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.item_messages", CraftPresence.TILE_ENTITIES.generateArgumentMessage(new ArgumentType[0]), ModUtils.TRANSLATOR.translate("gui.config.message.tags", CraftPresence.TILE_ENTITIES.generatePlaceholderString((String)attributeName, screenInstance.isDebugMode(), CraftPresence.TILE_ENTITIES.getListFromName((String)attributeName))))), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true))))), () -> {
            if (!this.itemMessagesButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.enable_per_item", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.item_messages", CraftPresence.TILE_ENTITIES.generateArgumentMessage(new ArgumentType[0]), ModUtils.TRANSLATOR.translate("gui.config.message.tags", CraftPresence.TILE_ENTITIES.generatePlaceholderString("", this.isDebugMode(), CraftPresence.TILE_ENTITIES.getListFromName(""))))), this, true);
            }
        }, new String[0]));
        this.entityTargetMessagesButton = this.addControl(new ExtendedButtonControl(calc1, CraftPresence.GUIS.getButtonY(3), 160, 20, "gui.config.name.advanced.entity_target_messages", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.entity", new Object[0]), CraftPresence.ENTITIES.ENTITY_NAMES, null, null, true, true, ScrollableListControl.RenderType.EntityData, null, (currentValue, parentScreen) -> CraftPresence.GUIS.openScreen(new DynamicEditorGui((Screen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityTargetMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        }, (attributeName, screenInstance) -> {
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.entity.edit_specific_entity", attributeName);
            screenInstance.originalPrimaryMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityTargetMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
            screenInstance.primaryMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityTargetMessages, attributeName, 0, 1, CraftPresence.CONFIG.splitCharacter, screenInstance.originalPrimaryMessage);
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.entityTargetMessages = StringUtils.setConfigPart(CraftPresence.CONFIG.entityTargetMessages, attributeName, 0, 1, CraftPresence.CONFIG.splitCharacter, inputText);
            if (!CraftPresence.ENTITIES.ENTITY_NAMES.contains(attributeName)) {
                CraftPresence.ENTITIES.ENTITY_NAMES.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.entityTargetMessages = StringUtils.removeFromArray(CraftPresence.CONFIG.entityTargetMessages, attributeName, 0, CraftPresence.CONFIG.splitCharacter);
            CraftPresence.ENTITIES.ENTITY_NAMES.remove(attributeName);
        }, null, (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.entity_target_messages", CraftPresence.ENTITIES.generateArgumentMessage("&TARGETENTITY&", "&TARGETENTITY:", new ArgumentType[0]), ModUtils.TRANSLATOR.translate("gui.config.message.tags", CraftPresence.ENTITIES.generatePlaceholderString((String)attributeName, screenInstance.isDebugMode(), CraftPresence.ENTITIES.getListFromName((String)attributeName))))), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true))))), () -> {
            if (!this.entityTargetMessagesButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.enable_per_entity", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.entity_target_messages", CraftPresence.ENTITIES.generateArgumentMessage("&TARGETENTITY&", "&TARGETENTITY:", new ArgumentType[0]), ModUtils.TRANSLATOR.translate("gui.config.message.tags", CraftPresence.ENTITIES.generatePlaceholderString(CraftPresence.ENTITIES.getEntityName(CraftPresence.ENTITIES.CURRENT_TARGET, CraftPresence.ENTITIES.CURRENT_TARGET_NAME), this.isDebugMode(), CraftPresence.ENTITIES.CURRENT_TARGET_TAGS)))), this, true);
            }
        }, new String[0]));
        this.entityRidingMessagesButton = this.addControl(new ExtendedButtonControl(calc2, CraftPresence.GUIS.getButtonY(3), 160, 20, "gui.config.name.advanced.entity_riding_messages", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.entity", new Object[0]), CraftPresence.ENTITIES.ENTITY_NAMES, null, null, true, true, ScrollableListControl.RenderType.EntityData, null, (currentValue, parentScreen) -> CraftPresence.GUIS.openScreen(new DynamicEditorGui((Screen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityRidingMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        }, (attributeName, screenInstance) -> {
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.entity.edit_specific_entity", attributeName);
            screenInstance.originalPrimaryMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityRidingMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
            screenInstance.primaryMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityRidingMessages, attributeName, 0, 1, CraftPresence.CONFIG.splitCharacter, screenInstance.originalPrimaryMessage);
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.entityRidingMessages = StringUtils.setConfigPart(CraftPresence.CONFIG.entityRidingMessages, attributeName, 0, 1, CraftPresence.CONFIG.splitCharacter, inputText);
            if (!CraftPresence.ENTITIES.ENTITY_NAMES.contains(attributeName)) {
                CraftPresence.ENTITIES.ENTITY_NAMES.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.entityRidingMessages = StringUtils.removeFromArray(CraftPresence.CONFIG.entityRidingMessages, attributeName, 0, CraftPresence.CONFIG.splitCharacter);
            CraftPresence.ENTITIES.ENTITY_NAMES.remove(attributeName);
        }, null, (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.entity_riding_messages", CraftPresence.ENTITIES.generateArgumentMessage("&RIDINGENTITY&", "&RIDINGENTITY:", new ArgumentType[0]), ModUtils.TRANSLATOR.translate("gui.config.message.tags", CraftPresence.ENTITIES.generatePlaceholderString((String)attributeName, screenInstance.isDebugMode(), CraftPresence.ENTITIES.getListFromName((String)attributeName))))), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true))))), () -> {
            if (!this.entityRidingMessagesButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.enable_per_entity", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.entity_riding_messages", CraftPresence.ENTITIES.generateArgumentMessage("&RIDINGENTITY&", "&RIDINGENTITY:", new ArgumentType[0]), ModUtils.TRANSLATOR.translate("gui.config.message.tags", CraftPresence.ENTITIES.generatePlaceholderString(CraftPresence.ENTITIES.getEntityName(CraftPresence.ENTITIES.CURRENT_RIDING, CraftPresence.ENTITIES.CURRENT_RIDING_NAME), this.isDebugMode(), CraftPresence.ENTITIES.CURRENT_RIDING_TAGS)))), this, true);
            }
        }, new String[0]));
        this.enableCommandsButton = this.addControl(new CheckBoxControl(calc1, CraftPresence.GUIS.getButtonY(4), "gui.config.name.advanced.enable_commands", CraftPresence.CONFIG.enableCommands, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.enable_commands", new Object[0])), this, true)));
        this.enablePerGuiButton = this.addControl(new CheckBoxControl(calc2, CraftPresence.GUIS.getButtonY(4), "gui.config.name.advanced.enable_per_gui", CraftPresence.CONFIG.enablePerGui, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.enable_per_gui", new Object[0])), this, true)));
        this.enablePerItemButton = this.addControl(new CheckBoxControl(calc1, CraftPresence.GUIS.getButtonY(5, -10), "gui.config.name.advanced.enable_per_item", CraftPresence.CONFIG.enablePerItem, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.enable_per_item", new Object[0])), this, true)));
        this.enablePerEntityButton = this.addControl(new CheckBoxControl(calc2, CraftPresence.GUIS.getButtonY(5, -10), "gui.config.name.advanced.enable_per_entity", CraftPresence.CONFIG.enablePerEntity, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.enable_per_entity", new Object[0])), this, true)));
        this.renderTooltipsButton = this.addControl(new CheckBoxControl(calc1, CraftPresence.GUIS.getButtonY(6, -20), "gui.config.name.advanced.render_tooltips", CraftPresence.CONFIG.renderTooltips, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.render_tooltips", new Object[0])), this, true)));
        this.formatWordsButton = this.addControl(new CheckBoxControl(calc2, CraftPresence.GUIS.getButtonY(6, -20), "gui.config.name.advanced.format_words", CraftPresence.CONFIG.formatWords, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.format_words", new Object[0])), this, true)));
        this.debugModeButton = this.addControl(new CheckBoxControl(calc1, CraftPresence.GUIS.getButtonY(7, -30), "gui.config.name.advanced.debug_mode", CraftPresence.CONFIG.debugMode, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.debug_mode", CraftPresence.isDevStatusOverridden)), this, true)));
        this.verboseModeButton = this.addControl(new CheckBoxControl(calc2, CraftPresence.GUIS.getButtonY(7, -30), "gui.config.name.advanced.verbose_mode", CraftPresence.CONFIG.verboseMode, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.verbose_mode", CraftPresence.isVerboseStatusOverridden)), this, true)));
        this.allowPlaceholderPreviewsButton = this.addControl(new CheckBoxControl(calc1, CraftPresence.GUIS.getButtonY(8, -40), "gui.config.name.advanced.allow_placeholder_previews", CraftPresence.CONFIG.allowPlaceholderPreviews, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.allow_placeholder_previews", new Object[0])), this, true)));
        this.allowPlaceholderOperatorsButton = this.addControl(new CheckBoxControl(calc2, CraftPresence.GUIS.getButtonY(8, -40), "gui.config.name.advanced.allow_placeholder_operators", CraftPresence.CONFIG.allowPlaceholderOperators, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.allow_placeholder_operators", new Object[0])), this, true)));
        this.proceedButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 30, 180, 20, "gui.config.message.button.back", () -> {
            if (!this.splitCharacter.getControlMessage().equals(CraftPresence.CONFIG.splitCharacter)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                CraftPresence.CONFIG.queuedSplitCharacter = this.splitCharacter.getControlMessage();
            }
            if (!this.refreshRate.getControlMessage().equals(Integer.toString(CraftPresence.CONFIG.refreshRate))) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                CraftPresence.CONFIG.refreshRate = StringUtils.getValidInteger(this.refreshRate.getControlMessage()).getSecond();
            }
            if (this.enableCommandsButton.isChecked() != CraftPresence.CONFIG.enableCommands) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.enableCommands = this.enableCommandsButton.isChecked();
            }
            if (this.enablePerGuiButton.isChecked() != CraftPresence.CONFIG.enablePerGui) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                CraftPresence.CONFIG.enablePerGui = this.enablePerGuiButton.isChecked();
            }
            if (this.enablePerItemButton.isChecked() != CraftPresence.CONFIG.enablePerItem) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                CraftPresence.CONFIG.enablePerItem = this.enablePerItemButton.isChecked();
            }
            if (this.enablePerEntityButton.isChecked() != CraftPresence.CONFIG.enablePerEntity) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                CraftPresence.CONFIG.enablePerEntity = this.enablePerEntityButton.isChecked();
            }
            if (this.renderTooltipsButton.isChecked() != CraftPresence.CONFIG.renderTooltips) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.renderTooltips = this.renderTooltipsButton.isChecked();
            }
            if (this.formatWordsButton.isChecked() != CraftPresence.CONFIG.formatWords) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.formatWords = this.formatWordsButton.isChecked();
            }
            if (this.debugModeButton.isChecked() != CraftPresence.CONFIG.debugMode) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                CraftPresence.CONFIG.debugMode = this.debugModeButton.isChecked();
            }
            if (this.verboseModeButton.isChecked() != CraftPresence.CONFIG.verboseMode) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                CraftPresence.CONFIG.verboseMode = this.verboseModeButton.isChecked();
            }
            if (this.allowPlaceholderPreviewsButton.isChecked() != CraftPresence.CONFIG.allowPlaceholderPreviews) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.allowPlaceholderPreviews = this.allowPlaceholderPreviewsButton.isChecked();
            }
            if (this.allowPlaceholderOperatorsButton.isChecked() != CraftPresence.CONFIG.allowPlaceholderOperators) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                CraftPresence.CONFIG.allowPlaceholderOperators = this.allowPlaceholderOperatorsButton.isChecked();
            }
            CraftPresence.GUIS.openScreen(this.parentScreen);
        }, () -> {
            if (!this.proceedButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])), this, true);
            }
        }, new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.title.advanced", new Object[0]);
        String splitCharacterText = ModUtils.TRANSLATOR.translate("gui.config.name.advanced.split_character", new Object[0]);
        String refreshRateText = ModUtils.TRANSLATOR.translate("gui.config.name.advanced.refresh_rate", new Object[0]);
        this.renderString(mainTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.renderString(subTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(subTitle) / 2.0f, 20.0f, 0xFFFFFF);
        this.renderString(splitCharacterText, (float)this.getScreenWidth() / 2.0f - 145.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF);
        this.renderString(refreshRateText, (float)this.getScreenWidth() / 2.0f + 18.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF);
        Pair<Boolean, Integer> refreshRateData = StringUtils.getValidInteger(this.refreshRate.getControlMessage());
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.splitCharacter.getControlMessage()) && !StringUtils.containsAlphaNumeric(this.splitCharacter.getControlMessage()) && !DiscordUtils.validOperators.containsKey(this.splitCharacter.getControlMessage()) && refreshRateData.getFirst() != false && refreshRateData.getSecond() >= 2);
        this.guiMessagesButton.setControlEnabled(!CraftPresence.CONFIG.hasChanged ? CraftPresence.GUIS.enabled : this.guiMessagesButton.isControlEnabled());
        this.itemMessagesButton.setControlEnabled(!CraftPresence.CONFIG.hasChanged ? CraftPresence.TILE_ENTITIES.enabled : this.itemMessagesButton.isControlEnabled());
        this.entityTargetMessagesButton.setControlEnabled(!CraftPresence.CONFIG.hasChanged ? CraftPresence.ENTITIES.enabled : this.entityTargetMessagesButton.isControlEnabled());
        this.entityRidingMessagesButton.setControlEnabled(!CraftPresence.CONFIG.hasChanged ? CraftPresence.ENTITIES.enabled : this.entityRidingMessagesButton.isControlEnabled());
    }

    @Override
    public void postRender() {
        String splitCharacterText = ModUtils.TRANSLATOR.translate("gui.config.name.advanced.split_character", new Object[0]);
        String refreshRateText = ModUtils.TRANSLATOR.translate("gui.config.name.advanced.refresh_rate", new Object[0]);
        if (CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 145.0f, CraftPresence.GUIS.getButtonY(1, 5), this.getStringWidth(splitCharacterText), this.getFontHeight())) {
            CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.split_character", new Object[0])), this, true);
        }
        if (CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f + 18.0f, CraftPresence.GUIS.getButtonY(1, 5), this.getStringWidth(refreshRateText), this.getFontHeight())) {
            CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.refresh_rate", new Object[0])), this, true);
        }
    }
}

