/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Pair;
import fabric.com.gitlab.cdagaming.craftpresence.impl.discord.ArgumentType;
import fabric.com.gitlab.cdagaming.craftpresence.utils.MappingUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7887;
import net.minecraft.class_7924;

public class DimensionUtils {
    private final List<class_2960> DIMENSION_TYPES = Lists.newArrayList();
    private final String argumentFormat = "&DIMENSION&";
    private final String subArgumentFormat = "&DIMENSION:";
    private final List<Pair<String, String>> dimensionArgs = Lists.newArrayList();
    private final List<Pair<String, String>> iconArgs = Lists.newArrayList();
    public boolean isInUse = false;
    public boolean enabled = false;
    public List<String> DIMENSION_NAMES = Lists.newArrayList();
    private String CURRENT_DIMENSION_NAME;
    private String CURRENT_DIMENSION_IDENTIFIER;

    private void emptyData() {
        this.DIMENSION_NAMES.clear();
        this.DIMENSION_TYPES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_DIMENSION_NAME = null;
        this.CURRENT_DIMENSION_IDENTIFIER = null;
        this.dimensionArgs.clear();
        this.iconArgs.clear();
        this.isInUse = false;
        CraftPresence.CLIENT.removeArgumentsMatching("&DIMENSION:");
        CraftPresence.CLIENT.initArgument("&DIMENSION&");
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.detectDimensionData : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.DIMENSION_NAMES.isEmpty() || this.DIMENSION_TYPES.isEmpty());
        if (needsUpdate) {
            this.getDimensions();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateDimensionData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else if (this.isInUse) {
            this.emptyData();
        }
    }

    private void updateDimensionData() {
        String newDimension_Identifier;
        class_2960 newDimensionType = CraftPresence.player.field_6002.method_27983().method_29177();
        String newDimensionName = StringUtils.formatIdentifier(newDimensionType.toString(), false, !CraftPresence.CONFIG.formatWords);
        String newDimension_primaryIdentifier = StringUtils.formatIdentifier(newDimensionType.toString(), true, !CraftPresence.CONFIG.formatWords);
        String newDimension_alternativeIdentifier = StringUtils.formatIdentifier(MappingUtils.getClassName(newDimensionType), true, !CraftPresence.CONFIG.formatWords);
        String string = newDimension_Identifier = !StringUtils.isNullOrEmpty(newDimension_primaryIdentifier) ? newDimension_primaryIdentifier : newDimension_alternativeIdentifier;
        if (!newDimensionName.equals(this.CURRENT_DIMENSION_NAME) || !newDimension_Identifier.equals(this.CURRENT_DIMENSION_IDENTIFIER)) {
            this.CURRENT_DIMENSION_NAME = !StringUtils.isNullOrEmpty(newDimensionName) ? newDimensionName : newDimension_Identifier;
            this.CURRENT_DIMENSION_IDENTIFIER = newDimension_Identifier;
            if (!this.DIMENSION_NAMES.contains(newDimension_Identifier)) {
                this.DIMENSION_NAMES.add(newDimension_Identifier);
            }
            if (!this.DIMENSION_TYPES.contains(newDimensionType)) {
                this.DIMENSION_TYPES.add(newDimensionType);
            }
            this.updateDimensionPresence();
        }
    }

    public void updateDimensionPresence() {
        this.dimensionArgs.clear();
        this.iconArgs.clear();
        String defaultDimensionMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.dimensionMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String currentDimensionMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.dimensionMessages, this.CURRENT_DIMENSION_IDENTIFIER, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultDimensionMessage);
        String currentDimensionIcon = StringUtils.getConfigPart(CraftPresence.CONFIG.dimensionMessages, this.CURRENT_DIMENSION_IDENTIFIER, 0, 2, CraftPresence.CONFIG.splitCharacter, this.CURRENT_DIMENSION_IDENTIFIER);
        String formattedIconKey = StringUtils.formatAsIcon(currentDimensionIcon.replace(" ", "_"));
        this.dimensionArgs.add(new Pair<String, String>("&DIMENSION&", this.CURRENT_DIMENSION_NAME));
        this.iconArgs.add(new Pair<String, String>("&ICON&", CraftPresence.CONFIG.defaultDimensionIcon));
        for (Pair<String, String> argumentData : this.dimensionArgs) {
            CraftPresence.CLIENT.syncArgument("&DIMENSION:" + argumentData.getFirst().substring(1), argumentData.getSecond(), ArgumentType.Text);
        }
        for (Pair<String, String> argumentData : this.iconArgs) {
            CraftPresence.CLIENT.syncArgument("&DIMENSION:" + argumentData.getFirst().substring(1), argumentData.getSecond(), ArgumentType.Image);
        }
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            StringUtils.addEntriesNotPresent(this.dimensionArgs, CraftPresence.CLIENT.generalArgs);
        }
        String CURRENT_DIMENSION_ICON = StringUtils.sequentialReplaceAnyCase(formattedIconKey, this.iconArgs);
        String CURRENT_DIMENSION_MESSAGE = StringUtils.sequentialReplaceAnyCase(currentDimensionMessage, this.dimensionArgs);
        CraftPresence.CLIENT.syncArgument("&DIMENSION&", CURRENT_DIMENSION_MESSAGE, ArgumentType.Text);
        CraftPresence.CLIENT.syncArgument("&DIMENSION&", CraftPresence.CLIENT.imageOf("&DIMENSION&", true, CURRENT_DIMENSION_ICON, CraftPresence.CONFIG.defaultDimensionIcon), ArgumentType.Image);
    }

    private List<class_2960> getDimensionTypes() {
        List defaultDimensionTypes;
        ArrayList dimensionTypes = Lists.newArrayList();
        Optional dimensionRegistry = class_7887.method_46817().method_46759(class_7924.field_41241);
        if (dimensionRegistry.isPresent() && !(defaultDimensionTypes = ((class_7225.class_7226)dimensionRegistry.get()).method_42017().toList()).isEmpty()) {
            for (class_6880.class_6883 type : defaultDimensionTypes) {
                if (type == null) continue;
                dimensionTypes.add(type.method_40237().method_29177());
            }
        }
        return dimensionTypes;
    }

    public void getDimensions() {
        for (class_2960 TYPE : this.getDimensionTypes()) {
            if (TYPE == null) continue;
            String dimensionName = !StringUtils.isNullOrEmpty(TYPE.toString()) ? TYPE.toString() : MappingUtils.getClassName(TYPE);
            String name = StringUtils.formatIdentifier(dimensionName, true, !CraftPresence.CONFIG.formatWords);
            if (!this.DIMENSION_NAMES.contains(name)) {
                this.DIMENSION_NAMES.add(name);
            }
            if (this.DIMENSION_TYPES.contains(TYPE)) continue;
            this.DIMENSION_TYPES.add(TYPE);
        }
        for (String dimensionMessage : CraftPresence.CONFIG.dimensionMessages) {
            String name;
            String[] part;
            if (StringUtils.isNullOrEmpty(dimensionMessage) || StringUtils.isNullOrEmpty((part = dimensionMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.DIMENSION_NAMES.contains(name = StringUtils.formatIdentifier(part[0], true, !CraftPresence.CONFIG.formatWords))) continue;
            this.DIMENSION_NAMES.add(name);
        }
    }

    public String generateArgumentMessage(ArgumentType ... types) {
        types = types != null && types.length > 0 ? types : ArgumentType.values();
        HashMap argumentData = Maps.newHashMap();
        for (ArgumentType type : types) {
            ArrayList queuedEntries = Lists.newArrayList();
            if (type == ArgumentType.Image) {
                queuedEntries.add("&DIMENSION:ICON&");
            } else if (type == ArgumentType.Text) {
                queuedEntries.add("&DIMENSION:DIMENSION&");
            }
            argumentData.put(type, queuedEntries);
        }
        return CraftPresence.CLIENT.generateArgumentMessage("&DIMENSION&", "&DIMENSION:", argumentData);
    }
}

