/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;

public class PaginatedScreen
extends ExtendedScreen {
    private final Map<Integer, List<class_364>> paginatedControls = Maps.newHashMap();
    private final Map<Integer, List<ScrollableListControl>> paginatedLists = Maps.newHashMap();
    protected ExtendedButtonControl nextPageButton;
    protected ExtendedButtonControl previousPageButton;
    protected ExtendedButtonControl backButton;
    protected int startPage;
    protected int currentPage = this.startPage = 0;
    protected int maxPages = this.startPage;
    private Runnable onPageChange;

    public PaginatedScreen(class_437 parentScreen) {
        super(parentScreen);
    }

    public PaginatedScreen(class_437 parentScreen, boolean debugMode) {
        super(parentScreen, debugMode);
    }

    public PaginatedScreen(class_437 parentScreen, boolean debugMode, boolean verboseMode) {
        super(parentScreen, debugMode, verboseMode);
    }

    @Override
    public void initializeUi() {
        this.backButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 30, 180, 20, "gui.config.message.button.back", () -> CraftPresence.GUIS.openScreen(this.parentScreen), new String[0]));
        this.previousPageButton = this.addControl(new ExtendedButtonControl(this.backButton.getControlPosX() - 23, this.getScreenHeight() - 30, 20, 20, "<", () -> {
            if (this.currentPage > this.startPage) {
                --this.currentPage;
                if (this.onPageChange != null) {
                    this.onPageChange.run();
                }
            }
        }, new String[0]));
        this.nextPageButton = this.addControl(new ExtendedButtonControl(this.backButton.getControlPosX() + this.backButton.getControlWidth() + 3, this.getScreenHeight() - 30, 20, 20, ">", () -> {
            if (this.currentPage < this.maxPages) {
                ++this.currentPage;
                if (this.onPageChange != null) {
                    this.onPageChange.run();
                }
            }
        }, new String[0]));
        this.previousPageButton.setControlEnabled(this.currentPage > this.startPage);
        this.nextPageButton.setControlEnabled(this.currentPage < this.maxPages);
        super.initializeUi();
    }

    @Nonnull
    protected <T extends class_364 & class_4068> T addControl(@Nonnull T buttonIn, int renderTarget) {
        if (!this.paginatedControls.containsKey(renderTarget)) {
            this.paginatedControls.put(renderTarget, Lists.newArrayList((Object[])new class_364[]{buttonIn}));
            if (renderTarget > this.maxPages) {
                this.maxPages = renderTarget;
            }
        } else {
            this.paginatedControls.get(renderTarget).add(buttonIn);
        }
        return super.addControl(buttonIn);
    }

    @Nonnull
    protected <T extends ScrollableListControl> T addList(@Nonnull T buttonIn, int renderTarget) {
        if (!this.paginatedLists.containsKey(renderTarget)) {
            this.paginatedLists.put(renderTarget, Lists.newArrayList((Object[])new ScrollableListControl[]{buttonIn}));
            if (renderTarget > this.maxPages) {
                this.maxPages = renderTarget;
            }
        } else {
            this.paginatedLists.get(renderTarget).add(buttonIn);
        }
        return super.addList(buttonIn);
    }

    @Override
    public void preRender() {
        ArrayList defaultButtons = Lists.newArrayList((Object[])new class_364[]{this.previousPageButton, this.nextPageButton, this.backButton});
        List<class_364> elementsToRender = this.paginatedControls.getOrDefault(this.currentPage, defaultButtons);
        List<ScrollableListControl> listsToRender = this.paginatedLists.getOrDefault(this.currentPage, Lists.newArrayList());
        for (class_364 extendedControl : this.extendedControls) {
            if (extendedControl instanceof ExtendedButtonControl) {
                ((ExtendedButtonControl)extendedControl).setControlVisible(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
                ((ExtendedButtonControl)extendedControl).setControlEnabled(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
            }
            if (!(extendedControl instanceof ExtendedTextControl)) continue;
            ((ExtendedTextControl)extendedControl).method_1862(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
            ((ExtendedTextControl)extendedControl).method_1888(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
        }
        for (ScrollableListControl listControl : this.extendedLists) {
            listControl.setVisible(listsToRender.contains((Object)listControl));
        }
        this.previousPageButton.setControlEnabled(this.currentPage > this.startPage);
        this.nextPageButton.setControlEnabled(this.currentPage < this.maxPages);
    }

    @Override
    public boolean method_25404(int keyCode, int mouseX, int mouseY) {
        if (keyCode == 265 && this.currentPage > this.startPage) {
            --this.currentPage;
        }
        if (keyCode == 264 && this.currentPage < this.maxPages) {
            ++this.currentPage;
        }
        return super.method_25404(keyCode, mouseX, mouseY);
    }

    public void renderString(String text, float xPos, float yPos, int color, int renderTarget) {
        if (renderTarget == this.currentPage) {
            this.getFontRenderer().method_1720(this.currentMatrix, text, xPos, yPos, color);
        }
    }

    public void setOnPageChange(Runnable onPageChange) {
        this.onPageChange = onPageChange;
    }
}

