/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.google.common.collect.Lists;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ExtendedScreen
extends class_437 {
    public final class_437 parentScreen;
    public final class_437 currentScreen;
    protected final List<class_364> extendedControls = Lists.newArrayList();
    protected final List<ScrollableListControl> extendedLists = Lists.newArrayList();
    protected class_4587 currentMatrix = new class_4587();
    private boolean initialized = false;
    private boolean debugMode = false;
    private boolean verboseMode = false;
    private int lastMouseX = 0;
    private int lastMouseY = 0;

    public ExtendedScreen(class_437 parentScreen) {
        super((class_2561)class_2561.method_43470((String)""));
        this.field_22787 = CraftPresence.instance;
        this.currentScreen = this;
        this.parentScreen = parentScreen;
        this.setDebugMode(ModUtils.IS_DEV);
        this.setVerboseMode(ModUtils.IS_VERBOSE);
    }

    public ExtendedScreen(class_437 parentScreen, boolean debugMode) {
        this(parentScreen);
        this.setDebugMode(debugMode);
    }

    public ExtendedScreen(class_437 parentScreen, boolean debugMode, boolean verboseMode) {
        this(parentScreen, debugMode);
        this.setVerboseMode(verboseMode);
    }

    public void method_25426() {
        this.method_37067();
        this.extendedControls.clear();
        this.extendedLists.clear();
        this.initializeUi();
        super.method_25426();
        this.initialized = true;
    }

    public void initializeUi() {
    }

    public void method_25410(@Nonnull class_310 mcIn, int w, int h) {
        this.initialized = false;
        super.method_25410(mcIn, w, h);
    }

    @Nonnull
    protected <T extends class_364 & class_4068> T addControl(@Nonnull T buttonIn) {
        if (buttonIn instanceof class_4068) {
            this.method_37060(buttonIn);
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    protected <T extends ScrollableListControl> T addList(@Nonnull T buttonIn) {
        if (!this.extendedLists.contains(buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        CraftPresence.GUIS.drawBackground(this.getScreenWidth(), this.getScreenHeight());
    }

    public void preRender() {
    }

    public void postRender() {
    }

    public void method_25394(@Nonnull class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentMatrix = matrixStack;
        if (this.initialized) {
            this.renderCriticalData();
            this.preRender();
            for (ScrollableListControl listControl : this.extendedLists) {
                if (!listControl.isVisible()) continue;
                listControl.method_25394(matrixStack, mouseX, mouseY, partialTicks);
            }
            for (class_364 extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.method_25394(matrixStack, mouseX, mouseY, partialTicks);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.method_25394(matrixStack, mouseX, mouseY, partialTicks);
            }
            super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            for (class_364 extendedControl : this.extendedControls) {
                ExtendedButtonControl extendedButton;
                if (!(extendedControl instanceof ExtendedButtonControl) || !CraftPresence.GUIS.isMouseOver((double)mouseX, (double)mouseY, extendedButton = (ExtendedButtonControl)extendedControl)) continue;
                extendedButton.onHover();
            }
            this.postRender();
        }
    }

    public boolean method_25404(int keyCode, int mouseX, int mouseY) {
        if (this.initialized) {
            if (keyCode == 256) {
                CraftPresence.GUIS.openScreen(this.parentScreen);
                return true;
            }
            for (class_364 extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.method_25404(keyCode, mouseX, mouseY);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.method_25404(keyCode, mouseX, mouseY);
            }
        }
        return super.method_25404(keyCode, mouseX, mouseY);
    }

    public boolean method_25400(char typedChar, int keyCode) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.method_25400(typedChar, keyCode);
            }
            for (class_364 extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.method_25400(typedChar, keyCode);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.method_25400(typedChar, keyCode);
            }
        }
        return super.method_25400(typedChar, keyCode);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.method_25402(mouseX, mouseY, mouseButton);
            }
            for (class_364 extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.method_25402(mouseX, mouseY, mouseButton);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.method_25402(mouseX, mouseY, mouseButton);
            }
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollAmount) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.method_25401(mouseX, mouseY, scrollAmount);
            }
            for (class_364 extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.method_25401(mouseX, mouseY, scrollAmount);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.method_25401(mouseX, mouseY, scrollAmount);
            }
        }
        return super.method_25401(mouseX, mouseY, scrollAmount);
    }

    public boolean method_25403(double mouseX, double mouseY, int mouseButton, double scrollX, double scrollY) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.method_25403(mouseX, mouseY, mouseButton, scrollX, scrollY);
            }
            for (class_364 extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.method_25403(mouseX, mouseY, mouseButton, scrollX, scrollY);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.method_25403(mouseX, mouseY, mouseButton, scrollX, scrollY);
            }
        }
        return super.method_25403(mouseX, mouseY, mouseButton, scrollX, scrollY);
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.method_25406(mouseX, mouseY, mouseButton);
            }
            for (class_364 extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.method_25406(mouseX, mouseY, mouseButton);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.method_25406(mouseX, mouseY, mouseButton);
            }
        }
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    public void method_25393() {
        if (this.initialized) {
            for (class_364 extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.method_1865();
            }
        }
    }

    public boolean method_25422() {
        return false;
    }

    public void method_25432() {
        this.initialized = false;
        CraftPresence.GUIS.resetIndex();
    }

    public void renderNotice(List<String> notice) {
        this.renderNotice(notice, 2.0f, 3.0f, false, false);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale) {
        this.renderNotice(notice, widthScale, heightScale, false, false);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale, boolean useXAsActual, boolean useYAsActual) {
        if (notice != null && !notice.isEmpty()) {
            for (int i = 0; i < notice.size(); ++i) {
                String string = notice.get(i);
                this.renderString(string, (useXAsActual ? widthScale : (float)this.getScreenWidth() / widthScale) - (float)this.getStringWidth(string) / widthScale, (useYAsActual ? heightScale : (float)this.getScreenHeight() / heightScale) + (float)(i * 10), 0xFFFFFF);
            }
        }
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        this.getFontRenderer().method_1720(this.currentMatrix, text, xPos, yPos, color);
    }

    public int getStringWidth(String string) {
        return this.getFontRenderer().method_1727(string);
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public int getScreenWidth() {
        return this.field_22789;
    }

    public int getScreenHeight() {
        return this.field_22790;
    }

    public class_327 getFontRenderer() {
        return this.field_22787.field_1772 != null ? this.field_22787.field_1772 : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        Objects.requireNonNull(this.getFontRenderer());
        return 9;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.debugMode = isDebugMode;
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode(boolean isVerboseMode) {
        this.verboseMode = isVerboseMode;
    }
}

