/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Pair;
import fabric.com.gitlab.cdagaming.craftpresence.impl.discord.ArgumentType;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class TileEntityUtils {
    public final List<String> BLOCK_NAMES = Lists.newArrayList();
    public final List<String> ITEM_NAMES = Lists.newArrayList();
    private final List<Pair<String, String>> equipmentArgs = Lists.newArrayList();
    private final List<String> BLOCK_CLASSES = Lists.newArrayList();
    private final List<String> ITEM_CLASSES = Lists.newArrayList();
    private final List<String> TILE_ENTITY_CLASSES = Lists.newArrayList();
    private final class_1792 EMPTY_ITEM = null;
    private final class_1799 EMPTY_STACK = new class_1799((class_1935)this.EMPTY_ITEM);
    private final String argumentFormat = "&TILEENTITY&";
    private final String subArgumentFormat = "&TILEENTITY:";
    private final Map<String, List<Pair<String, String>>> subArgumentData = Maps.newHashMap();
    public boolean isInUse = false;
    public boolean enabled = false;
    public List<String> TILE_ENTITY_NAMES = Lists.newArrayList();
    public Map<String, class_2960> TILE_ENTITY_RESOURCES = Maps.newHashMap();
    public List<String> CURRENT_MAIN_HAND_ITEM_TAGS = Lists.newArrayList();
    public List<String> CURRENT_OFFHAND_ITEM_TAGS = Lists.newArrayList();
    public List<String> CURRENT_HELMET_TAGS = Lists.newArrayList();
    public List<String> CURRENT_CHEST_TAGS = Lists.newArrayList();
    public List<String> CURRENT_LEGS_TAGS = Lists.newArrayList();
    public List<String> CURRENT_BOOTS_TAGS = Lists.newArrayList();
    private List<Pair<String, String>> tileEntityArgs = Lists.newArrayList();
    private class_1799 CURRENT_MAIN_HAND_ITEM;
    private class_1799 CURRENT_OFFHAND_ITEM;
    private class_1799 CURRENT_HELMET;
    private class_1799 CURRENT_CHEST;
    private class_1799 CURRENT_LEGS;
    private class_1799 CURRENT_BOOTS;
    private String CURRENT_MAIN_HAND_ITEM_NAME;
    private String CURRENT_OFFHAND_ITEM_NAME;
    private String CURRENT_HELMET_NAME;
    private String CURRENT_CHEST_NAME;
    private String CURRENT_LEGS_NAME;
    private String CURRENT_BOOTS_NAME;
    private class_2487 CURRENT_MAIN_HAND_ITEM_TAG;
    private class_2487 CURRENT_OFFHAND_ITEM_TAG;
    private class_2487 CURRENT_HELMET_TAG;
    private class_2487 CURRENT_CHEST_TAG;
    private class_2487 CURRENT_LEGS_TAG;
    private class_2487 CURRENT_BOOTS_TAG;
    private boolean allItemsEmpty = false;

    private void emptyData() {
        this.BLOCK_NAMES.clear();
        this.BLOCK_CLASSES.clear();
        this.ITEM_NAMES.clear();
        this.ITEM_CLASSES.clear();
        this.TILE_ENTITY_NAMES.clear();
        this.TILE_ENTITY_CLASSES.clear();
        this.TILE_ENTITY_RESOURCES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_MAIN_HAND_ITEM = this.EMPTY_STACK;
        this.CURRENT_OFFHAND_ITEM = this.EMPTY_STACK;
        this.CURRENT_MAIN_HAND_ITEM_NAME = null;
        this.CURRENT_OFFHAND_ITEM_NAME = null;
        this.CURRENT_HELMET = this.EMPTY_STACK;
        this.CURRENT_CHEST = this.EMPTY_STACK;
        this.CURRENT_LEGS = this.EMPTY_STACK;
        this.CURRENT_BOOTS = this.EMPTY_STACK;
        this.CURRENT_HELMET_NAME = null;
        this.CURRENT_CHEST_NAME = null;
        this.CURRENT_LEGS_NAME = null;
        this.CURRENT_BOOTS_NAME = null;
        this.CURRENT_MAIN_HAND_ITEM_TAG = null;
        this.CURRENT_OFFHAND_ITEM_TAG = null;
        this.CURRENT_HELMET_TAG = null;
        this.CURRENT_CHEST_TAG = null;
        this.CURRENT_LEGS_TAG = null;
        this.CURRENT_BOOTS_TAG = null;
        this.CURRENT_MAIN_HAND_ITEM_TAGS.clear();
        this.CURRENT_OFFHAND_ITEM_TAGS.clear();
        this.CURRENT_HELMET_TAGS.clear();
        this.CURRENT_CHEST_TAGS.clear();
        this.CURRENT_LEGS_TAGS.clear();
        this.CURRENT_BOOTS_TAGS.clear();
        this.tileEntityArgs.clear();
        this.equipmentArgs.clear();
        this.allItemsEmpty = true;
        this.isInUse = false;
        for (String entry : this.subArgumentData.keySet()) {
            CraftPresence.CLIENT.removeArgumentsMatching(ArgumentType.Text, entry);
        }
        this.subArgumentData.clear();
        CraftPresence.CLIENT.initArgument(ArgumentType.Text, "&TILEENTITY&");
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.enablePerItem : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.TILE_ENTITY_NAMES.isEmpty() || this.TILE_ENTITY_CLASSES.isEmpty());
        if (needsUpdate) {
            this.getEntities();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateEntityData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else if (this.isInUse) {
            this.emptyData();
        }
    }

    private boolean isEmpty(class_1792 item) {
        return item == null || this.isEmpty(this.getDefaultInstance(item));
    }

    private boolean isEmpty(class_2248 block) {
        return block == null || this.isEmpty(block.method_8389());
    }

    private class_1799 getDefaultInstance(class_1792 itemIn) {
        return new class_1799((class_1935)itemIn);
    }

    private boolean isEmpty(class_1799 itemStack) {
        if (itemStack == null || itemStack.equals(this.EMPTY_STACK)) {
            return true;
        }
        if (itemStack.method_7909() != this.EMPTY_ITEM && itemStack.method_7909() != class_1802.field_8162) {
            if (itemStack.method_7947() <= 0) {
                return true;
            }
            return itemStack.method_7919() < Short.MIN_VALUE || itemStack.method_7919() > 65535;
        }
        return true;
    }

    private void updateEntityData() {
        boolean hasBootsChanged;
        class_1799 NEW_CURRENT_MAIN_HAND_ITEM = CraftPresence.player.method_6047();
        class_1799 NEW_CURRENT_OFFHAND_ITEM = CraftPresence.player.method_6079();
        class_1799 NEW_CURRENT_HELMET = (class_1799)CraftPresence.player.method_31548().field_7548.get(3);
        class_1799 NEW_CURRENT_CHEST = (class_1799)CraftPresence.player.method_31548().field_7548.get(2);
        class_1799 NEW_CURRENT_LEGS = (class_1799)CraftPresence.player.method_31548().field_7548.get(1);
        class_1799 NEW_CURRENT_BOOTS = (class_1799)CraftPresence.player.method_31548().field_7548.get(0);
        String NEW_CURRENT_MAIN_HAND_ITEM_NAME = !this.isEmpty(NEW_CURRENT_MAIN_HAND_ITEM) ? StringUtils.stripColors(NEW_CURRENT_MAIN_HAND_ITEM.method_7964().getString()) : "";
        String NEW_CURRENT_OFFHAND_ITEM_NAME = !this.isEmpty(NEW_CURRENT_OFFHAND_ITEM) ? StringUtils.stripColors(NEW_CURRENT_OFFHAND_ITEM.method_7964().getString()) : "";
        String NEW_CURRENT_HELMET_NAME = !this.isEmpty(NEW_CURRENT_HELMET) ? StringUtils.stripColors(NEW_CURRENT_HELMET.method_7964().getString()) : "";
        String NEW_CURRENT_CHEST_NAME = !this.isEmpty(NEW_CURRENT_CHEST) ? StringUtils.stripColors(NEW_CURRENT_CHEST.method_7964().getString()) : "";
        String NEW_CURRENT_LEGS_NAME = !this.isEmpty(NEW_CURRENT_LEGS) ? StringUtils.stripColors(NEW_CURRENT_LEGS.method_7964().getString()) : "";
        String NEW_CURRENT_BOOTS_NAME = !this.isEmpty(NEW_CURRENT_BOOTS) ? StringUtils.stripColors(NEW_CURRENT_BOOTS.method_7964().getString()) : "";
        boolean hasMainHandChanged = !this.isEmpty(NEW_CURRENT_MAIN_HAND_ITEM) && !NEW_CURRENT_MAIN_HAND_ITEM.equals(this.CURRENT_MAIN_HAND_ITEM) || !NEW_CURRENT_MAIN_HAND_ITEM_NAME.equals(this.CURRENT_MAIN_HAND_ITEM_NAME) || this.isEmpty(NEW_CURRENT_MAIN_HAND_ITEM) && !this.isEmpty(this.CURRENT_MAIN_HAND_ITEM);
        boolean hasOffHandChanged = !this.isEmpty(NEW_CURRENT_OFFHAND_ITEM) && !NEW_CURRENT_OFFHAND_ITEM.equals(this.CURRENT_OFFHAND_ITEM) || !NEW_CURRENT_OFFHAND_ITEM_NAME.equals(this.CURRENT_OFFHAND_ITEM_NAME) || this.isEmpty(NEW_CURRENT_OFFHAND_ITEM) && !this.isEmpty(this.CURRENT_OFFHAND_ITEM);
        boolean hasHelmetChanged = !this.isEmpty(NEW_CURRENT_HELMET) && !NEW_CURRENT_HELMET.equals(this.CURRENT_HELMET) || !NEW_CURRENT_HELMET_NAME.equals(this.CURRENT_HELMET_NAME) || this.isEmpty(NEW_CURRENT_HELMET) && !this.isEmpty(this.CURRENT_HELMET);
        boolean hasChestChanged = !this.isEmpty(NEW_CURRENT_CHEST) && !NEW_CURRENT_CHEST.equals(this.CURRENT_CHEST) || !NEW_CURRENT_CHEST_NAME.equals(this.CURRENT_CHEST_NAME) || this.isEmpty(NEW_CURRENT_CHEST) && !this.isEmpty(this.CURRENT_CHEST);
        boolean hasLegsChanged = !this.isEmpty(NEW_CURRENT_LEGS) && !NEW_CURRENT_LEGS.equals(this.CURRENT_LEGS) || !NEW_CURRENT_LEGS_NAME.equals(this.CURRENT_LEGS_NAME) || this.isEmpty(NEW_CURRENT_LEGS) && !this.isEmpty(this.CURRENT_LEGS);
        boolean bl = hasBootsChanged = !this.isEmpty(NEW_CURRENT_BOOTS) && !NEW_CURRENT_BOOTS.equals(this.CURRENT_BOOTS) || !NEW_CURRENT_BOOTS_NAME.equals(this.CURRENT_BOOTS_NAME) || this.isEmpty(NEW_CURRENT_BOOTS) && !this.isEmpty(this.CURRENT_BOOTS);
        if (hasMainHandChanged) {
            ArrayList NEW_CURRENT_MAIN_HAND_ITEM_TAGS;
            this.CURRENT_MAIN_HAND_ITEM = NEW_CURRENT_MAIN_HAND_ITEM;
            this.CURRENT_MAIN_HAND_ITEM_TAG = !this.isEmpty(this.CURRENT_MAIN_HAND_ITEM) ? this.CURRENT_MAIN_HAND_ITEM.method_7953(new class_2487()) : null;
            ArrayList arrayList = NEW_CURRENT_MAIN_HAND_ITEM_TAGS = this.CURRENT_MAIN_HAND_ITEM_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_MAIN_HAND_ITEM_TAG.method_10541()) : Lists.newArrayList();
            if (!NEW_CURRENT_MAIN_HAND_ITEM_TAGS.equals(this.CURRENT_MAIN_HAND_ITEM_TAGS)) {
                this.CURRENT_MAIN_HAND_ITEM_TAGS = NEW_CURRENT_MAIN_HAND_ITEM_TAGS;
            }
            this.CURRENT_MAIN_HAND_ITEM_NAME = NEW_CURRENT_MAIN_HAND_ITEM_NAME;
        }
        if (hasOffHandChanged) {
            ArrayList NEW_CURRENT_OFFHAND_ITEM_TAGS;
            this.CURRENT_OFFHAND_ITEM = NEW_CURRENT_OFFHAND_ITEM;
            this.CURRENT_OFFHAND_ITEM_TAG = !this.isEmpty(this.CURRENT_OFFHAND_ITEM) ? this.CURRENT_OFFHAND_ITEM.method_7953(new class_2487()) : null;
            ArrayList arrayList = NEW_CURRENT_OFFHAND_ITEM_TAGS = this.CURRENT_OFFHAND_ITEM_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_OFFHAND_ITEM_TAG.method_10541()) : Lists.newArrayList();
            if (!NEW_CURRENT_OFFHAND_ITEM_TAGS.equals(this.CURRENT_OFFHAND_ITEM_TAGS)) {
                this.CURRENT_OFFHAND_ITEM_TAGS = NEW_CURRENT_OFFHAND_ITEM_TAGS;
            }
            this.CURRENT_OFFHAND_ITEM_NAME = NEW_CURRENT_OFFHAND_ITEM_NAME;
        }
        if (hasHelmetChanged) {
            ArrayList NEW_CURRENT_HELMET_TAGS;
            this.CURRENT_HELMET = NEW_CURRENT_HELMET;
            this.CURRENT_HELMET_TAG = !this.isEmpty(this.CURRENT_HELMET) ? this.CURRENT_HELMET.method_7953(new class_2487()) : null;
            ArrayList arrayList = NEW_CURRENT_HELMET_TAGS = this.CURRENT_HELMET_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_HELMET_TAG.method_10541()) : Lists.newArrayList();
            if (!NEW_CURRENT_HELMET_TAGS.equals(this.CURRENT_HELMET_TAGS)) {
                this.CURRENT_HELMET_TAGS = NEW_CURRENT_HELMET_TAGS;
            }
            this.CURRENT_HELMET_NAME = NEW_CURRENT_HELMET_NAME;
        }
        if (hasChestChanged) {
            ArrayList NEW_CURRENT_CHEST_TAGS;
            this.CURRENT_CHEST = NEW_CURRENT_CHEST;
            this.CURRENT_CHEST_TAG = !this.isEmpty(this.CURRENT_CHEST) ? this.CURRENT_CHEST.method_7953(new class_2487()) : null;
            ArrayList arrayList = NEW_CURRENT_CHEST_TAGS = this.CURRENT_CHEST_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_CHEST_TAG.method_10541()) : Lists.newArrayList();
            if (!NEW_CURRENT_CHEST_TAGS.equals(this.CURRENT_CHEST_TAGS)) {
                this.CURRENT_CHEST_TAGS = NEW_CURRENT_CHEST_TAGS;
            }
            this.CURRENT_CHEST_NAME = NEW_CURRENT_CHEST_NAME;
        }
        if (hasLegsChanged) {
            ArrayList NEW_CURRENT_LEGS_TAGS;
            this.CURRENT_LEGS = NEW_CURRENT_LEGS;
            this.CURRENT_LEGS_TAG = !this.isEmpty(this.CURRENT_LEGS) ? this.CURRENT_LEGS.method_7953(new class_2487()) : null;
            ArrayList arrayList = NEW_CURRENT_LEGS_TAGS = this.CURRENT_LEGS_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_LEGS_TAG.method_10541()) : Lists.newArrayList();
            if (!NEW_CURRENT_LEGS_TAGS.equals(this.CURRENT_LEGS_TAGS)) {
                this.CURRENT_LEGS_TAGS = NEW_CURRENT_LEGS_TAGS;
            }
            this.CURRENT_LEGS_NAME = NEW_CURRENT_LEGS_NAME;
        }
        if (hasBootsChanged) {
            ArrayList NEW_CURRENT_BOOTS_TAGS;
            this.CURRENT_BOOTS = NEW_CURRENT_BOOTS;
            this.CURRENT_BOOTS_TAG = !this.isEmpty(this.CURRENT_BOOTS) ? this.CURRENT_BOOTS.method_7953(new class_2487()) : null;
            ArrayList arrayList = NEW_CURRENT_BOOTS_TAGS = this.CURRENT_BOOTS_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_BOOTS_TAG.method_10541()) : Lists.newArrayList();
            if (!NEW_CURRENT_BOOTS_TAGS.equals(this.CURRENT_BOOTS_TAGS)) {
                this.CURRENT_BOOTS_TAGS = NEW_CURRENT_BOOTS_TAGS;
            }
            this.CURRENT_BOOTS_NAME = NEW_CURRENT_BOOTS_NAME;
        }
        if (hasMainHandChanged || hasOffHandChanged || hasHelmetChanged || hasChestChanged || hasLegsChanged || hasBootsChanged) {
            this.allItemsEmpty = this.isEmpty(this.CURRENT_MAIN_HAND_ITEM) && this.isEmpty(this.CURRENT_OFFHAND_ITEM) && this.isEmpty(this.CURRENT_HELMET) && this.isEmpty(this.CURRENT_CHEST) && this.isEmpty(this.CURRENT_LEGS) && this.isEmpty(this.CURRENT_BOOTS);
            this.updateEntityPresence();
        }
    }

    public void updateEntityPresence() {
        String defaultItemMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String placeholderItemMessage = CraftPresence.CONFIG.playerItemsPlaceholderMessage;
        String offHandItemMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_OFFHAND_ITEM_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_OFFHAND_ITEM_NAME);
        String mainItemMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_MAIN_HAND_ITEM_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultItemMessage);
        String helmetMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_HELMET_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_HELMET_NAME);
        String chestMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_CHEST_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_CHEST_NAME);
        String legsMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_LEGS_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_LEGS_NAME);
        String bootsMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_BOOTS_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_BOOTS_NAME);
        this.tileEntityArgs.clear();
        this.equipmentArgs.clear();
        for (String string : this.subArgumentData.keySet()) {
            CraftPresence.CLIENT.removeArgumentsMatching(ArgumentType.Text, string);
        }
        this.subArgumentData.clear();
        if (!this.CURRENT_MAIN_HAND_ITEM_TAGS.isEmpty()) {
            for (String string : this.CURRENT_MAIN_HAND_ITEM_TAGS) {
                mainItemMessage = StringUtils.replaceAnyCase(mainItemMessage, "&" + string + "&", this.CURRENT_MAIN_HAND_ITEM_TAG.method_10580(string).toString());
            }
        }
        if (!this.CURRENT_OFFHAND_ITEM_TAGS.isEmpty()) {
            for (String string : this.CURRENT_OFFHAND_ITEM_TAGS) {
                offHandItemMessage = StringUtils.replaceAnyCase(offHandItemMessage, "&" + string + "&", this.CURRENT_OFFHAND_ITEM_TAG.method_10580(string).toString());
            }
        }
        if (!this.CURRENT_HELMET_TAGS.isEmpty()) {
            for (String string : this.CURRENT_HELMET_TAGS) {
                helmetMessage = StringUtils.replaceAnyCase(helmetMessage, "&" + string + "&", this.CURRENT_HELMET_TAG.method_10580(string).toString());
            }
        }
        if (!this.CURRENT_CHEST_TAGS.isEmpty()) {
            for (String string : this.CURRENT_CHEST_TAGS) {
                chestMessage = StringUtils.replaceAnyCase(chestMessage, "&" + string + "&", this.CURRENT_CHEST_TAG.method_10580(string).toString());
            }
        }
        if (!this.CURRENT_LEGS_TAGS.isEmpty()) {
            for (String string : this.CURRENT_LEGS_TAGS) {
                legsMessage = StringUtils.replaceAnyCase(legsMessage, "&" + string + "&", this.CURRENT_LEGS_TAG.method_10580(string).toString());
            }
        }
        if (!this.CURRENT_BOOTS_TAGS.isEmpty()) {
            for (String string : this.CURRENT_BOOTS_TAGS) {
                bootsMessage = StringUtils.replaceAnyCase(bootsMessage, "&" + string + "&", this.CURRENT_BOOTS_TAG.method_10580(string).toString());
            }
        }
        this.equipmentArgs.add(new Pair<String, String>("&MAIN&", !StringUtils.isNullOrEmpty(this.CURRENT_MAIN_HAND_ITEM_NAME) ? StringUtils.replaceAnyCase(mainItemMessage, "&item&", this.CURRENT_MAIN_HAND_ITEM_NAME) : ""));
        this.equipmentArgs.add(new Pair<String, String>("&OFFHAND&", !StringUtils.isNullOrEmpty(this.CURRENT_OFFHAND_ITEM_NAME) ? StringUtils.replaceAnyCase(offHandItemMessage, "&item&", this.CURRENT_OFFHAND_ITEM_NAME) : ""));
        this.equipmentArgs.add(new Pair<String, String>("&HELMET&", !StringUtils.isNullOrEmpty(this.CURRENT_HELMET_NAME) ? StringUtils.replaceAnyCase(helmetMessage, "&item&", this.CURRENT_HELMET_NAME) : ""));
        this.equipmentArgs.add(new Pair<String, String>("&CHEST&", !StringUtils.isNullOrEmpty(this.CURRENT_CHEST_NAME) ? StringUtils.replaceAnyCase(chestMessage, "&item&", this.CURRENT_CHEST_NAME) : ""));
        this.equipmentArgs.add(new Pair<String, String>("&LEGS&", !StringUtils.isNullOrEmpty(this.CURRENT_LEGS_NAME) ? StringUtils.replaceAnyCase(legsMessage, "&item&", this.CURRENT_LEGS_NAME) : ""));
        this.equipmentArgs.add(new Pair<String, String>("&BOOTS&", !StringUtils.isNullOrEmpty(this.CURRENT_BOOTS_NAME) ? StringUtils.replaceAnyCase(bootsMessage, "&item&", this.CURRENT_BOOTS_NAME) : ""));
        this.subArgumentData.put("&TILEENTITY:", this.equipmentArgs);
        for (Map.Entry entry : this.subArgumentData.entrySet()) {
            if (StringUtils.isNullOrEmpty((String)entry.getKey()) || ((List)entry.getValue()).isEmpty()) continue;
            for (Pair argumentData : (List)entry.getValue()) {
                CraftPresence.CLIENT.syncArgument((String)entry.getKey() + ((String)argumentData.getFirst()).substring(1), (String)argumentData.getSecond(), ArgumentType.Text);
            }
        }
        this.tileEntityArgs = Lists.newArrayList(this.equipmentArgs);
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            StringUtils.addEntriesNotPresent(this.tileEntityArgs, CraftPresence.CLIENT.generalArgs);
        }
        String CURRENT_MESSAGE = StringUtils.sequentialReplaceAnyCase(placeholderItemMessage, this.tileEntityArgs);
        if (!this.allItemsEmpty) {
            CraftPresence.CLIENT.syncArgument("&TILEENTITY&", CURRENT_MESSAGE, ArgumentType.Text);
        } else {
            CraftPresence.CLIENT.removeArgumentsMatching(ArgumentType.Text, "&TILEENTITY:");
            CraftPresence.CLIENT.initArgument(ArgumentType.Text, "&TILEENTITY&");
        }
    }

    public String generateArgumentMessage(String argumentFormat, String subArgumentFormat, ArgumentType ... types) {
        boolean useDefault;
        types = types != null && types.length > 0 ? types : ArgumentType.values();
        boolean bl = useDefault = StringUtils.isNullOrEmpty(argumentFormat) && StringUtils.isNullOrEmpty(subArgumentFormat);
        if (useDefault) {
            argumentFormat = this.argumentFormat;
            subArgumentFormat = this.subArgumentFormat;
        }
        HashMap argumentData = Maps.newHashMap();
        for (ArgumentType type : types) {
            ArrayList queuedEntries = Lists.newArrayList();
            if (type == ArgumentType.Text) {
                if (!useDefault) {
                    queuedEntries.add(subArgumentFormat + "MAIN&");
                    queuedEntries.add(subArgumentFormat + "OFFHAND&");
                    queuedEntries.add(subArgumentFormat + "HELMET&");
                    queuedEntries.add(subArgumentFormat + "CHEST&");
                    queuedEntries.add(subArgumentFormat + "LEGS&");
                    queuedEntries.add(subArgumentFormat + "BOOTS&");
                } else {
                    queuedEntries.add(subArgumentFormat + "ITEM&");
                }
            }
            argumentData.put(type, queuedEntries);
        }
        return CraftPresence.CLIENT.generateArgumentMessage(argumentFormat, subArgumentFormat, argumentData);
    }

    public String generateArgumentMessage(ArgumentType ... types) {
        return this.generateArgumentMessage((String)null, (String)null, types);
    }

    public List<String> getListFromName(String name) {
        String string = name = !StringUtils.isNullOrEmpty(name) ? name : "";
        return name.equalsIgnoreCase(this.CURRENT_MAIN_HAND_ITEM_NAME) ? this.CURRENT_MAIN_HAND_ITEM_TAGS : (name.equalsIgnoreCase(this.CURRENT_OFFHAND_ITEM_NAME) ? this.CURRENT_OFFHAND_ITEM_TAGS : (name.equalsIgnoreCase(this.CURRENT_HELMET_NAME) ? this.CURRENT_HELMET_TAGS : (name.equalsIgnoreCase(this.CURRENT_CHEST_NAME) ? this.CURRENT_CHEST_TAGS : (name.equalsIgnoreCase(this.CURRENT_LEGS_NAME) ? this.CURRENT_LEGS_TAGS : (name.equalsIgnoreCase(this.CURRENT_BOOTS_NAME) ? this.CURRENT_BOOTS_TAGS : Lists.newArrayList())))));
    }

    public String generatePlaceholderString(String name, boolean addExtraData, List<String> tags) {
        StringBuilder finalString = new StringBuilder(addExtraData ? "" : "\n{");
        if (!tags.isEmpty()) {
            for (int i = 0; i < tags.size(); ++i) {
                String tagName = tags.get(i);
                finalString.append(addExtraData ? "\n - " : "").append("&").append(tagName).append("&");
                if (addExtraData) {
                    String tagValue;
                    String string = tags.equals(this.CURRENT_MAIN_HAND_ITEM_TAGS) ? this.CURRENT_MAIN_HAND_ITEM_TAG.method_10580(tagName).toString() : (tags.equals(this.CURRENT_OFFHAND_ITEM_TAGS) ? this.CURRENT_OFFHAND_ITEM_TAG.method_10580(tagName).toString() : (tags.equals(this.CURRENT_HELMET_TAGS) ? this.CURRENT_HELMET_TAG.method_10580(tagName).toString() : (tags.equals(this.CURRENT_CHEST_TAGS) ? this.CURRENT_CHEST_TAG.method_10580(tagName).toString() : (tags.equals(this.CURRENT_LEGS_TAGS) ? this.CURRENT_LEGS_TAG.method_10580(tagName).toString() : (tagValue = tags.equals(this.CURRENT_BOOTS_TAGS) ? this.CURRENT_BOOTS_TAG.method_10580(tagName).toString() : null)))));
                    if (StringUtils.isNullOrEmpty(tagValue)) continue;
                    finalString.append(String.format(" (%s \"%s\")", ModUtils.TRANSLATOR.translate("gui.config.message.editor.preview", new Object[0]), tagValue.length() >= 128 ? "<...>" : tagValue));
                    continue;
                }
                if (i >= tags.size() - 1) continue;
                finalString.append(",");
                if (i % 5 != 4) continue;
                finalString.append("\n");
            }
        }
        if (!addExtraData) {
            finalString.append("}");
        }
        return (!StringUtils.isNullOrEmpty(name) ? name : "None") + " " + (!StringUtils.isNullOrEmpty(finalString.toString()) && !finalString.toString().equals("\n{}") ? finalString.toString() : "\\n - N/A");
    }

    public void getEntities() {
        class_2960 initialData2;
        ArrayList defaultBlocks = Lists.newArrayList((Iterator)class_7923.field_41175.iterator());
        ArrayList defaultItems = Lists.newArrayList((Iterator)class_7923.field_41178.iterator());
        for (class_2248 block : defaultBlocks) {
            if (this.isEmpty(block)) continue;
            String blockName = block.method_9518().getString();
            if (!this.BLOCK_NAMES.contains(blockName)) {
                this.BLOCK_NAMES.add(blockName);
            }
            if (!this.BLOCK_CLASSES.contains(block.getClass().getName())) {
                this.BLOCK_CLASSES.add(block.getClass().getName());
            }
            if (this.TILE_ENTITY_RESOURCES.containsKey(blockName)) continue;
            try {
                initialData2 = CraftPresence.instance.method_1541().method_3349(block.method_9564()).method_4711().method_45851().method_45816();
                this.TILE_ENTITY_RESOURCES.put(blockName, new class_2960(initialData2.method_12836(), "textures/" + initialData2.method_12832() + ".png"));
            }
            catch (Exception initialData2) {}
        }
        for (class_1792 item : defaultItems) {
            if (this.isEmpty(item)) continue;
            String itemName = item.method_7864(this.getDefaultInstance(item)).getString();
            if (!this.ITEM_NAMES.contains(itemName)) {
                this.ITEM_NAMES.add(itemName);
            }
            if (!this.ITEM_CLASSES.contains(item.getClass().getName())) {
                this.ITEM_CLASSES.add(item.getClass().getName());
            }
            if (this.TILE_ENTITY_RESOURCES.containsKey(itemName)) continue;
            try {
                initialData2 = CraftPresence.instance.method_1480().method_4012().method_3308(this.getDefaultInstance(item)).method_4711().method_45851().method_45816();
                this.TILE_ENTITY_RESOURCES.put(itemName, new class_2960(initialData2.method_12836(), "textures/" + initialData2.method_12832() + ".png"));
            }
            catch (Exception initialData3) {}
        }
        for (String itemMessage : CraftPresence.CONFIG.itemMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(itemMessage) || StringUtils.isNullOrEmpty((part = itemMessage.split(CraftPresence.CONFIG.splitCharacter))[0])) continue;
            if (!this.ITEM_NAMES.contains(part[0])) {
                this.ITEM_NAMES.add(part[0]);
            }
            if (this.BLOCK_NAMES.contains(part[0])) continue;
            this.BLOCK_NAMES.add(part[0]);
        }
        this.verifyEntities();
    }

    public void verifyEntities() {
        ArrayList removingBlocks = Lists.newArrayList();
        ArrayList removingItems = Lists.newArrayList();
        for (String itemName : this.ITEM_NAMES) {
            String lowerItemName;
            if (StringUtils.isNullOrEmpty(itemName) || !(lowerItemName = itemName.toLowerCase()).contains("tile.") && !lowerItemName.contains("item.") && !lowerItemName.contains(".") && !lowerItemName.contains(".name")) continue;
            removingItems.add(itemName);
        }
        for (String blockName : this.BLOCK_NAMES) {
            String lowerBlockName;
            if (StringUtils.isNullOrEmpty(blockName) || !(lowerBlockName = blockName.toLowerCase()).contains("tile.") && !lowerBlockName.contains("item.") && !lowerBlockName.contains(".") && !lowerBlockName.contains(".name")) continue;
            removingBlocks.add(blockName);
        }
        this.ITEM_NAMES.removeAll(removingItems);
        this.ITEM_NAMES.removeAll(this.BLOCK_NAMES);
        this.BLOCK_NAMES.removeAll(this.ITEM_NAMES);
        this.BLOCK_NAMES.removeAll(removingBlocks);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_NAMES, this.BLOCK_NAMES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_NAMES, this.ITEM_NAMES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_CLASSES, this.BLOCK_CLASSES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_CLASSES, this.ITEM_CLASSES);
    }
}

