/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils;

import com.google.common.base.Stopwatch;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MappingUtils {
    private static Map<String, String> classMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getClassMap() {
        if (classMap == null) {
            HashMap<String, String> cm;
            block8: {
                cm = new HashMap<String, String>();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(FileUtils.getResourceAsStream(MappingUtils.class, "/mappings.srg")));){
                    ModUtils.LOG.info("Loading Mappings...", new Object[0]);
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    String line = reader.readLine();
                    while (line != null) {
                        String[] parts = line.split(" ");
                        if (parts[0].equals("CL:")) {
                            cm.put(parts[1], parts[2]);
                        }
                        line = reader.readLine();
                    }
                    ModUtils.LOG.info("Loaded Mappings in " + stopwatch.stop(), new Object[0]);
                }
                catch (Throwable e) {
                    if (ModUtils.MCProtocolID > 340) break block8;
                    e.printStackTrace();
                }
            }
            classMap = cm;
        }
        return classMap;
    }

    public static Set<String> getUnmappedClassesMatching(String start) {
        HashSet<String> matches = new HashSet<String>();
        start = start.replace(".", "/");
        for (Map.Entry<String, String> entry : MappingUtils.getClassMap().entrySet()) {
            if (!entry.getValue().startsWith(start)) continue;
            matches.add(entry.getKey().replace("/", "."));
        }
        return matches;
    }

    public static String getClassName(Class<?> object) {
        String result = MappingUtils.getClassMap().get(object.getCanonicalName().replace(".", "/"));
        result = result == null ? object.getSimpleName() : result.substring(result.lastIndexOf("/") + 1);
        return result;
    }

    public static String getClassName(Object object) {
        return MappingUtils.getClassName(object.getClass());
    }
}

